/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.modintegration.jei;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;
import shetiphian.core.client.gui.GuiHelper;
import shetiphian.terraqueous.client.gui.Textures;

public class EnderTableRecipeWrapper {
    private final class_2960 bookshelf = new class_2960("minecraft", "textures/block/bookshelf.png");
    private final class_1799 result;
    private final List<class_1799> inputs;
    private final List<class_1799> materials;
    private final int expCost;
    private final int matCost;
    private final float ePower;

    EnderTableRecipeWrapper(class_1799 result, class_1799[] inputEnchant, class_1799[] inputMaterial, int expCost, int matCost, float ePower) {
        this.result = result;
        this.inputs = this.process(inputEnchant, 1);
        this.materials = this.process(inputMaterial, matCost);
        this.expCost = expCost;
        this.matCost = matCost;
        this.ePower = ePower;
    }

    private List<class_1799> process(class_1799[] input, int size) {
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        for (class_1799 stack : input) {
            stack = stack.method_7972();
            stack.method_7939(size);
            list.add(stack);
        }
        return list;
    }

    public class_1799 getResult() {
        return this.result.method_7972();
    }

    public List<class_1799> getInputs() {
        return ImmutableList.copyOf(this.inputs);
    }

    public List<class_1799> getMaterials() {
        return ImmutableList.copyOf(this.materials);
    }

    public void drawInfo(class_332 graphics, @NotNull class_310 minecraft, double mouseX, double mouseY) {
        class_327 font = minecraft.field_1772;
        String power = " @ " + (int)Math.ceil(this.ePower) + "x ";
        int half = font.method_1727(power) / 2;
        GuiHelper.drawTextureScaled((class_332)graphics, (double)(45 + half), (double)25.0, (int)0, (int)0, (int)16, (int)16, (double)0.5, (int)16, (int)16, (class_2960)this.bookshelf);
        GuiHelper.drawTexture((class_332)graphics, (double)(45 - half - 14), (double)25.0, (int)125, (int)0, (int)14, (int)8, (class_2960)Textures.ENDERTABLE.get());
        graphics.method_51433(font, power, 45 - half, 26, 0x8B8B8B, false);
        String exp = "" + this.expCost;
        graphics.method_25303(font, exp, 54 - font.method_1727(exp), 15, 8453920);
    }

    public List<class_2561> getTooltipStrings(double mouseX, double mouseY) {
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        if (mouseX >= 36.0 && mouseX <= 54.0 && mouseY >= 4.0 && mouseY <= 22.0) {
            list.add((class_2561)class_2561.method_43471((String)"info.terraqueous.exp"));
        } else if (mouseX >= 15.0 && mouseX <= 75.0 && mouseY >= 24.0 && mouseY <= 32.0) {
            float ePower = (float)Math.ceil(this.ePower * 100.0f) / 100.0f;
            list.add((class_2561)class_2561.method_43469((String)"info.terraqueous.visible", (Object[])new Object[]{"" + ePower}));
        }
        return list;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EnderTableRecipeWrapper)) {
            return false;
        }
        EnderTableRecipeWrapper other = (EnderTableRecipeWrapper)obj;
        if (other.result != this.result || other.expCost != this.expCost || other.matCost != this.matCost || other.inputs.size() != this.inputs.size()) {
            return false;
        }
        List<class_1799> tEnchant = this.inputs;
        List<class_1799> oEnchant = other.inputs;
        if (tEnchant.size() != oEnchant.size()) {
            return false;
        }
        for (int index = 0; index < tEnchant.size(); ++index) {
            if (class_1799.method_7973((class_1799)tEnchant.get(index), (class_1799)oEnchant.get(index))) continue;
            return false;
        }
        List<class_1799> tMaterials = this.materials;
        List<class_1799> oMaterials = other.materials;
        if (tMaterials.size() != oMaterials.size()) {
            return false;
        }
        for (int index = 0; index < tMaterials.size(); ++index) {
            if (class_1799.method_7973((class_1799)tMaterials.get(index), (class_1799)oMaterials.get(index))) continue;
            return false;
        }
        return true;
    }
}

