/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.fabric;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.mixins.fabric.PackRepositoryAccessor;
import net.mehvahdjukaar.moonlight.core.network.ClientBoundSpawnCustomEntityMessage;
import net.mehvahdjukaar.moonlight.core.network.ModMessages;
import net.mehvahdjukaar.moonlight.core.network.fabric.ClientBoundOpenScreenMessage;
import net.mehvahdjukaar.moonlight.fabric.MoonlightFabric;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1813;
import net.minecraft.class_1826;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2362;
import net.minecraft.class_2400;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3283;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3414;
import net.minecraft.class_3695;
import net.minecraft.class_3908;
import net.minecraft.class_4048;
import net.minecraft.class_4174;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class PlatHelperImpl {
    private static final Map<class_3264, List<Supplier<class_3288>>> EXTRA_PACKS = new EnumMap<class_3264, List<Supplier<class_3288>>>(class_3264.class);

    public static PlatHelper.Platform getPlatform() {
        return PlatHelper.Platform.FABRIC;
    }

    public static boolean isData() {
        return false;
    }

    public static boolean isModLoaded(String name) {
        return FabricLoader.getInstance().isModLoaded(name);
    }

    @Nullable
    public static <T> Field findField(Class<? super T> clazz, String fieldName) {
        return null;
    }

    @Nullable
    public static Method findMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return null;
    }

    public static boolean isMobGriefingOn(class_1937 level, class_1297 entity) {
        return level.method_8450().method_8355(class_1928.field_19388);
    }

    public static boolean isAreaLoaded(class_4538 level, class_2338 pos, int maxRange) {
        return level.method_22343(pos.method_10069(-maxRange, -maxRange, -maxRange), pos.method_10069(maxRange, maxRange, maxRange));
    }

    public static int getFlammability(class_2680 state, class_1922 level, class_2338 pos, class_2350 face) {
        return ((FlammableBlockRegistry.Entry)FlammableBlockRegistry.getDefaultInstance().get(state.method_26204())).getBurnChance();
    }

    public static PlatHelper.Side getPhysicalSide() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT ? PlatHelper.Side.CLIENT : PlatHelper.Side.SERVER;
    }

    @Nullable
    public static class_4174 getFoodProperties(class_1792 food, class_1799 stack, class_1657 player) {
        return food.method_19264();
    }

    public static boolean isDev() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    public static int getBurnTime(class_1799 stack) {
        Integer v = (Integer)FuelRegistry.INSTANCE.get((class_1935)stack.method_7909());
        if (v == null) {
            return 0;
        }
        return v;
    }

    @Nullable
    public static MinecraftServer getCurrentServer() {
        return MoonlightFabric.getCurrentServer();
    }

    public static class_2596<class_2602> getEntitySpawnPacket(class_1297 entity) {
        ClientBoundSpawnCustomEntityMessage packet = new ClientBoundSpawnCustomEntityMessage(entity);
        class_2540 buf = new class_2540(Unpooled.buffer());
        packet.writeToBuffer(buf);
        return ServerPlayNetworking.createS2CPacket((class_2960)ModMessages.SPAWN_PACKET_ID, (class_2540)buf);
    }

    public static Path getGamePath() {
        return FabricLoader.getInstance().getGameDir();
    }

    public static void registerResourcePack(class_3264 packType, Supplier<class_3288> packSupplier) {
        class_3283 class_32832;
        Moonlight.assertInitPhase();
        EXTRA_PACKS.computeIfAbsent(packType, p -> new ArrayList()).add(packSupplier);
        if (packType == class_3264.field_14188 && PlatHelper.getPhysicalSide().isClient() && (class_32832 = class_310.method_1551().method_1520()) instanceof PackRepositoryAccessor) {
            PackRepositoryAccessor rep = (PackRepositoryAccessor)class_32832;
            HashSet<class_3285> newSources = new HashSet<class_3285>(rep.getSources());
            PlatHelperImpl.getAdditionalPacks(packType).forEach(l -> newSources.add(arg_0 -> PlatHelperImpl.lambda$registerResourcePack$1((Supplier)l, arg_0)));
            rep.setSources(newSources);
        }
    }

    public static Collection<Supplier<class_3288>> getAdditionalPacks(@Nullable class_3264 packType) {
        List<Supplier<class_3288>> suppliers;
        ArrayList<Supplier<class_3288>> list = new ArrayList<Supplier<class_3288>>();
        if (packType == null) {
            List<Supplier<class_3288>> p = EXTRA_PACKS.get(class_3264.field_14188);
            if (p != null) {
                list.addAll(p);
            }
            packType = class_3264.field_14190;
        }
        if ((suppliers = EXTRA_PACKS.get(packType)) != null) {
            list.addAll(suppliers);
        }
        return list;
    }

    public static class_1826 newSpawnEgg(Supplier<? extends class_1299<? extends class_1308>> entityType, int color, int outerColor, class_1792.class_1793 properties) {
        return new class_1826(entityType.get(), color, outerColor, properties);
    }

    public static Path getModFilePath(String modId) {
        return (Path)((ModContainer)FabricLoader.getInstance().getModContainer(modId).get()).getRootPaths().get(0);
    }

    public static String getModPageUrl(String modId) {
        return ((ModContainer)FabricLoader.getInstance().getModContainer(modId).get()).getMetadata().getContact().get("homepage").orElse(null);
    }

    public static String getModName(String modId) {
        return ((ModContainer)FabricLoader.getInstance().getModContainer(modId).get()).getMetadata().getName();
    }

    public static class_2362 newFlowerPot(@Nullable Supplier<class_2362> emptyPot, Supplier<? extends class_2248> supplier, class_4970.class_2251 properties) {
        return new class_2362(supplier.get(), properties);
    }

    public static class_1813 newMusicDisc(int power, Supplier<class_3414> music, class_1792.class_1793 properties, final int secondDuration) {
        class ModRecord
        extends class_1813 {
            protected ModRecord(int i, class_3414 soundEvent, class_1792.class_1793 properties) {
                super(i, soundEvent, properties, n);
            }
        }
        return new ModRecord(power, music.get(), properties);
    }

    public static class_2400 newParticle() {
        return FabricParticleTypes.simple((boolean)true);
    }

    public static <T extends class_2586> class_2591<T> newBlockEntityType(PlatHelper.BlockEntitySupplier<T> blockEntitySupplier, class_2248 ... validBlocks) {
        return FabricBlockEntityTypeBuilder.create(blockEntitySupplier::create, (class_2248[])validBlocks).build();
    }

    public static <E extends class_1297> class_1299<E> newEntityType(String name, class_1299.class_4049<E> factory, class_1311 category, float width, float height, int clientTrackingRange, boolean velocityUpdates, int updateInterval) {
        return FabricEntityTypeBuilder.create((class_1311)category, factory).dimensions(class_4048.method_18384((float)width, (float)height)).trackedUpdateRate(updateInterval).trackRangeChunks(clientTrackingRange).forceTrackedVelocityUpdates(velocityUpdates).build();
    }

    public static void addServerReloadListener(final class_3302 listener, final class_2960 name) {
        Moonlight.assertInitPhase();
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener(new IdentifiableResourceReloadListener(){

            public class_2960 getFabricId() {
                return name;
            }

            public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
                return listener.method_25931(preparationBarrier, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor);
            }
        });
    }

    public static void openCustomMenu(class_3222 player, class_3908 menuProvider, Consumer<class_2540> extraDataProvider) {
        ClientBoundOpenScreenMessage.openMenu(player, menuProvider, extraDataProvider);
    }

    public static boolean isModLoadingValid() {
        return true;
    }

    public static void addCommonSetup(Runnable setup) {
        Moonlight.assertInitPhase();
        MoonlightFabric.COMMON_SETUP_WORK.add(setup);
    }

    public static void addCommonSetupAsync(Runnable setup) {
        PlatHelperImpl.addCommonSetup(setup);
    }

    public static boolean evaluateRecipeCondition(JsonElement jo) {
        if (jo instanceof JsonObject) {
            JsonObject j = (JsonObject)jo;
            ResourceConditions.objectMatchesConditions((JsonObject)j);
        }
        return true;
    }

    public static List<String> getInstalledMods() {
        return FabricLoader.getInstance().getAllMods().stream().map(m -> m.getMetadata().getId()).toList();
    }

    public static class_1657 getFakeServerPlayer(GameProfile id, class_3218 level) {
        return FakePlayer.get((class_3218)level, (GameProfile)id);
    }

    public static boolean isInitializing() {
        return MoonlightFabric.isInitializing();
    }

    public static String getModVersion(String modId) {
        return FabricLoader.getInstance().getModContainer(modId).map(v -> v.getMetadata().getVersion().getFriendlyString()).orElse(null);
    }

    private static /* synthetic */ void lambda$registerResourcePack$1(Supplier l, Consumer infoConsumer) {
        infoConsumer.accept((class_3288)l.get());
    }
}

