/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.extramodintegrations.appeng;

import appeng.core.definitions.AEBlocks;
import appeng.recipes.transform.TransformRecipe;
import com.kneelawk.extramodintegrations.ExMIMod;
import com.kneelawk.extramodintegrations.ExMITextures;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class TransformEmiRecipe
implements EmiRecipe {
    private final TransformRecipe recipe;
    private final class_2960 id;
    private final List<EmiIngredient> inputs;
    private final List<EmiStack> outputs;
    private final EmiIngredient fluidCircumstance;
    private final EmiIngredient explosionCircumstance;

    public TransformEmiRecipe(TransformRecipe recipe) {
        this.recipe = recipe;
        this.id = recipe.method_8114();
        this.inputs = recipe.method_8117().stream().map(EmiIngredient::of).toList();
        this.outputs = List.of(EmiStack.of((class_1799)recipe.getResultItem()));
        this.fluidCircumstance = recipe.circumstance.isFluid() ? EmiIngredient.of(recipe.circumstance.getFluidsForRendering().stream().map(EmiStack::of).toList()) : EmiIngredient.of((class_1856)class_1856.field_9017);
        this.explosionCircumstance = recipe.circumstance.isExplosion() ? EmiIngredient.of(List.of(EmiStack.of((class_1935)class_2246.field_10375), EmiStack.of((class_1935)AEBlocks.TINY_TNT))) : EmiIngredient.of((class_1856)class_1856.field_9017);
    }

    public List<EmiIngredient> getCatalysts() {
        return List.of(this.fluidCircumstance, this.explosionCircumstance);
    }

    public EmiRecipeCategory getCategory() {
        return VanillaEmiRecipeCategories.WORLD_INTERACTION;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return 126;
    }

    public int getDisplayHeight() {
        return 54;
    }

    public void addWidgets(WidgetHolder widgets) {
        switch (this.inputs.size()) {
            case 1: {
                widgets.addSlot(this.inputs.get(0), 0, 18);
                break;
            }
            case 2: {
                widgets.addSlot(this.inputs.get(0), 0, 9);
                widgets.addSlot(this.inputs.get(1), 0, 27);
                break;
            }
            case 3: {
                widgets.addSlot(this.inputs.get(0), 0, 0);
                widgets.addSlot(this.inputs.get(1), 0, 18);
                widgets.addSlot(this.inputs.get(2), 0, 36);
                break;
            }
            default: {
                ExMIMod.LOGGER.warn("Encountered AE2 Transform recipe {} with more than 3 inputs. It will not be rendered correctly.", (Object)this.id);
            }
        }
        widgets.addSlot((EmiIngredient)this.outputs.get(0), 108, 18).recipeContext((EmiRecipe)this);
        widgets.addTexture(ExMITextures.RIGHT_ARROW, 28, 19);
        widgets.addTexture(ExMITextures.RIGHT_ARROW, 82, 19);
        if (this.recipe.circumstance.isFluid()) {
            widgets.addSlot(this.fluidCircumstance, 54, 18).drawBack(false).catalyst(true);
            widgets.addText(ExMIMod.gui("ae2.submerge_in", new Object[0]), 63, 0, -12632257, false).horizontalAlign(TextWidget.Alignment.CENTER);
        }
        if (this.recipe.circumstance.isExplosion()) {
            widgets.addSlot(this.explosionCircumstance, 54, 18).drawBack(false);
            widgets.addText(ExMIMod.gui("ae2.explosion", new Object[0]), 63, 0, -12632257, false).horizontalAlign(TextWidget.Alignment.CENTER);
        }
    }
}

