/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.extramodintegrations.farmersdelight;

import com.kneelawk.extramodintegrations.farmersdelight.FDIntegration;
import com.nhoryzon.mc.farmersdelight.recipe.CuttingBoardRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class CuttingEmiRecipe
implements EmiRecipe {
    private static final class_2960 GUI_TEXTURE = new class_2960("farmersdelight", "textures/gui/rei/cutting_board.png");
    private final class_2960 id;
    private final EmiIngredient input;
    private final EmiIngredient tool;
    private final List<EmiStack> resultList;

    public CuttingEmiRecipe(CuttingBoardRecipe recipe) {
        this.id = recipe.method_8114();
        this.input = EmiIngredient.of((class_1856)((class_1856)recipe.method_8117().get(0)));
        this.tool = EmiIngredient.of((class_1856)recipe.getTool());
        this.resultList = Stream.concat(recipe.getMandatoryResult().stream().map(EmiStack::of), recipe.getVariableResult().stream().map(r -> EmiStack.of((class_1799)r.stack()).setChance(r.chance()))).toList();
    }

    public EmiRecipeCategory getCategory() {
        return FDIntegration.CUTTING_CATEGORY;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(this.input);
    }

    public List<EmiIngredient> getCatalysts() {
        return List.of(this.tool);
    }

    public List<EmiStack> getOutputs() {
        return this.resultList;
    }

    public int getDisplayWidth() {
        return 110;
    }

    public int getDisplayHeight() {
        return 44;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(GUI_TEXTURE, 0, 0, 73, 44, 4, 7);
        widgets.addSlot(this.tool, 11, 0).drawBack(false).catalyst(true);
        widgets.addSlot(this.input, 11, 19).drawBack(false);
        int maxOutputWidth = this.resultList.size() <= 1 ? 18 : 37;
        int maxOutputHeight = 18 + (this.resultList.size() - 1) / 2 * 19;
        Bounds outputBounds = CuttingEmiRecipe.centeredInto(new Bounds(73, 4, 36, 36), maxOutputWidth, maxOutputHeight);
        for (int i = 0; i < this.resultList.size(); ++i) {
            int x = outputBounds.x() + i % 2 * 19;
            int y = outputBounds.y() + i / 2 * 19;
            widgets.addTexture(GUI_TEXTURE, x, y, 18, 18, this.resultList.get(i).getChance() < 1.0f ? 18 : 0, 58);
            widgets.addSlot((EmiIngredient)this.resultList.get(i), x, y).drawBack(false).recipeContext((EmiRecipe)this);
        }
    }

    private static Bounds centeredInto(Bounds origin, int width, int height) {
        return new Bounds(origin.x() + (origin.width() - width) / 2, origin.y() + (origin.height() - height) / 2, width, height);
    }
}

