/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mindfuldarkness.client.handler;

import fuzs.mindfuldarkness.MindfulDarkness;
import fuzs.mindfuldarkness.client.util.HSPConversionUtil;
import fuzs.mindfuldarkness.client.util.RGBBrightnessUtil;
import fuzs.mindfuldarkness.config.ClientConfig;
import java.util.Objects;
import java.util.OptionalInt;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_332;
import net.minecraft.class_3872;
import net.minecraft.class_437;
import net.minecraft.class_473;
import net.minecraft.class_7417;
import org.jetbrains.annotations.Nullable;

public class FontColorHandler {
    private static boolean renderInDarkness;

    public static void onBeforeRender(class_437 screen, class_332 guiGraphics, int mouseX, int mouseY, float tickDelta) {
        String identifier = FontColorHandler.identifyScreen(screen);
        if (identifier == null || !((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).fontColorBlacklist.contains(identifier)) {
            renderInDarkness = true;
        }
    }

    @Nullable
    public static String identifyScreen(class_437 screen) {
        Objects.requireNonNull(screen, "screen is null");
        class_2561 title = screen.method_25440();
        class_7417 class_74172 = title.method_10851();
        if (class_74172 instanceof class_2585) {
            class_2585 literalContents = (class_2585)class_74172;
            return literalContents.comp_737();
        }
        class_74172 = title.method_10851();
        if (class_74172 instanceof class_2588) {
            class_2588 translatableContents = (class_2588)class_74172;
            return translatableContents.method_11022();
        }
        if (screen instanceof class_473) {
            return "book.edit";
        }
        if (screen instanceof class_3872) {
            return "book.view";
        }
        return null;
    }

    public static void onAfterRender(class_437 screen, class_332 guiGraphics, int mouseX, int mouseY, float tickDelta) {
        renderInDarkness = false;
    }

    public static int adjustFontColor(int fontColor) {
        if (renderInDarkness && MindfulDarkness.CONFIG.getHolder(ClientConfig.class).isAvailable() && ((Boolean)((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).darkTheme.get()).booleanValue()) {
            return FontColorHandler.tryAdjustColor(fontColor).orElse(fontColor);
        }
        return fontColor;
    }

    private static OptionalInt tryAdjustColor(int color) {
        double targetBrightness;
        double[] hspColorArray = RGBBrightnessUtil.unpackRGBToHSP(color);
        if (hspColorArray[2] < (targetBrightness = ((Double)((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).fontBrightness.get()).doubleValue())) {
            double[] rgbColorArray = HSPConversionUtil.HSPtoRGB(hspColorArray[0], hspColorArray[1], targetBrightness);
            return OptionalInt.of(RGBBrightnessUtil.packRGBColor(rgbColorArray));
        }
        return OptionalInt.empty();
    }
}

