/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.api.server.permission;

import com.google.common.collect.Maps;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.api.server.permission.PermissionDefault;

public final class PermissionsManager {
    private static final PermissionDefault DEFAULT_PERMISSION = PermissionDefault.OP;
    private final Map<String, PermissionDefault> defaultPermissionByName = Maps.newHashMap();

    public void register(@NotNull String name, @NotNull PermissionDefault permissionDefault) {
        this.defaultPermissionByName.put(name, permissionDefault);
    }

    public boolean unregister(@NotNull String name) {
        return this.defaultPermissionByName.remove(name) != null;
    }

    public void clear() {
        this.defaultPermissionByName.clear();
    }

    public PermissionDefault getPermissionDefault(@NotNull String name) {
        return this.defaultPermissionByName.getOrDefault(name, DEFAULT_PERMISSION);
    }
}

