/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.audio.codec.opus;

import su.plo.opus.concentus.OpusApplication;
import su.plo.opus.concentus.OpusEncoder;
import su.plo.opus.concentus.OpusException;
import su.plo.voice.api.audio.codec.CodecException;
import su.plo.voice.audio.codec.opus.BaseOpusEncoder;
import su.plo.voice.proto.data.audio.codec.opus.OpusMode;

public final class JavaOpusEncoder
implements BaseOpusEncoder {
    private final int sampleRate;
    private final int channels;
    private final int bufferSize;
    private final int mtuSize;
    private OpusApplication application;
    private OpusEncoder encoder;
    private byte[] buffer;

    public JavaOpusEncoder(int sampleRate, boolean stereo, int bufferSize, OpusMode opusMode, int mtuSize) {
        this.sampleRate = sampleRate;
        this.channels = stereo ? 2 : 1;
        this.bufferSize = bufferSize;
        this.mtuSize = mtuSize;
        this.setApplication(opusMode);
    }

    @Override
    public byte[] encode(short[] samples) throws CodecException {
        int result2;
        if (!this.isOpen()) {
            throw new CodecException("Encoder is not open");
        }
        try {
            result2 = this.encoder.encode(samples, 0, this.bufferSize, this.buffer, 0, this.mtuSize);
        }
        catch (OpusException e) {
            throw new CodecException("Failed to encode audio", e);
        }
        byte[] encoded = new byte[result2];
        System.arraycopy(this.buffer, 0, encoded, 0, result2);
        return encoded;
    }

    @Override
    public void open() throws CodecException {
        try {
            this.encoder = new OpusEncoder(this.sampleRate, this.channels, this.application);
            this.buffer = new byte[this.mtuSize];
        }
        catch (OpusException e) {
            throw new CodecException("Failed to open opus encoder", e);
        }
    }

    @Override
    public void reset() {
        if (!this.isOpen()) {
            return;
        }
        this.encoder.resetState();
    }

    @Override
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        this.encoder = null;
        this.buffer = null;
    }

    @Override
    public boolean isOpen() {
        return this.encoder != null;
    }

    private void setApplication(OpusMode opusMode) {
        if (opusMode == OpusMode.VOIP) {
            this.application = OpusApplication.OPUS_APPLICATION_VOIP;
        } else if (opusMode == OpusMode.AUDIO) {
            this.application = OpusApplication.OPUS_APPLICATION_AUDIO;
        } else if (opusMode == OpusMode.RESTRICTED_LOWDELAY) {
            this.application = OpusApplication.OPUS_APPLICATION_RESTRICTED_LOWDELAY;
        }
    }

    @Override
    public void setBitrate(int bitrate) {
        if (!this.isOpen()) {
            return;
        }
        this.encoder.setBitrate(bitrate);
    }

    @Override
    public int getBitrate() {
        if (!this.isOpen()) {
            return -1;
        }
        return this.encoder.getBitrate();
    }
}

