/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.audio.codec.opus;

import com.sun.jna.ptr.PointerByReference;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import su.plo.opus.Opus;
import su.plo.voice.api.audio.codec.CodecException;
import su.plo.voice.audio.codec.opus.BaseOpusEncoder;
import su.plo.voice.proto.data.audio.codec.opus.OpusMode;

public final class NativeOpusEncoder
implements BaseOpusEncoder {
    private final int sampleRate;
    private final int bufferSize;
    private final int channels;
    private final OpusMode opusMode;
    private final int mtuSize;
    private PointerByReference encoder;
    private ByteBuffer buffer;

    public NativeOpusEncoder(int sampleRate, boolean stereo, int bufferSize, OpusMode opusMode, int mtuSize) {
        this.sampleRate = sampleRate;
        this.channels = stereo ? 2 : 1;
        this.bufferSize = bufferSize;
        this.opusMode = opusMode;
        this.mtuSize = mtuSize;
    }

    @Override
    public byte[] encode(short[] samples) throws CodecException {
        if (!this.isOpen()) {
            throw new CodecException("Encoder is not open");
        }
        ShortBuffer shortSamples = ShortBuffer.wrap(samples);
        this.buffer.clear();
        int result2 = Opus.INSTANCE.opus_encode(this.encoder, shortSamples, this.bufferSize, this.buffer, this.mtuSize);
        if (result2 < 0) {
            throw new CodecException("Failed to encode audio: " + Opus.INSTANCE.opus_strerror(result2));
        }
        byte[] encoded = new byte[result2];
        this.buffer.get(encoded);
        return encoded;
    }

    @Override
    public void open() throws CodecException {
        IntBuffer error = IntBuffer.allocate(1);
        this.encoder = Opus.INSTANCE.opus_encoder_create(this.sampleRate, this.channels, this.opusMode.getApplication(), error);
        this.buffer = ByteBuffer.allocate(this.mtuSize);
        if (error.get() != 0 && this.encoder == null) {
            throw new CodecException("Failed to open opus encoder:" + Opus.INSTANCE.opus_strerror(error.get()));
        }
    }

    @Override
    public void reset() {
        if (!this.isOpen()) {
            return;
        }
        Opus.INSTANCE.opus_encoder_ctl(this.encoder, 4028, new Object[0]);
    }

    @Override
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        Opus.INSTANCE.opus_encoder_destroy(this.encoder);
        this.encoder = null;
        this.buffer = null;
    }

    @Override
    public boolean isOpen() {
        return this.encoder != null;
    }

    @Override
    public void setBitrate(int bitrate) {
        if (!this.isOpen()) {
            return;
        }
        Opus.INSTANCE.opus_encoder_ctl(this.encoder, 4002, bitrate);
    }

    @Override
    public int getBitrate() {
        IntBuffer request = IntBuffer.allocate(1);
        Opus.INSTANCE.opus_encoder_ctl(this.encoder, 4003, request);
        return request.get();
    }
}

