/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.device.source;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.openal.AL11;
import org.lwjgl.system.MemoryUtil;
import su.plo.voice.BaseVoice;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.device.DeviceException;
import su.plo.voice.api.client.audio.device.source.AlSource;
import su.plo.voice.api.client.event.audio.device.source.AlSourceBufferQueuedEvent;
import su.plo.voice.api.client.event.audio.device.source.AlSourceBufferUnqueuedEvent;
import su.plo.voice.api.client.event.audio.device.source.AlSourceClosedEvent;
import su.plo.voice.api.client.event.audio.device.source.AlSourceCreatedEvent;
import su.plo.voice.api.client.event.audio.device.source.AlSourcePlayEvent;
import su.plo.voice.api.client.event.audio.device.source.AlSourceStopEvent;
import su.plo.voice.api.client.event.audio.device.source.AlSourceWriteEvent;
import su.plo.voice.api.client.event.audio.device.source.AlStreamSourceStoppedEvent;
import su.plo.voice.api.event.Event;
import su.plo.voice.client.audio.AlUtil;
import su.plo.voice.client.audio.device.AlOutputDevice;
import su.plo.voice.client.audio.device.source.BaseAlSource;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.ResultKt;
import su.plo.voice.libs.kotlin.Unit;
import su.plo.voice.libs.kotlin.coroutines.Continuation;
import su.plo.voice.libs.kotlin.coroutines.intrinsics.IntrinsicsKt;
import su.plo.voice.libs.kotlin.jvm.JvmStatic;
import su.plo.voice.libs.kotlin.jvm.functions.Function1;
import su.plo.voice.libs.kotlin.jvm.functions.Function2;
import su.plo.voice.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlinx.coroutines.BuildersKt;
import su.plo.voice.libs.kotlinx.coroutines.CoroutineScope;
import su.plo.voice.libs.kotlinx.coroutines.DelayKt;
import su.plo.voice.libs.kotlinx.coroutines.Job;
import su.plo.voice.libs.kotlinx.coroutines.future.FutureKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 /2\u00020\u0001:\u0001/B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u001c\u001a\u00020\u001dH\u0096@\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010!0 H\u0016J\b\u0010\"\u001a\u00020\u001dH\u0002J\u0010\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\tH\u0002J\b\u0010%\u001a\u00020\u001dH\u0002J\b\u0010&\u001a\u00020\u001dH\u0016J\b\u0010'\u001a\u00020\u001dH\u0002J\b\u0010(\u001a\u00020\u001dH\u0002J\u0010\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u0010H\u0016J\b\u0010+\u001a\u00020\u001dH\u0002J\b\u0010,\u001a\u00020\u001dH\u0016J\u0010\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u0012H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lsu/plo/voice/client/audio/device/source/StreamAlSource;", "Lsu/plo/voice/client/audio/device/source/BaseAlSource;", "client", "Lsu/plo/voice/api/client/PlasmoVoiceClient;", "device", "Lsu/plo/voice/client/audio/device/AlOutputDevice;", "stereo", "", "numBuffers", "", "pointer", "(Lsu/plo/voice/api/client/PlasmoVoiceClient;Lsu/plo/voice/client/audio/device/AlOutputDevice;ZII)V", "availableBuffer", "", "buffers", "closeTimeoutMs", "", "emptyBuffer", "", "emptyFilled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isStreaming", "job", "Lsu/plo/voice/libs/kotlinx/coroutines/Job;", "lastBufferTime", "queue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Ljava/nio/ByteBuffer;", "close", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "closeAsync", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "closeSync", "fillAndPushBuffer", "buffer", "fillQueue", "play", "queueWithEmptyBuffers", "removeProcessedBuffers", "setCloseTimeoutMs", "timeoutMs", "startStreamThread", "stop", "write", "samples", "Companion", "plasmovoice-fabric-1.20.1"})
public final class StreamAlSource
extends BaseAlSource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long closeTimeoutMs = 25000L;
    private final int numBuffers;
    @NotNull
    private final LinkedBlockingQueue<ByteBuffer> queue = new LinkedBlockingQueue();
    @NotNull
    private final AtomicBoolean isStreaming = new AtomicBoolean(false);
    @NotNull
    private final byte[] emptyBuffer;
    @Nullable
    private Job job;
    private int[] buffers;
    @NotNull
    private final int[] availableBuffer = new int[1];
    @NotNull
    private final AtomicBoolean emptyFilled = new AtomicBoolean(false);
    private long lastBufferTime;
    private static final Logger LOGGER = LogManager.getLogger(StreamAlSource.class);
    private static final int DEFAULT_NUM_BUFFERS = 8;

    private StreamAlSource(PlasmoVoiceClient client, AlOutputDevice device, boolean stereo, int numBuffers, int pointer) {
        super(client, device, stereo, pointer);
        this.numBuffers = numBuffers == 0 ? 8 : numBuffers;
        this.emptyBuffer = new byte[device.getBufferSize()];
    }

    @Override
    public void play() {
        AlUtil.checkDeviceContext(this.device);
        if (!this.client.getEventBus().call((Event)new AlSourcePlayEvent(this))) {
            return;
        }
        boolean isStreaming = this.isStreaming.get();
        AlSource.State state = this.getState();
        if (isStreaming && state == AlSource.State.PAUSED) {
            AL11.alSourcePlay((int)this.pointer);
            AlUtil.checkErrors("Source play");
            return;
        }
        if (isStreaming) {
            return;
        }
        Job job = this.job;
        boolean bl = job != null ? !job.isActive() : false;
        if (bl) {
            this.stop();
        }
        this.startStreamThread();
    }

    @Override
    public void stop() {
        AlSourceStopEvent alSourceStopEvent;
        AlUtil.checkDeviceContext(this.device);
        AlSourceStopEvent it = alSourceStopEvent = new AlSourceStopEvent(this);
        boolean bl = false;
        if (!this.client.getEventBus().call((Event)it)) {
            return;
        }
        AL11.alSourceStop((int)this.pointer);
        AlUtil.checkErrors("Source stop");
        this.isStreaming.set(false);
        this.queue.clear();
    }

    @Override
    public void setCloseTimeoutMs(long timeoutMs) {
        this.closeTimeoutMs = timeoutMs;
    }

    @Override
    public void write(@NotNull byte[] samples) {
        Intrinsics.checkNotNullParameter(samples, "samples");
        if (!this.isStreaming.get()) {
            return;
        }
        if (samples.length == 0) {
            this.write(this.emptyBuffer);
            return;
        }
        if (this.queue.size() > 100) {
            BaseVoice.DEBUG_LOGGER.log("Queue overflow, dropping samples", new Object[0]);
            return;
        }
        ByteBuffer buffer = MemoryUtil.memAlloc((int)samples.length);
        buffer.put(samples);
        Intrinsics.checkNotNull(buffer, "null cannot be cast to non-null type java.nio.Buffer");
        ((Buffer)buffer).flip();
        if (!this.client.getEventBus().call((Event)new AlSourceWriteEvent(this, buffer))) {
            return;
        }
        this.queue.offer(buffer);
        if (!Intrinsics.areEqual(samples, this.emptyBuffer)) {
            this.emptyFilled.set(false);
            this.lastBufferTime = System.currentTimeMillis();
        }
    }

    @Override
    @Nullable
    public Object close(@NotNull Continuation<? super Unit> $completion) {
        if (!this.isStreaming.get()) {
            return Unit.INSTANCE;
        }
        Object object = this.device.runInContext((Function1<? super Continuation<? super Unit>, ? extends Object>)new Function1<Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ StreamAlSource this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        StreamAlSource.access$closeSync(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> closeAsync() {
        if (!this.isStreaming.get()) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, "completedFuture(...)");
            return completableFuture;
        }
        return FutureKt.future$default(this.device.getCoroutineScope(), null, null, new Function2<CoroutineScope, Continuation<? super Void>, Object>(this, null){
            int label;
            final /* synthetic */ StreamAlSource this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        StreamAlSource.access$closeSync(this.this$0);
                        return null;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Void> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    private final void closeSync() {
        this.stop();
        this.client.getEventBus().call((Event)new AlSourceClosedEvent(this));
        this.removeProcessedBuffers();
        int[] nArray = this.buffers;
        if (this.buffers == null) {
            Intrinsics.throwUninitializedPropertyAccessException("buffers");
            nArray = null;
        }
        AL11.alDeleteBuffers((int[])nArray);
        AlUtil.checkErrors("Delete buffers");
        int[] nArray2 = new int[]{this.pointer};
        AL11.alDeleteSources((int[])nArray2);
        AlUtil.checkErrors("Delete source");
        this.pointer = 0;
    }

    private final void startStreamThread() {
        this.isStreaming.set(true);
        StreamAlSource alSource = this;
        BuildersKt.launch$default(this.device.getCoroutineScope(), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, alSource, null){
            int label;
            final /* synthetic */ StreamAlSource this$0;
            final /* synthetic */ StreamAlSource $alSource;
            {
                this.this$0 = $receiver;
                this.$alSource = $alSource;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                block0 : switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        StreamAlSource.access$setBuffers$p(this.this$0, new int[StreamAlSource.access$getNumBuffers$p(this.this$0)]);
                        v0 = StreamAlSource.access$getBuffers$p(this.this$0);
                        if (v0 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("buffers");
                            v0 = null;
                        }
                        AL11.alGenBuffers((int[])v0);
                        AlUtil.checkErrors("Source gen buffers");
                        StreamAlSource.access$queueWithEmptyBuffers(this.this$0);
                        StreamAlSource.access$fillQueue(this.this$0);
                        StreamAlSource.access$setLastBufferTime$p(this.this$0, System.currentTimeMillis());
                        StreamAlSource.access$getAvailableBuffer$p((StreamAlSource)this.this$0)[0] = -1;
lbl17:
                        // 3 sources

                        while (StreamAlSource.access$isStreaming$p(this.this$0).get()) {
                            queueSize = StreamAlSource.access$getQueue$p(this.this$0).size();
                            processedBuffers = this.this$0.getInt(4118);
                            AlUtil.checkErrors("Get processed buffers");
                            while (processedBuffers > 0 || StreamAlSource.access$getAvailableBuffer$p(this.this$0)[0] != -1) {
                                if (StreamAlSource.access$getAvailableBuffer$p(this.this$0)[0] == -1) {
                                    AL11.alSourceUnqueueBuffers((int)this.this$0.pointer, (int[])StreamAlSource.access$getAvailableBuffer$p(this.this$0));
                                    AlUtil.checkErrors("Unqueue buffer");
                                    bits = AL11.alGetBufferi((int)StreamAlSource.access$getAvailableBuffer$p(this.this$0)[0], (int)8194);
                                    AlUtil.checkErrors("Source get buffer int");
                                    if (bits == 0) {
                                        StreamAlSource.access$getLOGGER$cp().warn("Corrupted stream");
                                        continue;
                                    }
                                    if (StreamAlSource.access$getAvailableBuffer$p(this.this$0)[0] != -1) {
                                        unqueuedEvent = new AlSourceBufferUnqueuedEvent(this.$alSource, StreamAlSource.access$getAvailableBuffer$p(this.this$0)[0]);
                                        this.this$0.client.getEventBus().call((Event)unqueuedEvent);
                                    }
                                }
                                if (StreamAlSource.access$getAvailableBuffer$p(this.this$0)[0] == -1 || !StreamAlSource.access$fillAndPushBuffer(this.this$0, StreamAlSource.access$getAvailableBuffer$p(this.this$0)[0])) break;
                                StreamAlSource.access$getAvailableBuffer$p((StreamAlSource)this.this$0)[0] = -1;
                                --processedBuffers;
                            }
                            if ((state = this.this$0.getState()) == AlSource.State.STOPPED && queueSize == 0 && !StreamAlSource.access$getEmptyFilled$p(this.this$0).get()) {
                                StreamAlSource.access$removeProcessedBuffers(this.this$0);
                                StreamAlSource.access$getAvailableBuffer$p((StreamAlSource)this.this$0)[0] = -1;
                                StreamAlSource.access$queueWithEmptyBuffers(this.this$0);
                                StreamAlSource.access$fillQueue(this.this$0);
                                this.this$0.client.getEventBus().call((Event)new AlStreamSourceStoppedEvent(this.$alSource));
                                this.this$0.play();
                                AL11.alSourcePlay((int)this.this$0.pointer);
                                AlUtil.checkErrors("Source play");
                            } else if (state != AlSource.State.PLAYING && state != AlSource.State.PAUSED && queueSize > 0) {
                                AL11.alSourcePlay((int)this.this$0.pointer);
                                AlUtil.checkErrors("Source play");
                            }
                            if (StreamAlSource.access$getCloseTimeoutMs$p(this.this$0) <= 0L || System.currentTimeMillis() - StreamAlSource.access$getLastBufferTime$p(this.this$0) <= StreamAlSource.access$getCloseTimeoutMs$p(this.this$0)) break block0;
                            BaseVoice.DEBUG_LOGGER.log("Stream timed out. Closing...", new Object[0]);
                            this.label = 1;
                            v1 = this.this$0.close(this);
                            if (v1 == var6_2) {
                                return var6_2;
                            }
                            break block0;
                        }
                        break;
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
                        break;
                    }
                }
                this.label = 2;
                v2 = DelayKt.delay(5L, this);
                if (v2 != var6_2) ** GOTO lbl17
                return var6_2;
                {
                    case 2: {
                        ResultKt.throwOnFailure($result);
                        v2 = $result;
                        ** GOTO lbl17
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    private final void queueWithEmptyBuffers() {
        int n = this.numBuffers;
        for (int i = 0; i < n; ++i) {
            this.write(this.emptyBuffer);
        }
        this.emptyFilled.set(true);
    }

    private final void fillQueue() {
        int n = this.numBuffers;
        for (int i = 0; i < n; ++i) {
            int[] nArray = this.buffers;
            if (this.buffers == null) {
                Intrinsics.throwUninitializedPropertyAccessException("buffers");
                nArray = null;
            }
            this.fillAndPushBuffer(nArray[i]);
        }
    }

    private final boolean fillAndPushBuffer(int buffer) {
        ByteBuffer byteBuffer = this.queue.poll();
        if (byteBuffer == null) {
            return false;
        }
        ByteBuffer byteBuffer2 = byteBuffer;
        AL11.alBufferData((int)buffer, (int)this.format, (ByteBuffer)byteBuffer2, (int)((int)this.device.getFormat().getSampleRate()));
        if (AlUtil.checkErrors("Assigning buffer data")) {
            return false;
        }
        int[] nArray = new int[]{buffer};
        AL11.alSourceQueueBuffers((int)this.pointer, (int[])nArray);
        if (AlUtil.checkErrors("Queue buffer data")) {
            return false;
        }
        this.client.getEventBus().call((Event)new AlSourceBufferQueuedEvent(this, byteBuffer2, buffer));
        return true;
    }

    private final void removeProcessedBuffers() {
        AlUtil.checkErrors("Get processed buffers");
        for (int processedBuffers = this.getInt(4118); processedBuffers > 0; --processedBuffers) {
            int[] buffer = new int[1];
            AL11.alSourceUnqueueBuffers((int)this.pointer, (int[])buffer);
            AlUtil.checkErrors("Unqueue buffer");
        }
    }

    @JvmStatic
    @NotNull
    public static final AlSource create(@NotNull AlOutputDevice device, @NotNull PlasmoVoiceClient client, boolean stereo, int numBuffers) {
        return Companion.create(device, client, stereo, numBuffers);
    }

    public static final /* synthetic */ void access$closeSync(StreamAlSource $this) {
        $this.closeSync();
    }

    public static final /* synthetic */ void access$setBuffers$p(StreamAlSource $this, int[] nArray) {
        $this.buffers = nArray;
    }

    public static final /* synthetic */ int access$getNumBuffers$p(StreamAlSource $this) {
        return $this.numBuffers;
    }

    public static final /* synthetic */ int[] access$getBuffers$p(StreamAlSource $this) {
        return $this.buffers;
    }

    public static final /* synthetic */ void access$queueWithEmptyBuffers(StreamAlSource $this) {
        $this.queueWithEmptyBuffers();
    }

    public static final /* synthetic */ void access$fillQueue(StreamAlSource $this) {
        $this.fillQueue();
    }

    public static final /* synthetic */ void access$setLastBufferTime$p(StreamAlSource $this, long l) {
        $this.lastBufferTime = l;
    }

    public static final /* synthetic */ int[] access$getAvailableBuffer$p(StreamAlSource $this) {
        return $this.availableBuffer;
    }

    public static final /* synthetic */ AtomicBoolean access$isStreaming$p(StreamAlSource $this) {
        return $this.isStreaming;
    }

    public static final /* synthetic */ LinkedBlockingQueue access$getQueue$p(StreamAlSource $this) {
        return $this.queue;
    }

    public static final /* synthetic */ Logger access$getLOGGER$cp() {
        return LOGGER;
    }

    public static final /* synthetic */ boolean access$fillAndPushBuffer(StreamAlSource $this, int buffer) {
        return $this.fillAndPushBuffer(buffer);
    }

    public static final /* synthetic */ AtomicBoolean access$getEmptyFilled$p(StreamAlSource $this) {
        return $this.emptyFilled;
    }

    public static final /* synthetic */ void access$removeProcessedBuffers(StreamAlSource $this) {
        $this.removeProcessedBuffers();
    }

    public static final /* synthetic */ long access$getCloseTimeoutMs$p(StreamAlSource $this) {
        return $this.closeTimeoutMs;
    }

    public static final /* synthetic */ long access$getLastBufferTime$p(StreamAlSource $this) {
        return $this.lastBufferTime;
    }

    public /* synthetic */ StreamAlSource(PlasmoVoiceClient client, AlOutputDevice device, boolean stereo, int numBuffers, int pointer, DefaultConstructorMarker $constructor_marker) {
        this(client, device, stereo, numBuffers, pointer);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lsu/plo/voice/client/audio/device/source/StreamAlSource$Companion;", "", "()V", "DEFAULT_NUM_BUFFERS", "", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "su.plo.voice.libs.kotlin.jvm.PlatformType", "create", "Lsu/plo/voice/api/client/audio/device/source/AlSource;", "device", "Lsu/plo/voice/client/audio/device/AlOutputDevice;", "client", "Lsu/plo/voice/api/client/PlasmoVoiceClient;", "stereo", "", "numBuffers", "plasmovoice-fabric-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final AlSource create(@NotNull AlOutputDevice device, @NotNull PlasmoVoiceClient client, boolean stereo, int numBuffers) {
            StreamAlSource streamAlSource;
            Intrinsics.checkNotNullParameter(device, "device");
            Intrinsics.checkNotNullParameter(client, "client");
            AlUtil.checkDeviceContext(device);
            int[] pointer = new int[1];
            AL11.alGenSources((int[])pointer);
            if (AlUtil.checkErrors("Allocate new source")) {
                throw new DeviceException("Failed to allocate new source");
            }
            StreamAlSource source = streamAlSource = new StreamAlSource(client, device, stereo, numBuffers, pointer[0], null);
            boolean bl = false;
            client.getEventBus().call((Event)new AlSourceCreatedEvent(source));
            return streamAlSource;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

