/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.line;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import su.plo.config.entry.DoubleConfigEntry;
import su.plo.config.entry.EnumConfigEntry;
import su.plo.lib.api.MathLib;
import su.plo.voice.api.client.audio.line.ClientSourceLine;
import su.plo.voice.api.client.audio.line.ClientSourceLineManager;
import su.plo.voice.api.client.config.overlay.OverlaySourceState;
import su.plo.voice.client.audio.line.VoiceClientSourceLine;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.render.voice.VoiceIconUtil;
import su.plo.voice.proto.data.audio.line.SourceLine;
import su.plo.voice.proto.data.audio.line.VoiceSourceLine;

public final class VoiceClientSourceLineManager
implements ClientSourceLineManager {
    private final VoiceClientConfig config;
    private final List<ClientSourceLine> lines = new CopyOnWriteArrayList<ClientSourceLine>(){

        @Override
        public boolean add(ClientSourceLine sourceLine) {
            int index;
            for (index = 0; index < this.size(); ++index) {
                ClientSourceLine lineToCompare = (ClientSourceLine)this.get(index);
                if (sourceLine.getWeight() > lineToCompare.getWeight() || sourceLine.getWeight() == lineToCompare.getWeight() && sourceLine.getName().compareToIgnoreCase(lineToCompare.getName()) == -1) break;
            }
            super.add(index, sourceLine);
            return true;
        }
    };
    private final Map<UUID, ClientSourceLine> lineById = Maps.newConcurrentMap();

    @Override
    public Optional<ClientSourceLine> getLineById(@NotNull UUID id) {
        return Optional.ofNullable(this.lineById.get(id));
    }

    @Override
    public Optional<ClientSourceLine> getLineByName(@NotNull String name) {
        return Optional.ofNullable(this.lineById.get(VoiceSourceLine.generateId(name)));
    }

    @Override
    public Collection<ClientSourceLine> getLines() {
        return this.lines;
    }

    @Override
    public boolean unregister(@NotNull UUID id) {
        ClientSourceLine line = this.lineById.remove(id);
        if (line != null) {
            return this.lines.remove(line);
        }
        return false;
    }

    @Override
    public boolean unregister(@NotNull String name) {
        return this.unregister(VoiceSourceLine.generateId(name));
    }

    @Override
    public boolean unregister(@NotNull ClientSourceLine line) {
        return this.unregister(line.getId());
    }

    @Override
    public void clear() {
        this.lines.clear();
        this.lineById.clear();
    }

    @Override
    @NotNull
    public ClientSourceLine register(@NotNull ClientSourceLine line) {
        this.unregister(line.getId());
        this.lines.add(line);
        this.lineById.put(line.getId(), line);
        return line;
    }

    @Override
    @NotNull
    public ClientSourceLine register(@NotNull SourceLine line) {
        this.unregister(line.getId());
        EnumConfigEntry<OverlaySourceState> stateEntry = this.config.getOverlay().getSourceStates().getState(line);
        if (line.hasPlayers()) {
            if (((OverlaySourceState)((Object)stateEntry.value())).isProximityOnly()) {
                stateEntry.set(OverlaySourceState.WHEN_TALKING);
            }
            stateEntry.setDefault(OverlaySourceState.WHEN_TALKING);
        } else {
            if (!((OverlaySourceState)((Object)stateEntry.value())).isProximityOnly()) {
                stateEntry.set(OverlaySourceState.OFF);
            }
            stateEntry.setDefault(OverlaySourceState.OFF);
        }
        String icon = VoiceIconUtil.INSTANCE.getIcon(line.getIcon(), new class_2960("plasmovoice:textures/addons/source_lines/" + line.getName()));
        DoubleConfigEntry volumeEntry = this.config.getVoice().getVolumes().getVolume(line.getName());
        volumeEntry.setDefault(MathLib.clamp(line.getDefaultVolume(), 0.0, 1.0));
        VoiceClientSourceLine clientLine = new VoiceClientSourceLine(volumeEntry, line, icon);
        return this.register(clientLine);
    }

    @Override
    @NotNull
    public Collection<ClientSourceLine> register(@NotNull Collection<SourceLine> lines) {
        return lines.stream().map(this::register).collect(Collectors.toList());
    }

    public VoiceClientSourceLineManager(VoiceClientConfig config) {
        this.config = config;
    }
}

