/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.config.addon;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.config.entry.BooleanConfigEntry;
import su.plo.config.entry.ConfigEntry;
import su.plo.config.entry.DoubleConfigEntry;
import su.plo.config.entry.IntConfigEntry;
import su.plo.voice.api.addon.AddonContainer;
import su.plo.voice.api.client.config.addon.AddonConfig;
import su.plo.voice.client.config.VoiceClientConfig;

public final class VoiceAddonConfig
implements AddonConfig {
    private final AddonContainer addon;
    private final VoiceClientConfig.Addons.Addon config;
    private final Map<String, ConfigWidget> widgetsByTranslatable = Maps.newConcurrentMap();
    private final List<ConfigWidget> widgets = Lists.newCopyOnWriteArrayList();

    @Override
    @NotNull
    public IntConfigEntry addIntSlider(@NotNull String translatable, @Nullable String tooltipTranslatable, @NotNull String suffix, int defaultValue, int min, int max) {
        this.checkWidgetExists(translatable);
        IntConfigEntry configEntry = this.config.getEntry(translatable).map(IntConfigEntry.class::cast).orElseGet(this.createEntry(translatable, () -> new IntConfigEntry(defaultValue, min, max)));
        configEntry.setDefault(defaultValue, min, max);
        this.addWidget(new ConfigSliderWidget(ConfigWidget.Type.INT_SLIDER, translatable, tooltipTranslatable, configEntry, suffix));
        return configEntry;
    }

    @Override
    @NotNull
    public DoubleConfigEntry addVolumeSlider(@NotNull String translatable, @Nullable String tooltipTranslatable, @NotNull String suffix, double defaultValue, double min, double max) {
        this.checkWidgetExists(translatable);
        DoubleConfigEntry configEntry = this.config.getEntry(translatable).map(DoubleConfigEntry.class::cast).orElseGet(this.createEntry(translatable, () -> new DoubleConfigEntry(defaultValue, min, max)));
        configEntry.setDefault(defaultValue, min, max);
        this.addWidget(new ConfigSliderWidget(ConfigWidget.Type.VOLUME_SLIDER, translatable, tooltipTranslatable, configEntry, suffix));
        return configEntry;
    }

    @Override
    @NotNull
    public BooleanConfigEntry addToggle(@NotNull String translatable, @Nullable String tooltipTranslatable, boolean defaultValue) {
        this.checkWidgetExists(translatable);
        BooleanConfigEntry configEntry = this.config.getEntry(translatable).map(BooleanConfigEntry.class::cast).orElseGet(this.createEntry(translatable, () -> new BooleanConfigEntry(defaultValue)));
        configEntry.setDefault(defaultValue);
        this.addWidget(new ConfigWidget(ConfigWidget.Type.TOGGLE, translatable, tooltipTranslatable, configEntry));
        return configEntry;
    }

    @Override
    @NotNull
    public IntConfigEntry addDropDown(@NotNull String translatable, @Nullable String tooltipTranslatable, @NotNull List<String> elements, boolean elementTooltip, int defaultValue) {
        this.checkWidgetExists(translatable);
        IntConfigEntry configEntry = this.config.getEntry(translatable).map(IntConfigEntry.class::cast).orElseGet(this.createEntry(translatable, () -> new IntConfigEntry(defaultValue, 0, 0)));
        configEntry.setDefault(defaultValue);
        this.addWidget(new ConfigDropDownWidget(translatable, tooltipTranslatable, configEntry, elements, elementTooltip));
        return configEntry;
    }

    @Override
    public boolean removeWidget(@NotNull String translatable) {
        return Optional.ofNullable(this.widgetsByTranslatable.remove(translatable)).filter(this.widgets::remove).isPresent();
    }

    @Override
    public <T extends ConfigEntry<?>> Optional<T> getValue(@NotNull String translatable) {
        ConfigWidget widget = this.widgetsByTranslatable.get(translatable);
        if (widget == null) {
            return Optional.empty();
        }
        return Optional.of(widget.getConfigEntry());
    }

    @Override
    public void clear() {
        this.widgets.clear();
    }

    private void addWidget(@NotNull ConfigWidget widget) {
        this.widgets.add(widget);
        this.widgetsByTranslatable.put(widget.getTranslatable(), widget);
    }

    private <T extends ConfigEntry<?>> Supplier<T> createEntry(@NotNull String translatable, @NotNull Supplier<T> supplier) {
        return () -> {
            ConfigEntry entry = (ConfigEntry)supplier.get();
            this.config.setEntry(translatable, entry);
            return entry;
        };
    }

    private void checkWidgetExists(@NotNull String translatable) {
        if (this.widgetsByTranslatable.containsKey(translatable)) {
            throw new IllegalArgumentException("Widget " + translatable + " already exist");
        }
    }

    public VoiceAddonConfig(AddonContainer addon, VoiceClientConfig.Addons.Addon config) {
        this.addon = addon;
        this.config = config;
    }

    public AddonContainer getAddon() {
        return this.addon;
    }

    public List<ConfigWidget> getWidgets() {
        return this.widgets;
    }

    public static class ConfigSliderWidget
    extends ConfigWidget {
        @NotNull
        private final String suffix;

        public ConfigSliderWidget(@NotNull ConfigWidget.Type type, @NotNull String translatable, @Nullable String tooltipTranslatable, @NotNull ConfigEntry<?> configEntry, @NotNull String suffix) {
            super(type, translatable, tooltipTranslatable, configEntry);
            this.suffix = suffix;
        }

        @NotNull
        public String getSuffix() {
            return this.suffix;
        }
    }

    public static class ConfigWidget {
        @NotNull
        private final Type type;
        @NotNull
        private final String translatable;
        @Nullable
        private final String tooltipTranslatable;
        @NotNull
        private final ConfigEntry<?> configEntry;

        public ConfigWidget(@NotNull Type type, @NotNull String translatable, @Nullable String tooltipTranslatable, @NotNull ConfigEntry<?> configEntry) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            if (translatable == null) {
                throw new NullPointerException("translatable is marked non-null but is null");
            }
            if (configEntry == null) {
                throw new NullPointerException("configEntry is marked non-null but is null");
            }
            this.type = type;
            this.translatable = translatable;
            this.tooltipTranslatable = tooltipTranslatable;
            this.configEntry = configEntry;
        }

        @NotNull
        public Type getType() {
            return this.type;
        }

        @NotNull
        public String getTranslatable() {
            return this.translatable;
        }

        @Nullable
        public String getTooltipTranslatable() {
            return this.tooltipTranslatable;
        }

        @NotNull
        public ConfigEntry<?> getConfigEntry() {
            return this.configEntry;
        }

        public static enum Type {
            INT_SLIDER,
            VOLUME_SLIDER,
            TOGGLE,
            DROPDOWN;

        }
    }

    public static class ConfigDropDownWidget
    extends ConfigWidget {
        @NotNull
        private final List<String> elements;
        private final boolean elementTooltip;

        public ConfigDropDownWidget(@NotNull String translatable, @Nullable String tooltipTranslatable, @NotNull ConfigEntry<?> configEntry, @NotNull List<String> elements, boolean elementTooltip) {
            super(ConfigWidget.Type.DROPDOWN, translatable, tooltipTranslatable, configEntry);
            this.elements = elements;
            this.elementTooltip = elementTooltip;
        }

        @NotNull
        public List<String> getElements() {
            return this.elements;
        }

        public boolean isElementTooltip() {
            return this.elementTooltip;
        }
    }
}

