/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings.widget;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.api.MathLib;
import su.plo.lib.api.chat.MinecraftLiteralText;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.api.chat.MinecraftTextStyle;
import su.plo.lib.mod.client.gui.components.Button;
import su.plo.lib.mod.client.language.LanguageUtil;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.voice.api.client.config.keybind.KeyBinding;
import su.plo.voice.client.config.keybind.KeyBindingConfigEntry;
import su.plo.voice.client.gui.settings.tab.AbstractHotKeysTabWidget;
import su.plo.voice.client.gui.settings.widget.UpdatableWidget;
import su.plo.voice.universal.UGraphics;
import su.plo.voice.universal.UKeyboard;
import su.plo.voice.universal.UMatrixStack;

public final class HotKeyWidget
extends Button
implements UpdatableWidget {
    private final AbstractHotKeysTabWidget parent;
    private final KeyBindingConfigEntry entry;
    private final List<KeyBinding.Key> pressedKeys = new ArrayList<KeyBinding.Key>();

    public HotKeyWidget(@NotNull AbstractHotKeysTabWidget parent, @NotNull KeyBindingConfigEntry entry, int x, int y, int width, int height) {
        super(x, y, width, height, MinecraftTextComponent.empty(), NO_ACTION, NO_TOOLTIP);
        this.parent = parent;
        this.entry = entry;
        this.updateValue();
    }

    @Override
    public void updateValue() {
        MinecraftLiteralText text = MinecraftTextComponent.literal("");
        if (((KeyBinding)this.entry.value()).getKeys().size() == 0) {
            text.append(MinecraftTextComponent.translatable("gui.none", new Object[0]));
        } else {
            this.formatKeys(text, ((KeyBinding)this.entry.value()).getKeys());
        }
        if (this.isActive()) {
            if (this.pressedKeys.size() > 0) {
                text = MinecraftTextComponent.literal("");
                List<KeyBinding.Key> sorted2 = this.pressedKeys.stream().sorted(Comparator.comparingInt(key -> key.getType().ordinal())).collect(Collectors.toList());
                this.formatKeys(text, sorted2);
            }
            this.setText(MinecraftTextComponent.literal("> ").withStyle(MinecraftTextStyle.YELLOW).append(text.withStyle(MinecraftTextStyle.YELLOW)).append(MinecraftTextComponent.literal(" <").withStyle(MinecraftTextStyle.YELLOW)));
        } else {
            this.setText(text);
        }
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isActive() && (button != 0 || this.pressedKeys.size() != 0) && this.pressedKeys.stream().anyMatch(key -> key.getType() == KeyBinding.Type.MOUSE && key.getCode() == button)) {
            this.keysReleased();
            this.updateValue();
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isActive()) {
            if (this.pressedKeys.size() < 3) {
                this.pressedKeys.add(KeyBinding.Type.MOUSE.getOrCreate(button));
            }
            this.updateValue();
            return true;
        }
        if (this.isClicked(mouseX, mouseY) && this.isValidClickButton(button)) {
            this.parent.setFocusedHotKey(this);
            this.updateValue();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean keyPressed(int keyCode, @Nullable UKeyboard.Modifiers modifiers) {
        if (this.isActive()) {
            if (keyCode == 256) {
                if (this.pressedKeys.size() > 0) {
                    this.keysReleased();
                } else {
                    this.parent.setFocusedHotKey(null);
                    ((KeyBinding)this.entry.value()).getKeys().clear();
                    this.updateValue();
                }
                return true;
            }
            KeyBinding.Key key = KeyBinding.Type.KEYSYM.getOrCreate(keyCode);
            if (this.pressedKeys.size() < 3 && !this.pressedKeys.contains(key)) {
                this.pressedKeys.add(key);
            }
            this.updateValue();
            return true;
        }
        return super.keyPressed(keyCode, modifiers);
    }

    @Override
    public boolean keyReleased(int keyCode, char typedChar, @Nullable UKeyboard.Modifiers modifiers) {
        if (this.isActive() && this.pressedKeys.stream().anyMatch(key -> key.getType() == KeyBinding.Type.KEYSYM && key.getCode() == keyCode)) {
            this.keysReleased();
            this.updateValue();
            return true;
        }
        return super.keyReleased(keyCode, typedChar, modifiers);
    }

    @Override
    protected void renderText(@NotNull UMatrixStack stack, int mouseX, int mouseY) {
        int j;
        int n = j = this.active ? 0xFFFFFF : 0xA0A0A0;
        if (Objects.equals(this.parent.getFocusedHotKey(), this)) {
            RenderUtil.drawCenteredString(stack, this.getText(), this.x + this.width / 2, this.y + this.height / 2 - UGraphics.getFontHeight() / 2, j | MathLib.ceil(this.alpha * 255.0f) << 24);
        } else {
            RenderUtil.drawCenteredOrderedString(stack, this.getText(), this.width - 16, this.x + this.width / 2, this.y + this.height / 2 - UGraphics.getFontHeight() / 2, j | MathLib.ceil(this.alpha * 255.0f) << 24);
        }
    }

    @Override
    public void renderToolTip(@NotNull UMatrixStack stack, int mouseX, int mouseY) {
        int width;
        if (!Objects.equals(this.parent.getFocusedHotKey(), this) && (width = RenderUtil.getTextWidth(this.getText())) > this.width - 16) {
            this.parent.setTooltip(this.getText());
        }
        super.renderToolTip(stack, mouseX, mouseY);
    }

    @Override
    public boolean isActive() {
        return Objects.equals(this.parent.getFocusedHotKey(), this);
    }

    public void keysReleased() {
        ((KeyBinding)this.entry.value()).setKeys((Set<KeyBinding.Key>)ImmutableSet.copyOf(this.pressedKeys));
        this.pressedKeys.clear();
        this.parent.setFocusedHotKey(null);
    }

    private void formatKeys(MinecraftTextComponent text, Collection<KeyBinding.Key> keys2) {
        for (KeyBinding.Key key : keys2) {
            text.append(LanguageUtil.getKeyDisplayName(key));
            text.append(MinecraftTextComponent.literal(" + "));
        }
        text.siblings().remove(text.siblings().size() - 1);
    }
}

