/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import su.plo.config.provider.ConfigurationProvider;
import su.plo.config.provider.toml.TomlConfiguration;
import su.plo.lib.api.server.command.MinecraftCommand;
import su.plo.lib.api.server.command.MinecraftCommandManager;
import su.plo.lib.api.server.event.command.CommandsRegisterEvent;
import su.plo.lib.api.server.event.command.ServerCommandsRegisterEvent;
import su.plo.lib.api.server.permission.PermissionDefault;
import su.plo.lib.api.server.permission.PermissionsManager;
import su.plo.voice.BaseVoice;
import su.plo.voice.api.addon.ServerAddonsLoader;
import su.plo.voice.api.audio.codec.AudioDecoder;
import su.plo.voice.api.audio.codec.AudioEncoder;
import su.plo.voice.api.encryption.Encryption;
import su.plo.voice.api.server.PlasmoBaseVoiceServer;
import su.plo.voice.api.server.PlasmoVoiceServer;
import su.plo.voice.api.server.audio.capture.ServerActivationManager;
import su.plo.voice.api.server.audio.line.ServerSourceLineManager;
import su.plo.voice.api.server.connection.TcpServerConnectionManager;
import su.plo.voice.api.server.connection.UdpServerConnectionManager;
import su.plo.voice.api.server.event.VoiceServerShutdownEvent;
import su.plo.voice.api.server.event.config.VoiceServerConfigReloadedEvent;
import su.plo.voice.api.server.event.socket.UdpServerCreateEvent;
import su.plo.voice.api.server.event.socket.UdpServerStartedEvent;
import su.plo.voice.api.server.event.socket.UdpServerStoppedEvent;
import su.plo.voice.api.server.mute.MuteManager;
import su.plo.voice.api.server.mute.storage.MuteStorage;
import su.plo.voice.api.server.socket.UdpServer;
import su.plo.voice.api.server.socket.UdpServerConnection;
import su.plo.voice.proto.data.audio.codec.opus.OpusDecoderInfo;
import su.plo.voice.proto.data.audio.codec.opus.OpusEncoderInfo;
import su.plo.voice.proto.data.audio.codec.opus.OpusMode;
import su.plo.voice.server.audio.capture.ProximityServerActivation;
import su.plo.voice.server.audio.capture.VoiceServerActivationManager;
import su.plo.voice.server.audio.line.VoiceServerSourceLineManager;
import su.plo.voice.server.command.VoiceListCommand;
import su.plo.voice.server.command.VoiceMuteCommand;
import su.plo.voice.server.command.VoiceMuteListCommand;
import su.plo.voice.server.command.VoiceReconnectCommand;
import su.plo.voice.server.command.VoiceReloadCommand;
import su.plo.voice.server.command.VoiceUnmuteCommand;
import su.plo.voice.server.config.VoiceServerConfig;
import su.plo.voice.server.config.VoiceServerLanguages;
import su.plo.voice.server.connection.VoiceTcpServerConnectionManager;
import su.plo.voice.server.connection.VoiceUdpServerConnectionManager;
import su.plo.voice.server.mute.VoiceMuteManager;
import su.plo.voice.server.mute.storage.MuteStorageFactory;
import su.plo.voice.server.player.LuckPermsListener;
import su.plo.voice.server.player.PermissionSupplier;
import su.plo.voice.server.player.VoiceServerPlayerManager;
import su.plo.voice.server.socket.NettyUdpServer;
import su.plo.voice.util.version.ModrinthLoader;
import su.plo.voice.util.version.ModrinthVersion;

public abstract class BaseVoiceServer
extends BaseVoice
implements PlasmoVoiceServer {
    public static final String CHANNEL_STRING = "plasmo:voice/v2";
    public static final String FLAG_CHANNEL_STRING = "plasmo:voice/v2/installed";
    public static final String SERVICE_CHANNEL_STRING = "plasmo:voice/v2/service";
    public static final UUID USTATS_PROJECT_UUID = UUID.fromString("2b87ab55-5ec8-48ef-b8bb-a5018e53d65e");
    protected static final ConfigurationProvider TOML = (ConfigurationProvider)ConfigurationProvider.getProvider(TomlConfiguration.class);
    protected final TcpServerConnectionManager tcpConnectionManager = new VoiceTcpServerConnectionManager(this);
    protected final UdpServerConnectionManager udpConnectionManager = new VoiceUdpServerConnectionManager(this);
    protected UdpServer udpServer;
    protected PermissionSupplier permissionSupplier;
    protected VoiceServerPlayerManager playerManager;
    protected ServerActivationManager activationManager;
    protected final ProximityServerActivation proximityActivation = new ProximityServerActivation(this);
    protected ServerSourceLineManager sourceLineManager;
    protected MuteStorage muteStorage;
    protected MuteManager muteManager;
    protected LuckPermsListener luckPermsListener;
    protected VoiceServerConfig config;
    protected VoiceServerLanguages languages;
    private Encryption defaultEncryption;

    protected BaseVoiceServer(@NotNull ModrinthLoader loader) {
        super(loader);
        ServerAddonsLoader.INSTANCE.setAddonManager(this.getAddonManager());
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.eventBus.register(this, this.udpConnectionManager);
        this.eventBus.register(this, this.getMinecraftServer());
        this.eventBus.register(this, this.proximityActivation);
        this.permissionSupplier = this.createPermissionSupplier();
        this.playerManager = new VoiceServerPlayerManager(this, this.getMinecraftServer());
        this.playerManager.registerPermission("pv.allow_freecam");
        this.eventBus.register(this, this.playerManager);
        this.activationManager = new VoiceServerActivationManager(this, this.tcpConnectionManager, activationName -> this.config.voice().weights().getActivationWeight((String)activationName));
        this.eventBus.register(this, this.activationManager);
        this.sourceLineManager = new VoiceServerSourceLineManager(this);
        MuteStorageFactory muteStorageFactory = new MuteStorageFactory(this, this.backgroundExecutor);
        this.muteStorage = muteStorageFactory.createStorage("json");
        try {
            this.muteStorage.init();
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize mute storage: {}", (Object)e.toString());
            e.printStackTrace();
            return;
        }
        this.muteManager = new VoiceMuteManager(this, this.muteStorage, this.backgroundExecutor);
        if (LuckPermsListener.Companion.hasLuckPerms()) {
            this.luckPermsListener = new LuckPermsListener(this, this.backgroundExecutor);
            this.luckPermsListener.subscribe();
            LOGGER.info("LuckPerms permissions listener attached");
        }
        this.loadConfig(false);
        this.checkForUpdates();
    }

    @Override
    protected void onShutdown() {
        this.eventBus.call(new VoiceServerShutdownEvent(this));
        if (this.luckPermsListener != null) {
            this.luckPermsListener.unsubscribe();
            this.luckPermsListener = null;
        }
        if (this.muteStorage != null) {
            try {
                this.muteStorage.close();
            }
            catch (Exception e) {
                LOGGER.error("Failed to close mute storage: {}", (Object)e.toString());
                e.printStackTrace();
            }
        }
        this.stopUdpServer();
        this.sourceLineManager.clear();
        this.activationManager.clear();
        this.playerManager.clear();
        this.config = null;
        this.languages = null;
        this.eventBus.unregister(this);
        super.onShutdown();
    }

    public void loadConfig(boolean reload2) {
        boolean restartUdpServer = true;
        try {
            byte[] aesKey;
            UUID forwardingSecret;
            File forwardingSecretFile;
            File configFile = new File(this.getConfigFolder(), "config.toml");
            VoiceServerConfig oldConfig = this.config;
            this.config = (VoiceServerConfig)TOML.load(VoiceServerConfig.class, configFile, false);
            TOML.save(VoiceServerConfig.class, this.config, configFile);
            if (oldConfig != null) {
                restartUdpServer = !this.config.host().equals(oldConfig.host());
            }
            this.languages = new VoiceServerLanguages(this.config.defaultLanguage(), this.config.disableCrowdin());
            this.languages.register("plasmo-voice", "server.toml", this::getResource, new File(this.getConfigFolder(), "languages"));
            File file = forwardingSecretFile = System.getenv().containsKey("PLASMO_VOICE_FORWARDING_SECRET_FILE") ? new File(System.getenv("PLASMO_VOICE_FORWARDING_SECRET_FILE")) : new File(this.getConfigFolder(), "forwarding-secret");
            if (System.getenv("PLASMO_VOICE_FORWARDING_SECRET") != null) {
                forwardingSecret = UUID.fromString(System.getenv("PLASMO_VOICE_FORWARDING_SECRET"));
                this.config.host().forwardingSecret(forwardingSecret);
            } else if (forwardingSecretFile.exists()) {
                forwardingSecret = UUID.fromString(new String(Files.readAllBytes(forwardingSecretFile.toPath())));
                this.config.host().forwardingSecret(forwardingSecret);
            }
            if (System.getenv("PLASMO_VOICE_SERVER_ID") != null) {
                this.config.serverId(System.getenv("PLASMO_VOICE_SERVER_ID"));
            }
            if (oldConfig != null && oldConfig.voice().aesEncryptionKey() != null) {
                aesKey = oldConfig.voice().aesEncryptionKey();
            } else {
                UUID aesEncryptionKey = UUID.randomUUID();
                ByteArrayDataOutput out = ByteStreams.newDataOutput();
                out.writeLong(aesEncryptionKey.getMostSignificantBits());
                out.writeLong(aesEncryptionKey.getLeastSignificantBits());
                aesKey = out.toByteArray();
            }
            this.updateAesEncryptionKey(aesKey);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load config", e);
        }
        DEBUG_LOGGER.enabled(this.config.debug() || System.getProperty("plasmovoice.debug") != null);
        this.proximityActivation.register(this.config);
        if (reload2) {
            this.eventBus.call(new VoiceServerConfigReloadedEvent(this, this.config));
        } else {
            this.addons.initializeLoadedAddons();
        }
        if (restartUdpServer) {
            this.startUdpServer();
        }
    }

    public void updateAesEncryptionKey(byte[] aesKey) {
        this.config.voice().aesEncryptionKey(aesKey);
        this.defaultEncryption = this.encryption.create("AES/CBC/PKCS5Padding", aesKey);
    }

    private void startUdpServer() {
        Collection connectedPlayers = null;
        if (this.udpServer != null) {
            connectedPlayers = this.udpConnectionManager.getConnections().stream().map(UdpServerConnection::getPlayer).collect(Collectors.toList());
            this.stopUdpServer();
        }
        UdpServer server = new NettyUdpServer(this);
        UdpServerCreateEvent createUdpServerEvent = new UdpServerCreateEvent(server);
        this.eventBus.call(createUdpServerEvent);
        server = createUdpServerEvent.getServer();
        try {
            int port = this.config.host().port();
            if (port == 0 && (port = this.getMinecraftServer().getPort()) <= 0) {
                port = 0;
            }
            server.start(this.config.host().ip(), port);
            this.udpServer = server;
            this.eventBus.call(new UdpServerStartedEvent(server));
            if (connectedPlayers != null) {
                connectedPlayers.forEach(this.tcpConnectionManager::requestPlayerInfo);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to start the udp server", (Throwable)e);
        }
    }

    private void stopUdpServer() {
        if (this.udpServer != null) {
            this.udpServer.stop();
            this.eventBus.call(new UdpServerStoppedEvent(this.udpServer));
            this.udpServer = null;
        }
    }

    private void checkForUpdates() {
        if (this.config.checkForUpdates()) {
            this.backgroundExecutor.execute(() -> {
                try {
                    ModrinthVersion.checkForUpdates(this.getVersion(), this.getMinecraftServer().getVersion(), this.loader).ifPresent(version -> LOGGER.warn("New version available {}: {}", (Object)version.version(), (Object)version.downloadLink()));
                }
                catch (IOException e) {
                    LOGGER.error("Failed to check for updates", (Throwable)e);
                }
            });
        }
    }

    protected void registerDefaultCommandsAndPermissions() {
        PermissionsManager permissions = this.getMinecraftServer().getPermissionsManager();
        permissions.clear();
        permissions.register("pv.list", PermissionDefault.TRUE);
        permissions.register("pv.reconnect", PermissionDefault.TRUE);
        permissions.register("pv.allow_freecam", PermissionDefault.TRUE);
        MinecraftCommandManager<MinecraftCommand> commandManager = this.getMinecraftServer().getCommandManager();
        commandManager.clear();
        ((CommandsRegisterEvent.Callback)ServerCommandsRegisterEvent.INSTANCE.getInvoker()).onCommandsRegister(commandManager, this.getMinecraftServer());
        commandManager.register("vlist", new VoiceListCommand(this), new String[0]);
        commandManager.register("vrc", new VoiceReconnectCommand(this), new String[0]);
        commandManager.register("vreload", new VoiceReloadCommand(this), new String[0]);
        commandManager.register("vmute", new VoiceMuteCommand(this, this.getMinecraftServer()), new String[0]);
        commandManager.register("vunmute", new VoiceUnmuteCommand(this, this.getMinecraftServer()), new String[0]);
        commandManager.register("vmutelist", new VoiceMuteListCommand(this, this.getMinecraftServer()), new String[0]);
    }

    @Override
    public Optional<UdpServer> getUdpServer() {
        return Optional.ofNullable(this.udpServer);
    }

    @Override
    public Module createInjectModule() {
        return new AbstractModule(){

            protected void configure() {
                this.bind(PlasmoVoiceServer.class).toInstance((Object)BaseVoiceServer.this);
                this.bind(PlasmoBaseVoiceServer.class).toInstance((Object)BaseVoiceServer.this);
            }
        };
    }

    @Override
    @NotNull
    public AudioEncoder createOpusEncoder(boolean stereo) {
        if (this.config == null) {
            throw new IllegalStateException("server is not initialized yet");
        }
        int sampleRate = this.config.voice().sampleRate();
        return this.codecs.createEncoder(new OpusEncoderInfo(OpusMode.valueOf(this.config.voice().opus().mode()), this.config.voice().opus().bitrate()), sampleRate, stereo, sampleRate / 1000 * 20, this.config.voice().mtuSize());
    }

    @Override
    @NotNull
    public AudioDecoder createOpusDecoder(boolean stereo) {
        if (this.config == null) {
            throw new IllegalStateException("server is not initialized yet");
        }
        int sampleRate = this.config.voice().sampleRate();
        return this.codecs.createDecoder(new OpusDecoderInfo(), sampleRate, stereo, sampleRate / 1000 * 20, this.config.voice().mtuSize());
    }

    protected abstract PermissionSupplier createPermissionSupplier();

    @Override
    public TcpServerConnectionManager getTcpConnectionManager() {
        return this.tcpConnectionManager;
    }

    @Override
    public UdpServerConnectionManager getUdpConnectionManager() {
        return this.udpConnectionManager;
    }

    public PermissionSupplier getPermissionSupplier() {
        return this.permissionSupplier;
    }

    public VoiceServerPlayerManager getPlayerManager() {
        return this.playerManager;
    }

    @Override
    public ServerActivationManager getActivationManager() {
        return this.activationManager;
    }

    @Override
    public ServerSourceLineManager getSourceLineManager() {
        return this.sourceLineManager;
    }

    public MuteStorage getMuteStorage() {
        return this.muteStorage;
    }

    @Override
    public MuteManager getMuteManager() {
        return this.muteManager;
    }

    @Override
    public VoiceServerConfig getConfig() {
        return this.config;
    }

    @Override
    public VoiceServerLanguages getLanguages() {
        return this.languages;
    }

    @Override
    public Encryption getDefaultEncryption() {
        return this.defaultEncryption;
    }
}

