/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.audio.source;

import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.api.addon.AddonContainer;
import su.plo.voice.api.server.PlasmoBaseVoiceServer;
import su.plo.voice.api.server.audio.line.BaseServerSourceLine;
import su.plo.voice.api.server.audio.source.ServerDirectSource;
import su.plo.voice.api.server.connection.UdpConnectionManager;
import su.plo.voice.api.server.event.audio.source.ServerSourceAudioPacketEvent;
import su.plo.voice.api.server.event.audio.source.ServerSourcePacketEvent;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.api.server.socket.UdpConnection;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.data.audio.source.DirectSourceInfo;
import su.plo.voice.proto.data.pos.Pos3d;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.tcp.clientbound.SourceInfoPacket;
import su.plo.voice.proto.packets.udp.clientbound.SourceAudioPacket;
import su.plo.voice.server.audio.source.BaseServerAudioSource;

public final class VoiceServerDirectSource
extends BaseServerAudioSource<DirectSourceInfo>
implements ServerDirectSource {
    private final PlasmoBaseVoiceServer voiceServer;
    private final UdpConnectionManager<? extends VoicePlayer, ? extends UdpConnection> udpConnections;
    private VoicePlayer sender;
    private Pos3d relativePosition;
    private Pos3d lookAngle;
    private boolean cameraRelative = true;
    private Supplier<Collection<VoicePlayer>> playersSupplier;

    public VoiceServerDirectSource(@NotNull PlasmoBaseVoiceServer voiceServer, @NotNull UdpConnectionManager<? extends VoicePlayer, ? extends UdpConnection> udpConnections, @NotNull AddonContainer addon, @NotNull BaseServerSourceLine line, @Nullable CodecInfo decoderInfo, boolean stereo) {
        super(addon, UUID.randomUUID(), line, decoderInfo, stereo);
        this.voiceServer = voiceServer;
        this.udpConnections = udpConnections;
    }

    @Override
    public Optional<VoicePlayer> getSender() {
        return Optional.ofNullable(this.sender);
    }

    @Override
    public void setSender(@NotNull VoicePlayer player) {
        this.sender = player;
        this.updateSourceInfo();
    }

    @Override
    public Optional<Pos3d> getRelativePosition() {
        return Optional.ofNullable(this.relativePosition);
    }

    @Override
    public void setRelativePosition(@NotNull Pos3d position) {
        this.relativePosition = position;
        this.updateSourceInfo();
    }

    @Override
    public Optional<Pos3d> getLookAngle() {
        return Optional.ofNullable(this.lookAngle);
    }

    @Override
    public void setLookAngle(@NotNull Pos3d position) {
        this.lookAngle = position;
        this.updateSourceInfo();
    }

    @Override
    public boolean isCameraRelative() {
        return this.cameraRelative;
    }

    @Override
    public void setCameraRelative(boolean cameraRelative) {
        this.cameraRelative = cameraRelative;
        this.updateSourceInfo();
    }

    @Override
    public void setPlayers(@Nullable Supplier<Collection<VoicePlayer>> playersSupplier) {
        this.playersSupplier = playersSupplier;
    }

    @Override
    @NotNull
    public DirectSourceInfo getSourceInfo() {
        return new DirectSourceInfo(this.addon.getId(), this.id, this.line.getId(), this.name, (byte)this.state.get(), this.decoderInfo, this.stereo, this.iconVisible, this.angle, this.sender == null ? null : this.sender.getInstance().getGameProfile(), this.relativePosition, this.lookAngle, this.cameraRelative);
    }

    @Override
    public boolean sendAudioPacket(@NotNull SourceAudioPacket packet, @Nullable UUID activationId) {
        ServerSourceAudioPacketEvent event = new ServerSourceAudioPacketEvent(this, packet, activationId);
        if (!this.voiceServer.getEventBus().call(event)) {
            return false;
        }
        packet.setSourceState((byte)this.state.get());
        if (this.dirty.compareAndSet(true, false)) {
            this.sendPacket(new SourceInfoPacket(this.getSourceInfo()));
        }
        if (this.playersSupplier != null) {
            for (VoicePlayer voicePlayer : this.playersSupplier.get()) {
                if (super.notMatchFilters(voicePlayer)) continue;
                this.udpConnections.getConnectionByPlayerId(voicePlayer.getInstance().getUUID()).ifPresent(connection -> connection.sendPacket(packet));
            }
        } else {
            for (UdpConnection udpConnection : this.udpConnections.getConnections()) {
                if (super.notMatchFilters(udpConnection.getPlayer())) continue;
                udpConnection.sendPacket(packet);
            }
        }
        return true;
    }

    @Override
    public boolean sendPacket(Packet<?> packet) {
        ServerSourcePacketEvent event = new ServerSourcePacketEvent(this, packet);
        if (!this.voiceServer.getEventBus().call(event)) {
            return false;
        }
        if (this.playersSupplier != null) {
            for (VoicePlayer voicePlayer : this.playersSupplier.get()) {
                if (super.notMatchFilters(voicePlayer)) continue;
                voicePlayer.sendPacket(packet);
            }
        } else {
            for (UdpConnection udpConnection : this.udpConnections.getConnections()) {
                if (super.notMatchFilters(udpConnection.getPlayer())) continue;
                udpConnection.getPlayer().sendPacket(packet);
            }
        }
        return true;
    }

    @Override
    public boolean matchFilters(@NotNull VoicePlayer player) {
        if (this.playersSupplier != null && !this.playersSupplier.get().contains(player)) {
            return false;
        }
        return super.matchFilters(player);
    }

    private void updateSourceInfo() {
        this.sendPacket(new SourceInfoPacket(this.getSourceInfo()));
    }
}

