/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.ustats;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.ResultKt;
import su.plo.voice.libs.kotlin.Unit;
import su.plo.voice.libs.kotlin.coroutines.Continuation;
import su.plo.voice.libs.kotlin.coroutines.intrinsics.IntrinsicsKt;
import su.plo.voice.libs.kotlin.io.CloseableKt;
import su.plo.voice.libs.kotlin.jvm.functions.Function2;
import su.plo.voice.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.text.CharsKt;
import su.plo.voice.libs.kotlin.text.Charsets;
import su.plo.voice.libs.kotlinx.coroutines.BuildersKt;
import su.plo.voice.libs.kotlinx.coroutines.CoroutineScope;
import su.plo.voice.libs.kotlinx.coroutines.CoroutineScopeKt;
import su.plo.voice.libs.kotlinx.coroutines.DelayKt;
import su.plo.voice.libs.kotlinx.coroutines.Dispatchers;
import su.plo.voice.libs.kotlinx.coroutines.Job;
import su.plo.voice.ustats.Config;
import su.plo.voice.ustats.UStatsPlatform;
import su.plo.voice.ustats.libs.toml.Toml;
import su.plo.voice.ustats.libs.toml.TomlWriter;
import su.plo.voice.ustats.model.Report;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 %2\u00020\u0001:\u0001%B!\b\u0016\u0012\u0006\u0010\u001d\u001a\u00020\u001c\u0012\u0006\u0010 \u001a\u00020\u001f\u0012\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\"\u0010#B)\u0012\u0006\u0010\u001d\u001a\u00020\u001c\u0012\u0006\u0010 \u001a\u00020\u001f\u0012\u0006\u0010\u001a\u001a\u00020\u0019\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\"\u0010$J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\b\u0010\u0004J\u000f\u0010\t\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\t\u0010\u0004R\u0014\u0010\n\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u001c\u0010\u0011\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0017\u001a\n \u0010*\u0004\u0018\u00010\u00160\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0014\u0010 \u001a\u00020\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!\u00a8\u0006&"}, d2={"Lsu/plo/voice/ustats/UStats;", "", "", "close", "()V", "Lsu/plo/voice/ustats/Config;", "readConfig", "()Lsu/plo/ustats/Config;", "startJob", "tick", "config", "Lsu/plo/voice/ustats/Config;", "Ljava/io/File;", "configFolder", "Ljava/io/File;", "Lcom/google/gson/Gson;", "su.plo.voice.libs.kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "Lsu/plo/voice/libs/kotlinx/coroutines/Job;", "job", "Lsu/plo/voice/libs/kotlinx/coroutines/Job;", "Lorg/slf4j/Logger;", "logger", "Lorg/slf4j/Logger;", "Lsu/plo/voice/ustats/UStatsPlatform;", "platform", "Lsu/plo/voice/ustats/UStatsPlatform;", "Ljava/util/UUID;", "projectUuid", "Ljava/util/UUID;", "", "version", "Ljava/lang/String;", "<init>", "(Ljava/util/UUID;Ljava/lang/String;Lsu/plo/ustats/UStatsPlatform;)V", "(Ljava/util/UUID;Ljava/lang/String;Lsu/plo/ustats/UStatsPlatform;Ljava/io/File;)V", "Companion", "uStats"})
public final class UStats {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UUID projectUuid;
    @NotNull
    private final String version;
    @NotNull
    private final UStatsPlatform platform;
    @NotNull
    private final File configFolder;
    private final Gson gson;
    private final Logger logger;
    @NotNull
    private final Config config;
    @Nullable
    private Job job;
    @NotNull
    private static final String BASE_URL = "https://ustats.plasmovoice.com/api/v1";

    public UStats(@NotNull UUID projectUuid, @NotNull String version, @NotNull UStatsPlatform platform, @NotNull File configFolder) {
        Intrinsics.checkNotNullParameter(projectUuid, "projectUuid");
        Intrinsics.checkNotNullParameter(version, "version");
        Intrinsics.checkNotNullParameter(platform, "platform");
        Intrinsics.checkNotNullParameter(configFolder, "configFolder");
        this.projectUuid = projectUuid;
        this.version = version;
        this.platform = platform;
        this.configFolder = configFolder;
        this.gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        this.logger = LoggerFactory.getLogger((String)"uStats");
        this.config = this.readConfig();
        if (this.config.getEnabled()) {
            this.startJob();
        }
    }

    public /* synthetic */ UStats(UUID uUID, String string, UStatsPlatform uStatsPlatform, File file, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            file = new File(uStatsPlatform.getConfigsFolder(), "uStats");
        }
        this(uUID, string, uStatsPlatform, file);
    }

    public UStats(@NotNull UUID projectUuid, @NotNull String version, @NotNull UStatsPlatform platform) {
        Intrinsics.checkNotNullParameter(projectUuid, "projectUuid");
        Intrinsics.checkNotNullParameter(version, "version");
        Intrinsics.checkNotNullParameter(platform, "platform");
        this(projectUuid, version, platform, new File(platform.getConfigsFolder(), "uStats"));
    }

    public final void close() {
        Job job = this.job;
        if (job != null) {
            Job.DefaultImpls.cancel$default(job, null, 1, null);
        }
    }

    private final void startJob() {
        long initialDelay = (long)((double)60000 * ((double)3 + Math.random() * (double)3));
        long secondDelay = (long)((double)60000 * (Math.random() * (double)30));
        this.job = BuildersKt.launch$default(CoroutineScopeKt.CoroutineScope(Dispatchers.getDefault()), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(initialDelay, this, secondDelay, null){
            int label;
            final /* synthetic */ long $initialDelay;
            final /* synthetic */ UStats this$0;
            final /* synthetic */ long $secondDelay;
            {
                this.$initialDelay = $initialDelay;
                this.this$0 = $receiver;
                this.$secondDelay = $secondDelay;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        this.label = 1;
                        v0 = DelayKt.delay(this.$initialDelay, this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        UStats.access$tick(this.this$0);
                        this.label = 2;
                        v1 = DelayKt.delay(this.$secondDelay, this);
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl22
                    }
                    case 2: {
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl22:
                        // 3 sources

                        while (true) {
                            UStats.access$tick(this.this$0);
                            this.label = 3;
                            v2 = DelayKt.delay(1800000L, this);
                            if (v2 != var2_2) continue;
                            return var2_2;
                        }
                    }
                    case 3: {
                        ResultKt.throwOnFailure($result);
                        v2 = $result;
                        ** continue;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void tick() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        UUID uUID = this.projectUuid;
        Object object5 = UUID.fromString(this.config.getServerUuid());
        Intrinsics.checkNotNullExpressionValue(object5, "fromString(config.serverUuid)");
        UUID uUID2 = object5;
        int n = this.platform.getPlayers();
        boolean bl = this.platform.getOnlineMode();
        String string = this.platform.getVersion();
        short s = this.platform.getJavaVersion();
        object5 = this.platform.getName();
        if (((CharSequence)object5).length() > 0) {
            String string2;
            void it22;
            char c = ((String)object5).charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            short s2 = s;
            String string3 = string;
            boolean bl2 = bl;
            int n2 = n;
            UUID uUID3 = uUID2;
            UUID uUID4 = uUID;
            int n3 = 0;
            if (Character.isLowerCase((char)it22)) {
                object4 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(object4, "getDefault()");
                string2 = CharsKt.titlecase((char)it22, (Locale)object4);
            } else {
                string2 = String.valueOf((char)it22);
            }
            String string4 = string2;
            uUID = uUID4;
            uUID2 = uUID3;
            n = n2;
            bl = bl2;
            string = string3;
            s = s2;
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string4);
            Object it22 = object5;
            n3 = 1;
            object4 = ((String)it22).substring(n3);
            Intrinsics.checkNotNullExpressionValue(object4, "this as java.lang.String).substring(startIndex)");
            object3 = stringBuilder2.append((String)object4).toString();
        } else {
            object3 = object5;
        }
        String string5 = this.version;
        Object object6 = object3;
        short s3 = s;
        String string6 = string;
        boolean bl3 = bl;
        int n4 = n;
        UUID uUID5 = uUID2;
        UUID uUID6 = uUID;
        Report report = new Report(uUID6, uUID5, n4, bl3, string6, s3, (String)object6, string5);
        String jsonData = this.gson.toJson((Object)report);
        URLConnection uRLConnection = new URL(Intrinsics.stringPlus(BASE_URL, "/report")).openConnection();
        if (uRLConnection == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
        }
        HttpsURLConnection connection = (HttpsURLConnection)uRLConnection;
        connection.setRequestMethod("POST");
        connection.addRequestProperty("Connection", "close");
        connection.addRequestProperty("Content-Length", String.valueOf(jsonData.length()));
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setDoOutput(true);
        Closeable n3 = new DataOutputStream(connection.getOutputStream());
        object4 = null;
        try {
            DataOutputStream outputStream = (DataOutputStream)n3;
            boolean bl4 = false;
            Intrinsics.checkNotNullExpressionValue(jsonData, "jsonData");
            String string7 = jsonData;
            object2 = string7.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(object2, "this as java.lang.String).getBytes(charset)");
            outputStream.write((byte[])object2);
            object = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object4 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally(n3, (Throwable)object4);
        }
        try {
            StringBuilder builder = new StringBuilder();
            object4 = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            object = null;
            try {
                BufferedReader bufferedReader = (BufferedReader)object4;
                boolean bl5 = false;
                Object line = null;
                while (true) {
                    Object it = object2 = (Object)bufferedReader.readLine();
                    boolean bl6 = false;
                    line = it;
                    if (object2 == null) break;
                    builder.append((String)line);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object4, (Throwable)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final Config readConfig() {
        File configFile = new File(this.configFolder, "uStats.toml");
        Config config = new Config();
        if (configFile.exists()) {
            try {
                Config config2 = new Toml().read(configFile).to(Config.class);
                Intrinsics.checkNotNullExpressionValue(config2, "Toml().read(configFile).to(Config::class.java)");
                config = config2;
            }
            catch (Exception e) {
                this.logger.warn("Failed to read uStats config");
                e.printStackTrace();
            }
        }
        this.configFolder.mkdirs();
        new TomlWriter().write((Object)config, configFile);
        return config;
    }

    public static final /* synthetic */ void access$tick(UStats $this) {
        $this.tick();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Lsu/plo/voice/ustats/UStats$Companion;", "", "", "BASE_URL", "Ljava/lang/String;", "<init>", "()V", "uStats"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

