/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_1856;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_3518;

public record ShapedTemplate(int width, int height, class_2371<class_1856> ingredients) {
    public static ShapedTemplate of(class_1869 recipe) {
        return new ShapedTemplate(recipe.method_8150(), recipe.method_8158(), (class_2371<class_1856>)recipe.method_8117());
    }

    public static ShapedTemplate fromJson(JsonObject json) {
        HashMap<Character, class_1856> key = new HashMap<Character, class_1856>();
        for (Map.Entry entry : class_3518.method_15296((JsonObject)json, (String)"key").entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            key.put(Character.valueOf(((String)entry.getKey()).charAt(0)), class_1856.method_52177((JsonElement)((JsonElement)entry.getValue())));
        }
        JsonArray patternList = class_3518.method_15261((JsonObject)json, (String)"pattern");
        if (patternList.size() == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        String[] pattern = new String[patternList.size()];
        for (int x = 0; x < pattern.length; ++x) {
            String line = class_3518.method_15287((JsonElement)patternList.get(x), (String)("pattern[" + x + "]"));
            if (x > 0 && pattern[0].length() != line.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must  be the same width");
            }
            pattern[x] = line;
        }
        int width = pattern[0].length();
        int height = pattern.length;
        class_2371 ingredients = class_2371.method_10213((int)(width * height), (Object)class_1856.field_9017);
        HashSet missingKeys = new HashSet(key.keySet());
        int ingredientIdx = 0;
        for (String line : pattern) {
            for (int x = 0; x < line.length(); ++x) {
                class_1856 ing;
                char chr = line.charAt(x);
                class_1856 class_18562 = ing = chr == ' ' ? class_1856.field_9017 : (class_1856)key.get(Character.valueOf(chr));
                if (ing == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + chr + "' but it's not defined in the key");
                }
                ingredients.set(ingredientIdx++, (Object)ing);
                missingKeys.remove(Character.valueOf(chr));
            }
        }
        if (!missingKeys.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + missingKeys);
        }
        return new ShapedTemplate(width, height, (class_2371<class_1856>)ingredients);
    }

    public static ShapedTemplate fromNetwork(class_2540 buffer) {
        int width = buffer.method_10816();
        int height = buffer.method_10816();
        class_2371 ingredients = class_2371.method_10213((int)(width * height), (Object)class_1856.field_9017);
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredients.set(i, (Object)class_1856.method_8086((class_2540)buffer));
        }
        return new ShapedTemplate(width, height, (class_2371<class_1856>)ingredients);
    }

    public void toNetwork(class_2540 buffer) {
        buffer.method_10804(this.width());
        buffer.method_10804(this.height());
        for (class_1856 ingredient : this.ingredients) {
            ingredient.method_8088(buffer);
        }
    }
}

