/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.wiredredstone.net;

import alexiil.mc.lib.net.NetByteBuf;
import com.kneelawk.wiredredstone.WRConstants;
import com.kneelawk.wiredredstone.WRLog;
import com.kneelawk.wiredredstone.config.CommonConfig;
import com.kneelawk.wiredredstone.config.SyncPhase;
import com.kneelawk.wiredredstone.mixin.api.NetworkHelper;
import com.kneelawk.wiredredstone.part.AbstractCenterConnectablePart;
import com.kneelawk.wiredredstone.part.AbstractConnectablePart;
import com.kneelawk.wiredredstone.screenhandler.RedstoneAssemblerScreenHandler;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1255;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3248;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b0\u0010\u0012JM\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\b\u00a2\u0006\u0004\b\u0011\u0010\u0012J1\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00132\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0015H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001b\u001a\u00020\u001a8\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u001f\u001a\u00020\u001a8\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010\u001c\u001a\u0004\b \u0010\u001eR\u001c\u0010#\u001a\n \"*\u0004\u0018\u00010!0!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u001c\u0010%\u001a\n \"*\u0004\u0018\u00010!0!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010$R\u0014\u0010'\u001a\u00020&8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b'\u0010(R$\u0010+\u001a\u0012\u0012\u0004\u0012\u00020\u00040)j\b\u0012\u0004\u0012\u00020\u0004`*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u001c\u0010.\u001a\n \"*\u0004\u0018\u00010-0-8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/\u00a8\u00061"}, d2={"Lcom/kneelawk/wiredredstone/net/WRNetworking;", "", "", "understood", "Ljava/net/SocketAddress;", "address", "Lkotlin/Function1;", "Lnet/minecraft/class_2561;", "", "disconnect", "Lnet/minecraft/class_2540;", "buf", "Lnet/fabricmc/fabric/api/networking/v1/PacketSender;", "sender", "missingText", "checkVersionAndSync", "(ZLjava/net/SocketAddress;Lkotlin/jvm/functions/Function1;Lnet/minecraft/class_2540;Lnet/fabricmc/fabric/api/networking/v1/PacketSender;Lnet/minecraft/class_2561;)V", "init", "()V", "Lnet/minecraft/class_1255;", "executor", "Lkotlin/Function0;", "startResponseRequirementCountdown", "(Ljava/net/SocketAddress;Lnet/minecraft/class_1255;Lkotlin/jvm/functions/Function0;)V", "startVersionCheck", "(Lnet/fabricmc/fabric/api/networking/v1/PacketSender;)V", "Lnet/minecraft/class_2960;", "CONFIG_SYNC_CHANNEL", "Lnet/minecraft/class_2960;", "getCONFIG_SYNC_CHANNEL", "()Lnet/minecraft/class_2960;", "HELLO_CHANNEL", "getHELLO_CHANNEL", "Lnet/minecraft/class_5250;", "kotlin.jvm.PlatformType", "MISSING_MOD_LOGIN_TEXT", "Lnet/minecraft/class_5250;", "MISSING_MOD_PLAY_TEXT", "", "NETWORKING_VERSION", "I", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "missingResponses", "Ljava/util/HashSet;", "Ljava/util/concurrent/ScheduledExecutorService;", "responseCheckerExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "<init>", "wired-redstone"})
public final class WRNetworking {
    @NotNull
    public static final WRNetworking INSTANCE = new WRNetworking();
    public static final int NETWORKING_VERSION = 2;
    @NotNull
    private static final class_2960 HELLO_CHANNEL = WRConstants.INSTANCE.id("hello");
    @NotNull
    private static final class_2960 CONFIG_SYNC_CHANNEL = WRConstants.INSTANCE.id("config_sync");
    private static final class_5250 MISSING_MOD_LOGIN_TEXT = class_2561.method_43470((String)"Client is missing Wired Redstone mod version >= 0.4.15");
    private static final class_5250 MISSING_MOD_PLAY_TEXT = class_2561.method_43470((String)"Client is missing Wired Redstone mod version >= 0.4.16");
    private static final ScheduledExecutorService responseCheckerExecutor = Executors.newSingleThreadScheduledExecutor();
    @NotNull
    private static final HashSet<SocketAddress> missingResponses = new HashSet();

    private WRNetworking() {
    }

    @NotNull
    public final class_2960 getHELLO_CHANNEL() {
        return HELLO_CHANNEL;
    }

    @NotNull
    public final class_2960 getCONFIG_SYNC_CHANNEL() {
        return CONFIG_SYNC_CHANNEL;
    }

    public final void init() {
        AbstractConnectablePart.Companion.initNetworking();
        AbstractCenterConnectablePart.Companion.initNetworking();
        RedstoneAssemblerScreenHandler.Companion.initNetworking();
        if (CommonConfig.Companion.getLocal().getSyncEnabled()) {
            switch (WhenMappings.$EnumSwitchMapping$0[CommonConfig.Companion.getLocal().getSyncPhase().ordinal()]) {
                case 1: {
                    WRLog.INSTANCE.getLog().info("[Wired Redstone] Synchronization will happen during LOGIN phase.");
                    ServerLoginConnectionEvents.QUERY_START.register(WRNetworking::init$lambda$0);
                    ServerLoginNetworking.registerGlobalReceiver((class_2960)HELLO_CHANNEL, WRNetworking::init$lambda$1);
                    ServerLoginNetworking.registerGlobalReceiver((class_2960)CONFIG_SYNC_CHANNEL, WRNetworking::init$lambda$2);
                    break;
                }
                case 2: {
                    WRLog.INSTANCE.getLog().info("[Wired Redstone] Synchronization will happen during PLAY phase.");
                    ServerPlayConnectionEvents.JOIN.register(WRNetworking::init$lambda$3);
                    ServerPlayNetworking.registerGlobalReceiver((class_2960)HELLO_CHANNEL, WRNetworking::init$lambda$4);
                }
            }
        }
        ServerPlayConnectionEvents.DISCONNECT.register(WRNetworking::init$lambda$5);
        ServerLoginConnectionEvents.DISCONNECT.register(WRNetworking::init$lambda$6);
    }

    private final void startVersionCheck(PacketSender sender) {
        sender.sendPacket(HELLO_CHANNEL, PacketByteBufs.empty());
    }

    private final void startResponseRequirementCountdown(SocketAddress address, class_1255<?> executor, Function0<Unit> disconnect) {
        missingResponses.add(address);
        long delay = CommonConfig.Companion.getLocal().getVersionCheckTimeout();
        responseCheckerExecutor.schedule(() -> WRNetworking.startResponseRequirementCountdown$lambda$8(executor, address, disconnect), delay, TimeUnit.MILLISECONDS);
    }

    private final void checkVersionAndSync(boolean understood, SocketAddress address, Function1<? super class_2561, Unit> disconnect, class_2540 buf, PacketSender sender, class_2561 missingText) {
        if (!understood) {
            disconnect.invoke((Object)missingText);
            return;
        }
        try {
            NetByteBuf buf2 = NetByteBuf.asNetByteBuf((ByteBuf)((ByteBuf)buf));
            int clientNetVersion = buf2.method_10816();
            String clientModVersion = buf2.method_10800(64);
            if (clientNetVersion != 2) {
                class_5250 class_52502 = class_2561.method_43470((String)("Your client version of Wired Redstone (" + clientModVersion + ") is incompatible with this server. Please install Wired Redstone version " + WRConstants.INSTANCE.getMOD_VERSION() + "."));
                Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"literal(\n               \u2026}.\"\n                    )");
                disconnect.invoke((Object)class_52502);
                return;
            }
            NetByteBuf toSend = NetByteBuf.buffer();
            Intrinsics.checkNotNullExpressionValue((Object)toSend, (String)"toSend");
            CommonConfig.Companion.toSyncPacket(toSend);
            sender.sendPacket(CONFIG_SYNC_CHANNEL, (class_2540)toSend);
            missingResponses.remove(address);
        }
        catch (IndexOutOfBoundsException e) {
            disconnect.invoke((Object)missingText);
        }
        catch (DecoderException e) {
            disconnect.invoke((Object)missingText);
        }
    }

    private static final void init$lambda$0(class_3248 class_32482, MinecraftServer minecraftServer, PacketSender sender, ServerLoginNetworking.LoginSynchronizer loginSynchronizer) {
        Intrinsics.checkNotNullExpressionValue((Object)sender, (String)"sender");
        INSTANCE.startVersionCheck(sender);
    }

    private static final void init$lambda$1(MinecraftServer minecraftServer, class_3248 handler, boolean understood, class_2540 buf, ServerLoginNetworking.LoginSynchronizer loginSynchronizer, PacketSender sender) {
        handler.method_14383();
        SocketAddress socketAddress = NetworkHelper.getAddress(handler);
        Intrinsics.checkNotNullExpressionValue((Object)socketAddress, (String)"getAddress(handler)");
        Intrinsics.checkNotNullExpressionValue((Object)handler, (String)"handler");
        Function1 function1 = (Function1)new Function1<class_2561, Unit>((Object)handler){

            public final void invoke(class_2561 p0) {
                ((class_3248)this.receiver).method_14380(p0);
            }
        };
        Intrinsics.checkNotNullExpressionValue((Object)sender, (String)"sender");
        class_5250 class_52502 = MISSING_MOD_LOGIN_TEXT;
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"MISSING_MOD_LOGIN_TEXT");
        INSTANCE.checkVersionAndSync(understood, socketAddress, (Function1<? super class_2561, Unit>)function1, buf, sender, (class_2561)class_52502);
    }

    private static final void init$lambda$2(MinecraftServer minecraftServer, class_3248 handler, boolean understood, class_2540 class_25402, ServerLoginNetworking.LoginSynchronizer loginSynchronizer, PacketSender packetSender) {
        if (!understood) {
            handler.method_14380((class_2561)MISSING_MOD_LOGIN_TEXT);
        }
    }

    private static final void init$lambda$3(class_3244 handler, PacketSender sender, MinecraftServer server) {
        Intrinsics.checkNotNullExpressionValue((Object)sender, (String)"sender");
        INSTANCE.startVersionCheck(sender);
        SocketAddress socketAddress = NetworkHelper.getAddress(handler);
        Intrinsics.checkNotNullExpressionValue((Object)socketAddress, (String)"getAddress(handler)");
        Intrinsics.checkNotNullExpressionValue((Object)server, (String)"server");
        INSTANCE.startResponseRequirementCountdown(socketAddress, (class_1255)server, (Function0<Unit>)((Function0)new Function0<Unit>(handler){
            final /* synthetic */ class_3244 $handler;
            {
                this.$handler = $handler;
                super(0);
            }

            public final void invoke() {
                this.$handler.method_14367((class_2561)WRNetworking.access$getMISSING_MOD_PLAY_TEXT$p());
            }
        }));
    }

    private static final void init$lambda$4(MinecraftServer minecraftServer, class_3222 class_32222, class_3244 handler, class_2540 buf, PacketSender sender) {
        SocketAddress socketAddress = NetworkHelper.getAddress(handler);
        Intrinsics.checkNotNullExpressionValue((Object)socketAddress, (String)"getAddress(handler)");
        Intrinsics.checkNotNullExpressionValue((Object)handler, (String)"handler");
        Function1 function1 = (Function1)new Function1<class_2561, Unit>((Object)handler){

            public final void invoke(class_2561 p0) {
                ((class_3244)this.receiver).method_14367(p0);
            }
        };
        Intrinsics.checkNotNullExpressionValue((Object)sender, (String)"sender");
        class_5250 class_52502 = MISSING_MOD_PLAY_TEXT;
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"MISSING_MOD_PLAY_TEXT");
        INSTANCE.checkVersionAndSync(true, socketAddress, (Function1<? super class_2561, Unit>)function1, buf, sender, (class_2561)class_52502);
    }

    private static final void init$lambda$5(class_3244 handler, MinecraftServer minecraftServer) {
        missingResponses.remove(NetworkHelper.getAddress(handler));
    }

    private static final void init$lambda$6(class_3248 handler, MinecraftServer minecraftServer) {
        missingResponses.remove(NetworkHelper.getAddress(handler));
    }

    private static final void startResponseRequirementCountdown$lambda$8$lambda$7(SocketAddress $address, Function0 $disconnect) {
        Intrinsics.checkNotNullParameter((Object)$address, (String)"$address");
        Intrinsics.checkNotNullParameter((Object)$disconnect, (String)"$disconnect");
        if (missingResponses.contains($address)) {
            $disconnect.invoke();
        }
    }

    private static final void startResponseRequirementCountdown$lambda$8(class_1255 $executor, SocketAddress $address, Function0 $disconnect) {
        Intrinsics.checkNotNullParameter((Object)$executor, (String)"$executor");
        Intrinsics.checkNotNullParameter((Object)$address, (String)"$address");
        Intrinsics.checkNotNullParameter((Object)$disconnect, (String)"$disconnect");
        $executor.execute(() -> WRNetworking.startResponseRequirementCountdown$lambda$8$lambda$7($address, $disconnect));
    }

    public static final /* synthetic */ class_5250 access$getMISSING_MOD_PLAY_TEXT$p() {
        return MISSING_MOD_PLAY_TEXT;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SyncPhase.values().length];
            try {
                nArray[SyncPhase.LOGIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SyncPhase.PLAY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

