/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.impl;

import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.api.Config;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.api.ConfigEnvironment;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.api.WrappedConfig;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.api.metadata.MetadataType;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.api.values.TrackedValue;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.api.values.ValueTreeNode;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.impl.AbstractMetadataContainer;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.impl.builders.ConfigBuilderImpl;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.impl.builders.ReflectiveConfigCreator;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.impl.tree.Trie;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.impl.util.ImmutableIterable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class ConfigImpl
extends AbstractMetadataContainer
implements Config {
    private final ConfigEnvironment environment;
    private final String family;
    private final String id;
    private final Path path;
    private final List<Config.UpdateCallback> callbacks;
    private final Trie values;
    private final String defaultFileType;

    public ConfigImpl(ConfigEnvironment environment, String id2, Path path, Map<MetadataType<?, ?>, Object> metadata, String family, List<Config.UpdateCallback> callbacks, Trie values, String defaultFileType) {
        super(metadata);
        this.environment = environment;
        this.family = family;
        this.id = id2;
        this.path = path;
        this.callbacks = callbacks;
        this.values = values;
        this.defaultFileType = defaultFileType;
    }

    @Override
    public String family() {
        return this.family;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Path savePath() {
        return this.path;
    }

    @Override
    public void registerCallback(Config.UpdateCallback callback) {
        this.callbacks.add(callback);
    }

    public String getDefaultFileType() {
        return this.defaultFileType;
    }

    public ConfigEnvironment getEnvironment() {
        return this.environment;
    }

    private Path getPath() {
        return this.environment.getSaveDir().resolve(this.family).resolve(this.path).resolve(this.id + "." + this.environment.getSerializer(this.defaultFileType).getFileExtension());
    }

    @Override
    public void save() {
        Path path = this.getPath();
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            this.environment.getSerializer(this.defaultFileType).serialize(this, Files.newOutputStream(path, new OpenOption[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void invokeCallbacks() {
        for (Config.UpdateCallback callback : this.callbacks) {
            callback.onUpdate(this);
        }
    }

    @Override
    public Iterable<TrackedValue<?>> values() {
        return new Iterable<TrackedValue<?>>(){

            @Override
            @NotNull
            public Iterator<TrackedValue<?>> iterator() {
                return new Iterator<TrackedValue<?>>(){
                    private final Iterator<ValueTreeNode> itr;
                    private ValueTreeNode next;
                    {
                        this.itr = ConfigImpl.this.values.leaves().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.itr.hasNext() && !(this.next instanceof TrackedValue)) {
                            this.next = this.itr.next();
                        }
                        return this.next != null;
                    }

                    @Override
                    public TrackedValue<?> next() {
                        TrackedValue value = (TrackedValue)this.next;
                        this.next = null;
                        return value;
                    }
                };
            }
        };
    }

    @Override
    public TrackedValue<?> getValue(Iterable<String> key) {
        return this.values.get(key);
    }

    @Override
    public Iterable<ValueTreeNode> nodes() {
        return new ImmutableIterable<ValueTreeNode>(this.values.nodes());
    }

    public static Config create(ConfigEnvironment environment, String familyId, String id2, Config.Creator ... creators) {
        return ConfigImpl.create(environment, familyId, id2, Paths.get("", new String[0]), creators);
    }

    public static Config create(ConfigEnvironment environment, String familyId, String id2, Path path, Config.Creator ... creators) {
        ConfigBuilderImpl builder = new ConfigBuilderImpl(environment, familyId, id2, path);
        for (Config.Creator creator2 : creators) {
            creator2.create(builder);
        }
        return builder.build();
    }

    public static <C extends WrappedConfig> C create(ConfigEnvironment environment, String familyId, String id2, Path path, Config.Creator before, Class<C> configCreatorClass, Config.Creator after) {
        ReflectiveConfigCreator<C> creator2 = ReflectiveConfigCreator.of(configCreatorClass);
        Config config = ConfigImpl.create(environment, familyId, id2, path, before, creator2, after);
        WrappedConfig c = (WrappedConfig)creator2.getInstance();
        c.setWrappedConfig(config);
        return (C)c;
    }
}

