/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.client;

import com.google.gson.JsonParser;
import java.util.Map;
import java.util.stream.Stream;
import net.mehvahdjukaar.amendments.Amendments;
import net.mehvahdjukaar.amendments.AmendmentsClient;
import net.mehvahdjukaar.amendments.client.WallLanternModelsManager;
import net.mehvahdjukaar.amendments.common.CakeRegistry;
import net.mehvahdjukaar.amendments.configs.ClientConfigs;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.mixins.SignRendererAccessor;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.textures.ImageTransformer;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.PaletteColor;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4719;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_827;
import org.apache.logging.log4j.Logger;

public class ClientResourceGenerator
extends DynClientResourcesGenerator {
    public ClientResourceGenerator() {
        super(new DynamicTexturePack(Amendments.res("generated_pack")));
        ((DynamicTexturePack)this.dynamicPack).addNamespaces(new String[]{"minecraft"});
    }

    public Logger getLogger() {
        return Amendments.LOGGER;
    }

    public boolean dependsOnLoadedPacks() {
        return true;
    }

    public void regenerateDynamicAssets(class_3300 manager) {
        WallLanternModelsManager.refreshModels(manager);
        this.generateJukeboxAssets(manager);
        this.generateDoubleCakesAssets(manager);
        this.generateHangingSignAssets(manager);
        if (ClientConfigs.COLORED_ARROWS.get().booleanValue()) {
            ((DynamicTexturePack)this.dynamicPack).addItemModel(new class_2960("crossbow_arrow"), JsonParser.parseString((String)"{\n    \"parent\": \"item/crossbow\",\n    \"textures\": {\n        \"layer0\": \"item/crossbow_arrow_base\",\n        \"layer1\": \"item/crossbow_arrow_tip\"\n    }\n}\n"));
        }
        if (ClientConfigs.JUKEBOX_MODEL.get().booleanValue()) {
            ((DynamicTexturePack)this.dynamicPack).addItemModel(new class_2960("jukebox"), JsonParser.parseString((String)"{\n  \"parent\": \"amendments:block/jukebox\"\n}\n"));
            ((DynamicTexturePack)this.dynamicPack).addBlockState(new class_2960("jukebox"), JsonParser.parseString((String)"{\n  \"variants\": {\n    \"has_record=true\": {\n      \"model\": \"amendments:block/jukebox_on\"\n    },\n    \"has_record=false\": {\n      \"model\": \"amendments:block/jukebox\"\n    }\n  }\n}\n"));
        }
    }

    private void generateHangingSignAssets(class_3300 manager) {
        ImageTransformer transformer = ImageTransformer.builder((int)32, (int)64, (int)16, (int)16).copyRect(26, 0, 2, 4, 4, 0).copyRect(26, 8, 6, 8, 4, 4).copyRect(28, 24, 4, 8, 0, 4).copyRect(26, 20, 2, 4, 6, 0).copyRect(26, 28, 1, 8, 11, 4).copyRect(27, 28, 1, 8, 10, 4).build();
        for (WoodType w : WoodTypeRegistry.getTypes()) {
            class_4730 hangingSignMaterial;
            block22: {
                class_2248 hangingSign = w.getBlockOfThis("hanging_sign");
                if (hangingSign == null) continue;
                class_4719 vanilla = w.toVanilla();
                if (vanilla == null) {
                    Amendments.LOGGER.error("Vanilla wood type for wood {} was null. This is a bug", (Object)w);
                    continue;
                }
                hangingSignMaterial = class_4722.method_45781((class_4719)vanilla);
                if (hangingSignMaterial == null) {
                    try {
                        class_2586 be = ((class_2343)hangingSign).method_10123(class_2338.field_10980, hangingSign.method_9564());
                        class_827 renderer = class_310.method_1551().method_31975().method_3550(be);
                        if (!(renderer instanceof SignRendererAccessor)) break block22;
                        SignRendererAccessor sr = (SignRendererAccessor)renderer;
                        hangingSignMaterial = sr.invokeGetSignMaterial(vanilla);
                    }
                    catch (Exception e) {
                        Amendments.LOGGER.error("Failed to get hanging sign material for wood (from block entity renderer) {}, ", (Object)w, (Object)e);
                        continue;
                    }
                }
            }
            if (hangingSignMaterial == null) {
                Amendments.LOGGER.error("Hanging sign material for wood {} was null. This is likely due to some mod not registering their wood type properly by not adding it to the vanilla texture map", (Object)w);
                continue;
            }
            try {
                TextureImage vanillaTexture = TextureImage.open((class_3300)manager, (class_2960)hangingSignMaterial.method_24147());
                try {
                    TextureImage flipped = vanillaTexture.createRotated(class_2470.field_11463);
                    TextureImage newIm = flipped.createResized(0.5f, 0.25f);
                    newIm.clear();
                    transformer.apply(flipped, newIm);
                    flipped.close();
                    ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(Amendments.res("entity/signs/hanging/" + w.getVariantId("extension")), newIm);
                }
                finally {
                    if (vanillaTexture == null) continue;
                    vanillaTexture.close();
                }
            }
            catch (Exception e) {
                Amendments.LOGGER.warn("Failed to generate hanging sign extension texture for {}, ", (Object)w, (Object)e);
            }
        }
        if (CompatHandler.FARMERS_DELIGHT) {
            try (TextureImage vanillaTexture = TextureImage.open((class_3300)manager, (class_2960)new class_2960("farmersdelight:entity/signs/hanging/canvas"));){
                TextureImage flipped = vanillaTexture.createRotated(class_2470.field_11463);
                TextureImage newIm = flipped.createResized(0.5f, 0.25f);
                newIm.clear();
                transformer.apply(flipped, newIm);
                flipped.close();
                ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(Amendments.res("entity/signs/hanging/farmersdelight/extension_canvas"), newIm);
            }
            catch (Exception e) {
                Amendments.LOGGER.warn("Failed to generate hanging sign extension texture for {}, ", (Object)"canvas sign", (Object)e);
            }
        }
    }

    private void generateJukeboxAssets(class_3300 manager) {
        ImageTransformer transformer = ImageTransformer.builder((int)16, (int)16, (int)16, (int)16).copyRect(5, 6, 3, 2, 6, 6).copyRect(8, 6, 1, 1, 9, 7).copyRect(7, 7, 3, 2, 7, 8).copyRect(6, 8, 1, 1, 6, 8).copyRect(9, 6, 1, 1, 9, 6).copyRect(5, 8, 1, 1, 6, 9).build();
        try (TextureImage fallback = TextureImage.open((class_3300)manager, (class_2960)Amendments.res("block/music_discs/music_disc_generic"));
             TextureImage template = TextureImage.open((class_3300)manager, (class_2960)Amendments.res("block/music_discs/music_disc_template"));
             TextureImage mask = TextureImage.open((class_3300)manager, (class_2960)Amendments.res("block/music_discs/music_disc_mask"));){
            Respriter respriter = Respriter.of((TextureImage)template);
            for (Map.Entry<class_1792, class_4730> e : AmendmentsClient.getAllRecords().entrySet()) {
                class_2960 res = Amendments.res(e.getValue().method_24147().method_12832());
                if (this.alreadyHasTextureAtLocation(manager, res)) continue;
                try {
                    TextureImage vanillaTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstItemTextureLocation((class_3300)manager, (class_1792)e.getKey()));
                    try {
                        Palette p = Palette.fromImage((TextureImage)vanillaTexture, (TextureImage)mask);
                        ClientResourceGenerator.amendPalette(p);
                        TextureImage newImage = respriter.recolor(p);
                        transformer.apply(vanillaTexture, newImage);
                        if (newImage.getImage().method_4315(6, 6) == p.get(p.size() - 2).rgb().toInt()) {
                            newImage.setFramePixel(0, 6, 6, p.getLightest().rgb().toInt());
                            newImage.setFramePixel(0, 9, 9, p.getLightest().rgb().toInt());
                        }
                        ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(res, newImage);
                    }
                    finally {
                        if (vanillaTexture == null) continue;
                        vanillaTexture.close();
                    }
                }
                catch (Exception ex) {
                    this.getLogger().warn("Failed to generate record item texture for {}. No model / texture found", (Object)e.getKey());
                    ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(res, fallback.makeCopy());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void amendPalette(Palette p) {
        float averLum = p.getAverageLuminanceStep();
        if ((double)averLum > 0.06) {
            p.increaseInner();
        }
        PaletteColor darkest = p.getDarkest();
        PaletteColor beforeDarkest = p.get(1);
        if ((double)(beforeDarkest.luminance() - darkest.luminance()) > (double)averLum - 0.005) {
            p.remove(darkest);
            p.increaseDown();
        }
    }

    private void generateDoubleCakesAssets(class_3300 manager) {
        StaticResource[] cakeModels = (StaticResource[])Stream.of("full", "slice1", "slice2", "slice3", "slice4", "slice5", "slice6").map(s -> StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(Amendments.res("double_cake/vanilla_" + s)))).toArray(StaticResource[]::new);
        StaticResource doubleCakeModelState = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCKSTATES.getPath(Amendments.res("double_cake")));
        for (CakeRegistry.CakeType t : CakeRegistry.INSTANCE.getValues()) {
            if (t.isVanilla()) continue;
            try {
                class_2960 dcId = Utils.getID((class_2248)t.getBlockOfThis("double_cake"));
                class_2960 top = RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)t.cake, s -> s.contains("top"));
                class_2960 side = RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)t.cake, s -> s.contains("side"));
                class_2960 bottom = RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)t.cake, s -> s.contains("bottom"));
                class_2960 inner = RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)t.cake, s -> s.contains("inner"));
                for (StaticResource m : cakeModels) {
                    this.addSimilarJsonResource(manager, m, s -> s.replace("amendments:block/double_cake", "").replace("minecraft:block/cake", "").replace("\"/", "\"amendments:block/double_cake/").replace("_top", top.toString()).replace("_side", side.toString()).replace("_inner", inner.toString()).replace("_bottom", bottom.toString()), s -> s.replace("vanilla", dcId.method_12832()));
                }
                this.addSimilarJsonResource(manager, doubleCakeModelState, s -> s.replace("vanilla", dcId.method_12832()), s -> s.replace("double_cake", dcId.method_12832()));
            }
            catch (Exception e) {
                Amendments.LOGGER.error("Failed to generate model for double cake {},", (Object)t, (Object)e);
            }
        }
    }

    public void addDynamicTranslations(AfterLanguageLoadEvent languageEvent) {
        if (languageEvent.isDefault()) {
            languageEvent.addEntry("item.minecraft.lingering_potion.effect.empty", "Lingering Mixed Potion");
            languageEvent.addEntry("item.minecraft.splash_potion.effect.empty", "Splash Mixed Potion");
            languageEvent.addEntry("item.minecraft.potion.effect.empty", "Mixed Potion");
        }
    }
}

