/*
 * Decompiled with CFR 0.152.
 */
package net.zestyblaze.lootr.blocks.entities;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import net.zestyblaze.lootr.api.LootrAPI;
import net.zestyblaze.lootr.api.blockentity.ILootBlockEntity;
import net.zestyblaze.lootr.chunk.HandleChunk;
import net.zestyblaze.lootr.config.LootrModConfig;
import net.zestyblaze.lootr.util.ServerAccessImpl;

public class TileTicker {
    private static final Object listLock = new Object();
    private static final Object worldLock = new Object();
    private static boolean tickingList = false;
    private static final Set<Entry> tileEntries = new ObjectLinkedOpenHashSet();
    private static final Set<Entry> pendingEntries = new ObjectLinkedOpenHashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEntry(class_5321<class_1937> dimension, class_2338 position) {
        if (LootrModConfig.isDimensionBlacklisted(dimension) || LootrModConfig.get().conversion.disable) {
            return;
        }
        Entry newEntry = new Entry(dimension, position);
        Object object = listLock;
        synchronized (object) {
            if (tickingList) {
                pendingEntries.add(newEntry);
            } else {
                tileEntries.add(newEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serverTick() {
        ObjectLinkedOpenHashSet copy;
        if (LootrModConfig.get().conversion.disable) {
            return;
        }
        HashSet<Entry> toRemove = new HashSet<Entry>();
        Object object = listLock;
        synchronized (object) {
            tickingList = true;
            copy = new ObjectLinkedOpenHashSet(tileEntries);
            tickingList = false;
        }
        object = worldLock;
        synchronized (object) {
            MinecraftServer server = ServerAccessImpl.getServer();
            for (Entry entry : copy) {
                class_2621 be;
                class_2586 blockEntity;
                class_3218 level;
                block26: {
                    block25: {
                        if (entry.age(server) > (long)LootrModConfig.get().conversion.max_entry_age) {
                            toRemove.add(entry);
                            continue;
                        }
                        level = server.method_3847(entry.getDimension());
                        if (level == null) {
                            toRemove.add(entry);
                            continue;
                        }
                        boolean skip = false;
                        Map<class_5321<class_1937>, Set<class_1923>> map = HandleChunk.LOADED_CHUNKS;
                        synchronized (map) {
                            Set<class_1923> loadedChunks = HandleChunk.LOADED_CHUNKS.get(entry.dimension);
                            if (loadedChunks != null) {
                                for (class_1923 chunkPos : entry.getChunkPositions()) {
                                    if (loadedChunks.contains(chunkPos)) continue;
                                    skip = true;
                                    break;
                                }
                            }
                        }
                        if (skip) continue;
                        blockEntity = level.method_8321(entry.getPosition());
                        if (!(blockEntity instanceof class_2621)) break block25;
                        be = (class_2621)blockEntity;
                        if (!(blockEntity instanceof ILootBlockEntity)) break block26;
                    }
                    toRemove.add(entry);
                    continue;
                }
                if (be.field_12037 == null || LootrModConfig.isBlacklisted(be.field_12037)) {
                    toRemove.add(entry);
                    continue;
                }
                class_2680 stateAt = level.method_8320(entry.getPosition());
                class_2680 replacement = LootrModConfig.replacement(stateAt);
                if (replacement == null) {
                    toRemove.add(entry);
                    continue;
                }
                class_2960 table = be.field_12037;
                long seed = be.field_12036;
                be.field_12037 = null;
                level.method_22352(entry.getPosition(), false);
                level.method_8652(entry.getPosition(), replacement, 2);
                blockEntity = level.method_8321(entry.getPosition());
                if (blockEntity instanceof ILootBlockEntity) {
                    ((class_2621)blockEntity).method_11285(table, seed);
                } else {
                    LootrAPI.LOG.error("replacement " + replacement + " is not an ILootTile " + entry.getDimension() + " at " + entry.getPosition());
                }
                toRemove.add(entry);
            }
        }
        object = listLock;
        synchronized (object) {
            tickingList = true;
            tileEntries.removeAll(toRemove);
            tileEntries.addAll(pendingEntries);
            tickingList = false;
            pendingEntries.clear();
        }
    }

    public static class Entry {
        private final class_5321<class_1937> dimension;
        private final class_2338 position;
        private final Set<class_1923> chunks = new HashSet<class_1923>();
        private final long addedAt;

        public Entry(class_5321<class_1937> dimension, class_2338 position) {
            this.dimension = dimension;
            this.position = position;
            class_1923 chunkPos = new class_1923(this.position);
            int oX = chunkPos.field_9181;
            int oZ = chunkPos.field_9180;
            this.chunks.add(chunkPos);
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    this.chunks.add(new class_1923(oX + x, oZ + z));
                }
            }
            this.addedAt = ServerAccessImpl.getServer().method_3780();
        }

        public class_5321<class_1937> getDimension() {
            return this.dimension;
        }

        public class_2338 getPosition() {
            return this.position;
        }

        public Set<class_1923> getChunkPositions() {
            return this.chunks;
        }

        public long age(MinecraftServer server) {
            return (long)server.method_3780() - this.addedAt;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (!this.dimension.equals(entry.dimension)) {
                return false;
            }
            return this.position.equals((Object)entry.position);
        }

        public int hashCode() {
            int result = this.dimension.hashCode();
            result = 31 * result + this.position.hashCode();
            return result;
        }

        public String toString() {
            return "Entry{dimension=" + this.dimension + ", position=" + this.position + "}";
        }
    }
}

