/*
 * Decompiled with CFR 0.152.
 */
package com.chefmoon.ubesdelight.block.entity;

import com.chefmoon.ubesdelight.UbesDelightMod;
import com.chefmoon.ubesdelight.advancement.BakingMatTrigger;
import com.chefmoon.ubesdelight.block.BakingMatBlock;
import com.chefmoon.ubesdelight.block.entity.ImplementedInventory;
import com.chefmoon.ubesdelight.mixin.accessors.RecipeManagerAccessorMixin;
import com.chefmoon.ubesdelight.recipe.BakingMatRecipe;
import com.chefmoon.ubesdelight.registry.AdvancementsRegistry;
import com.chefmoon.ubesdelight.registry.BlockEntityTypesRegistry;
import com.chefmoon.ubesdelight.registry.RecipeTypesRegistry;
import com.chefmoon.ubesdelight.registry.SoundsRegistry;
import com.chefmoon.ubesdelight.tag.CommonTags;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class BakingMatBlockEntity
extends class_2586
implements ImplementedInventory {
    public static final int MAX_INGREDIENTS = 9;
    public static final int MAX_PROCESSING_STAGES = 5;
    public static final int MAX_RESULTS = 4;
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
    private class_2960 lastRecipeID;

    public BakingMatBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntityTypesRegistry.BAKING_MAT_BAMBOO.get(), pos, state);
    }

    public void setInventory(class_2371<class_1799> list) {
        for (int i = 0; i < this.inventory.size(); ++i) {
            this.inventory.set(i, (Object)((class_1799)this.inventory.get(i)));
        }
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    @Override
    public void method_5431() {
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        super.method_5431();
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Override
    public void method_5448() {
        this.inventory.clear();
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.inventory);
    }

    public int method_5444() {
        return 1;
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 side) {
        return false;
    }

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 side) {
        return false;
    }

    public int getItemsQuantity() {
        int items = 0;
        for (int i = 0; i <= 8; ++i) {
            class_1799 itemstack = (class_1799)this.inventory.get(i);
            if (itemstack.method_7960()) continue;
            ++items;
        }
        return items;
    }

    @Override
    public boolean method_5442() {
        return ((class_1799)this.inventory.get(0)).method_7960();
    }

    public boolean isFull() {
        for (int i = 8; i >= 0; --i) {
            class_1799 itemstack = (class_1799)this.inventory.get(i);
            if (!itemstack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public boolean addItem(class_1799 itemStack) {
        for (int i = 0; i < this.inventory.size(); ++i) {
            class_1799 itemstack = (class_1799)this.inventory.get(i);
            if (!itemstack.method_7960()) continue;
            this.inventory.set(i, (Object)itemStack.method_7971(1));
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public class_1799 removeItem() {
        for (int i = 8; i >= 0; --i) {
            class_1799 itemstack = (class_1799)this.inventory.get(i);
            if (itemstack.method_7960()) continue;
            this.inventory.set(i, (Object)class_1799.field_8037);
            this.inventoryChanged();
            return itemstack;
        }
        return class_1799.field_8037;
    }

    public class_241 getItemOffset(int index) {
        float xOffset = 0.25f;
        float yOffset = 0.25f;
        class_241[] offsets = new class_241[]{new class_241(0.0f, 0.0f), new class_241(0.25f, 0.0f), new class_241(-0.25f, 0.0f), new class_241(0.0f, 0.25f), new class_241(0.0f, -0.25f), new class_241(0.25f, 0.25f), new class_241(-0.25f, 0.25f), new class_241(0.25f, -0.25f), new class_241(-0.25f, -0.25f)};
        return offsets[index];
    }

    public void inventoryChanged() {
        this.method_5431();
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    public boolean processItemUsingTool(class_1799 tool, class_1657 player) {
        if (this.field_11863 == null) {
            return false;
        }
        Optional<BakingMatRecipe> matchingRecipe = this.getMatchingRecipe(ImplementedInventory.of(this.inventory), tool, player);
        matchingRecipe.ifPresent(recipe -> {
            List<class_1799> results = recipe.getRolledResults(this.field_11863.method_8409(), class_1890.method_8225((class_1887)class_1893.field_9130, (class_1799)tool));
            class_2371<class_1856> ingredients = recipe.method_8117();
            class_2371<class_1856> processStages = recipe.getProcessStages();
            class_2371 ingredientContainers = class_2371.method_10211();
            if (!recipe.getProcessStages().isEmpty()) {
                if (!((Boolean)this.method_11010().method_11654((class_2769)BakingMatBlock.PROCESSING)).booleanValue()) {
                    for (class_1799 itemStack : this.inventory) {
                        if (itemStack.method_7960() || itemStack.getRecipeRemainder().method_31574(class_1802.field_8162)) continue;
                        ingredientContainers.add(itemStack.getRecipeRemainder());
                    }
                    if (!ingredientContainers.isEmpty()) {
                        this.spawnResults((BakingMatRecipe)recipe, tool, (List<class_1799>)ingredientContainers);
                    }
                    this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)BakingMatBlock.PROCESSING, (Comparable)Boolean.valueOf(true)));
                    this.method_5448();
                    class_1799 itemStack = Arrays.stream(((class_1856)processStages.get(0)).method_8105()).findFirst().orElse(class_1799.field_8037);
                    this.spawnParticles(itemStack, 5);
                    this.inventory.set(0, (Object)itemStack);
                    this.inventoryChanged();
                } else if (((Boolean)this.method_11010().method_11654((class_2769)BakingMatBlock.PROCESSING)).booleanValue()) {
                    int currentStage = this.getProcessStage((class_1799)this.inventory.get(0), (List<class_1856>)processStages);
                    if (currentStage < recipe.getProcessStages().size() - 1) {
                        class_1799 currentStageItem = (class_1799)this.inventory.get(0);
                        int nextStage = this.getNextProcessStage(currentStageItem, (List<class_1856>)processStages);
                        if (!((class_1856)processStages.get(nextStage)).method_8103()) {
                            this.method_5448();
                            class_1799 nextStageItem = Arrays.stream(((class_1856)processStages.get(nextStage)).method_8105()).findFirst().orElse(class_1799.field_8037);
                            this.spawnParticles(nextStageItem, 5);
                            this.inventory.set(0, (Object)nextStageItem);
                            this.inventoryChanged();
                        }
                    } else if (currentStage == recipe.getProcessStages().size() - 1) {
                        this.spawnParticles(results.get(0).method_7972(), 5);
                        this.spawnResults((BakingMatRecipe)recipe, tool, results);
                        this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)BakingMatBlock.PROCESSING, (Comparable)Boolean.valueOf(false)));
                    }
                }
            } else {
                for (class_1799 itemStack : this.inventory) {
                    if (itemStack.method_7960() || itemStack.getRecipeRemainder().method_31574(class_1802.field_8162)) continue;
                    results.add(itemStack.getRecipeRemainder());
                }
                this.spawnParticles(results.get(0).method_7972(), 5);
                this.spawnResults((BakingMatRecipe)recipe, tool, results);
            }
            this.triggerAdvancement(player);
            this.damageTool(tool, player);
            this.playProcessingSound(recipe.getSoundEvent(), tool.method_7909(), results);
        });
        return matchingRecipe.isPresent();
    }

    private void spawnResults(BakingMatRecipe recipe, class_1799 tool, List<class_1799> results) {
        for (class_1799 result : results) {
            class_2350 direction = ((class_2350)this.method_11010().method_11654((class_2769)BakingMatBlock.FACING)).method_10160();
            class_1542 entity = new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5 + (double)direction.method_10148() * 0.2, (double)this.field_11867.method_10264() + 0.2, (double)this.field_11867.method_10260() + 0.5 + (double)direction.method_10165() * 0.2, result.method_7972());
            entity.method_18800((double)((float)direction.method_10148() * 0.2f), 0.0, (double)((float)direction.method_10165() * 0.2f));
            this.field_11863.method_8649((class_1297)entity);
            this.method_5448();
        }
    }

    private void playProcessingSound(String soundEventID, class_1792 tool, List<class_1799> results) {
        class_3414 sound = (class_3414)class_7923.field_41172.method_10223(new class_2960(soundEventID));
        if (sound != null) {
            this.playSound(sound, 1.0f, 1.0f);
        } else if (tool.method_7854().method_31573(CommonTags.C_TOOLS_ROLLING_PINS)) {
            this.playSound(SoundsRegistry.BLOCK_BAKING_MAT_ROLLING_PIN.get(), 1.0f, 0.8f);
        }
    }

    private void playSound(class_3414 sound, float volume, float pitch) {
        Objects.requireNonNull(this.field_11863).method_43128(null, (double)((float)this.field_11867.method_10263() + 0.5f), (double)((float)this.field_11867.method_10264() + 0.5f), (double)((float)this.field_11867.method_10260() + 0.5f), sound, class_3419.field_15245, volume, pitch);
    }

    private void damageTool(class_1799 tool, class_1657 player) {
        if (player != null) {
            tool.method_7956(1, (class_1309)player, user -> user.method_20236(class_1268.field_5808));
        } else if (tool.method_7970(1, this.field_11863.method_8409(), null)) {
            tool.method_7939(0);
        }
    }

    public void spawnParticles(class_1799 stack, int count) {
        for (int i = 0; i < count; ++i) {
            class_243 vec3d = new class_243(((double)this.field_11863.method_8409().method_43057() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)this.field_11863.method_8409().method_43057() - 0.5) * 0.1);
            class_1937 class_19372 = this.field_11863;
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                serverWorld.method_14199((class_2394)new class_2392(class_2398.field_11218, stack), (double)((float)this.field_11867.method_10263() + 0.5f), (double)((float)this.field_11867.method_10264() + 0.1f), (double)((float)this.field_11867.method_10260() + 0.5f), 1, vec3d.field_1352, vec3d.field_1351 + 0.05, vec3d.field_1350, 0.0);
                continue;
            }
            this.field_11863.method_8406((class_2394)new class_2392(class_2398.field_11218, stack), (double)((float)this.field_11867.method_10263() + 0.5f), (double)((float)this.field_11867.method_10264() + 0.1f), (double)((float)this.field_11867.method_10260() + 0.5f), vec3d.field_1352, vec3d.field_1351 + 0.05, vec3d.field_1350);
        }
    }

    private Integer getProcessStage(class_1799 itemStack, List<class_1856> processStages) {
        Integer stage = 0;
        for (int i = 0; i < processStages.size(); ++i) {
            if (processStages.get(i).method_8103()) continue;
            if (itemStack.method_31574(Arrays.stream(processStages.get(i).method_8105()).findFirst().get().method_7909())) {
                return stage;
            }
            Integer n = stage;
            stage = stage + 1;
        }
        return stage;
    }

    private Integer getNextProcessStage(class_1799 itemStack, List<class_1856> processStages) {
        Integer stage = 0;
        for (int i = 0; i < processStages.size(); ++i) {
            if (processStages.get(i).method_8103()) continue;
            if (itemStack.method_31574(Arrays.stream(processStages.get(i).method_8105()).findFirst().get().method_7909())) {
                if (i == processStages.size() - 1) {
                    return stage;
                }
                return stage + 1;
            }
            Integer n = stage;
            stage = stage + 1;
        }
        return stage;
    }

    private void triggerAdvancement(class_1657 playerEntity) {
        if (playerEntity instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)playerEntity;
            ((BakingMatTrigger)AdvancementsRegistry.BAKING_MAT.get()).trigger(serverPlayerEntity);
        }
    }

    public void setInventoryIngredientsFromProcessingStage() {
        Optional<BakingMatRecipe> matchingRecipe = this.getMatchingIngredients(ImplementedInventory.of(this.inventory));
        matchingRecipe.ifPresent(recipe -> {
            class_2371<class_1856> ingredients = recipe.method_8117();
            for (int i = 0; i < ingredients.size(); ++i) {
                if (((class_1856)ingredients.get(i)).method_8103()) continue;
                this.inventory.set(i, (Object)Arrays.stream(((class_1856)ingredients.get(i)).method_8105()).findFirst().orElse(class_1799.field_8037));
            }
        });
        this.inventoryChanged();
    }

    private Optional<BakingMatRecipe> getMatchingIngredients(ImplementedInventory implementedInventory) {
        if (this.field_11863 == null) {
            return Optional.empty();
        }
        List recipeList = this.field_11863.method_8433().method_17877(RecipeTypesRegistry.BAKING_MAT_RECIPE_SERIALIZER.type(), (class_1263)implementedInventory, this.field_11863);
        if (recipeList.isEmpty()) {
            return Optional.empty();
        }
        Optional<BakingMatRecipe> recipe = recipeList.stream().findFirst();
        if (recipe.isEmpty()) {
            return Optional.empty();
        }
        return recipe;
    }

    private Optional<BakingMatRecipe> getMatchingRecipe(ImplementedInventory implementedInventory, class_1799 toolStack, @Nullable class_1657 player) {
        class_1860 recipe;
        if (this.field_11863 == null) {
            return Optional.empty();
        }
        if (this.lastRecipeID != null && (recipe = (class_1860)((RecipeManagerAccessorMixin)this.field_11863.method_8433()).getAllForType(RecipeTypesRegistry.BAKING_MAT_RECIPE_SERIALIZER.type()).get(this.lastRecipeID)) instanceof BakingMatRecipe && recipe.method_8115((class_1263)implementedInventory, this.field_11863) && ((BakingMatRecipe)recipe).getTool().method_8093(toolStack)) {
            return Optional.of((BakingMatRecipe)recipe);
        }
        List recipeList = this.field_11863.method_8433().method_17877(RecipeTypesRegistry.BAKING_MAT_RECIPE_SERIALIZER.type(), (class_1263)implementedInventory, this.field_11863);
        if (recipeList.isEmpty()) {
            if (player != null) {
                player.method_7353((class_2561)UbesDelightMod.tooltip("tooltip.baking_mat.invalid_item", new Object[0]), true);
            }
            return Optional.empty();
        }
        Optional<BakingMatRecipe> recipe2 = recipeList.stream().filter(bakingMatRecipe -> bakingMatRecipe.getTool().method_8093(toolStack)).findFirst();
        if (recipe2.isEmpty()) {
            if (player != null) {
                player.method_7353((class_2561)UbesDelightMod.tooltip("tooltip.baking_mat.invalid_tool", new Object[0]), true);
            }
            return Optional.empty();
        }
        this.lastRecipeID = recipe2.get().method_8114();
        return recipe2;
    }
}

