/*
 * Decompiled with CFR 0.152.
 */
package com.chefmoon.ubesdelight.data.builder;

import com.chefmoon.ubesdelight.recipe.ingredient.ChanceResult;
import com.chefmoon.ubesdelight.registry.RecipeTypesRegistry;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_193;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7710;
import net.minecraft.class_7798;
import org.jetbrains.annotations.Nullable;

public class BakingMatRecipeJsonBuilder
extends class_7798
implements class_5797 {
    private final List<class_1856> ingredientList;
    private final List<class_1856> processStages;
    private final List<ChanceResult> resultList = new ArrayList<ChanceResult>(4);
    private final class_1856 tool;
    private String soundEventID;
    private final class_161.class_162 advancementBuilder = class_161.class_162.method_51698();

    private BakingMatRecipeJsonBuilder(List<class_1856> ingredientList, @Nullable List<class_1856> processStages, class_1856 tool, class_1799 mainResult, int count, float chance) {
        this.ingredientList = ingredientList;
        this.processStages = processStages;
        this.resultList.add(new ChanceResult(new class_1799((class_1935)mainResult.method_7909(), count), chance));
        this.tool = tool;
    }

    public static BakingMatRecipeJsonBuilder create(List<class_1856> ingredientList, @Nullable List<class_1856> processStages, class_1856 tool, class_1792 mainResult) {
        return new BakingMatRecipeJsonBuilder(ingredientList, processStages, tool, new class_1799((class_1935)mainResult), 1, 1.0f);
    }

    public static BakingMatRecipeJsonBuilder create(List<class_1856> ingredientList, @Nullable List<class_1856> processStages, class_1856 tool, class_1792 mainResult, int count) {
        return new BakingMatRecipeJsonBuilder(ingredientList, processStages, tool, new class_1799((class_1935)mainResult), count, 1.0f);
    }

    public BakingMatRecipeJsonBuilder addOutput(class_1792 item) {
        return this.addOutput(item, 1, Float.valueOf(1.0f));
    }

    public BakingMatRecipeJsonBuilder addOutput(class_1792 item, Integer count, Float chance) {
        this.resultList.add(new ChanceResult(new class_1799((class_1935)item, count.intValue()), chance.floatValue()));
        return this;
    }

    public BakingMatRecipeJsonBuilder input(class_6862<class_1792> tag) {
        return this.input(class_1856.method_8106(tag));
    }

    public BakingMatRecipeJsonBuilder input(class_6862<class_1792> tag, int size) {
        return this.input(class_1856.method_8106(tag), size);
    }

    public BakingMatRecipeJsonBuilder input(class_1935 itemProvider) {
        return this.input(class_1856.method_8091((class_1935[])new class_1935[]{itemProvider}), 1);
    }

    public BakingMatRecipeJsonBuilder input(class_1935 itemProvider, int size) {
        return this.input(class_1856.method_8091((class_1935[])new class_1935[]{itemProvider}), size);
    }

    public BakingMatRecipeJsonBuilder input(class_1856 ingredient) {
        return this.input(ingredient, 1);
    }

    public BakingMatRecipeJsonBuilder input(class_1856 ingredient, int size) {
        for (int i = 0; i < size; ++i) {
            this.ingredientList.add(ingredient);
        }
        return this;
    }

    public BakingMatRecipeJsonBuilder addSound(String soundEventID) {
        this.soundEventID = soundEventID;
        return this;
    }

    public class_5797 method_33530(String name, class_184 conditions) {
        this.advancementBuilder.method_709(name, conditions);
        return this;
    }

    public class_5797 method_33529(@Nullable String group) {
        return null;
    }

    public class_1792 method_36441() {
        if (!this.resultList.isEmpty()) {
            return this.resultList.get(0).stack().method_7909();
        }
        return null;
    }

    public void method_17972(Consumer<class_2444> exporter, class_2960 recipeId) {
        if (Objects.equals(recipeId.method_12836(), "minecraft")) {
            recipeId = new class_2960("ubesdelight", recipeId.method_12832());
        }
        this.validate(recipeId);
        String prefix = "ubesdelight/baking_mat/";
        this.advancementBuilder.method_708(field_39377).method_709("has_the_recipe", (class_184)class_2119.method_27847((class_2960)recipeId.method_45138(prefix))).method_703(class_170.class_171.method_753((class_2960)recipeId.method_45138(prefix))).method_704(class_193.field_1257);
        exporter.accept((class_2444)new BakingMatRecipeJsonProvider(recipeId.method_45138(prefix), this.ingredientList, this.processStages, this.resultList, this.tool, this.soundEventID, this.advancementBuilder, recipeId.method_45138("recipes/food/" + prefix)));
    }

    private void validate(class_2960 recipeId) {
        if (this.advancementBuilder.method_710().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + recipeId);
        }
    }

    public static class BakingMatRecipeJsonProvider
    extends class_7798.class_7799 {
        private final class_2960 recipeId;
        private final List<class_1856> ingredientList;
        private final List<class_1856> processStages;
        private final List<ChanceResult> resultList;
        private final class_1856 tool;
        private final String soundEventID;
        private final class_161.class_162 advancementBuilder;
        private final class_2960 advancementId;

        protected BakingMatRecipeJsonProvider(class_2960 recipeId, List<class_1856> ingredientList, @Nullable List<class_1856> processStages, List<ChanceResult> resultList, class_1856 tool, String soundEventID, class_161.class_162 advancementBuilder, class_2960 advancementId) {
            super(class_7710.field_40251);
            this.recipeId = recipeId;
            this.ingredientList = ingredientList;
            this.processStages = processStages;
            this.resultList = resultList;
            this.tool = tool;
            this.soundEventID = soundEventID;
            this.advancementBuilder = advancementBuilder;
            this.advancementId = advancementId;
        }

        public void method_10416(JsonObject json) {
            JsonArray ingredientArray = new JsonArray();
            for (class_1856 ingredient : this.ingredientList) {
                ingredientArray.add(ingredient.method_8089());
            }
            json.add("ingredients", (JsonElement)ingredientArray);
            JsonArray processArray = new JsonArray();
            if (this.processStages != null) {
                for (class_1856 ingredient : this.processStages) {
                    processArray.add(ingredient.method_8089());
                }
            }
            json.add("processing_stages", (JsonElement)processArray);
            JsonArray resultArray = new JsonArray();
            for (ChanceResult result : this.resultList) {
                resultArray.add(result.serialize());
            }
            json.add("result", (JsonElement)resultArray);
            json.add("tool", this.tool.method_8089());
        }

        public class_2960 method_10417() {
            return this.recipeId;
        }

        public class_1865<?> method_17800() {
            return RecipeTypesRegistry.BAKING_MAT_RECIPE_SERIALIZER.serializer();
        }

        @Nullable
        public JsonObject method_10415() {
            return this.advancementBuilder.method_698();
        }

        @Nullable
        public class_2960 method_10418() {
            return this.advancementId;
        }
    }
}

