/*
 * Decompiled with CFR 0.152.
 */
package com.chefmoon.ubesdelight.data.builder;

import com.chefmoon.ubesdelight.util.CookingPotRecipeCategory;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.nhoryzon.mc.farmersdelight.registry.RecipeTypesRegistry;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_193;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7798;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class CookingPotRecipeJsonBuilder
extends class_7798
implements class_5797 {
    private final class_7800 category;
    private final CookingPotRecipeCategory cookingCategory;
    private final class_1792 output;
    private final int outputCount;
    private final class_1799 container;
    private final List<class_1856> inputs;
    private final float experience;
    private final int cookingTime;
    private final class_161.class_162 advancementBuilder = class_161.class_162.method_51698();
    @Nullable
    private String group;

    private CookingPotRecipeJsonBuilder(class_7800 category, CookingPotRecipeCategory cookingCategory, class_1935 output, int outputCount, class_1799 container, List<class_1856> inputs, float experience, int cookingTime) {
        this.category = category;
        this.cookingCategory = cookingCategory;
        this.output = output.method_8389();
        this.outputCount = outputCount;
        this.container = !container.method_7960() ? container : (output.method_8389().method_7858() != null ? new class_1799((class_1935)Objects.requireNonNull(output.method_8389().method_7858())) : class_1799.field_8037);
        this.inputs = inputs;
        this.experience = experience;
        this.cookingTime = cookingTime;
    }

    public static CookingPotRecipeJsonBuilder create(class_7800 category, CookingPotRecipeCategory cookingCategory, class_1935 output, int outputCount, class_1799 container, List<class_1856> inputs, float experience, int cookingTime) {
        return new CookingPotRecipeJsonBuilder(category, cookingCategory, output, outputCount, container, inputs, experience, cookingTime);
    }

    public static CookingPotRecipeJsonBuilder create(CookingPotRecipeCategory cookingCategory, class_1935 output, int outputCount, int cookingTime, List<class_1856> inputs) {
        return new CookingPotRecipeJsonBuilder(class_7800.field_40640, cookingCategory, output, outputCount, class_1799.field_8037, inputs, 0.0f, cookingTime);
    }

    public static CookingPotRecipeJsonBuilder create(CookingPotRecipeCategory cookingCategory, class_1935 output, int outputCount, float experience, int cookingTime, List<class_1856> inputs) {
        return new CookingPotRecipeJsonBuilder(class_7800.field_40640, cookingCategory, output, outputCount, class_1799.field_8037, inputs, experience, cookingTime);
    }

    public static CookingPotRecipeJsonBuilder create(CookingPotRecipeCategory cookingCategory, class_1935 output, float experience, int cookingTime, List<class_1856> inputs) {
        return new CookingPotRecipeJsonBuilder(class_7800.field_40640, cookingCategory, output, 1, class_1799.field_8037, inputs, experience, cookingTime);
    }

    public CookingPotRecipeJsonBuilder input(class_6862<class_1792> tag) {
        return this.input(class_1856.method_8106(tag));
    }

    public CookingPotRecipeJsonBuilder input(class_1935 itemProvider) {
        return this.input(itemProvider, 1);
    }

    public CookingPotRecipeJsonBuilder input(class_1935 itemProvider, int size) {
        for (int i = 0; i < size; ++i) {
            this.input(class_1856.method_8091((class_1935[])new class_1935[]{itemProvider}));
        }
        return this;
    }

    public CookingPotRecipeJsonBuilder input(class_1856 ingredient) {
        return this.input(ingredient, 1);
    }

    public CookingPotRecipeJsonBuilder input(class_1856 ingredient, int size) {
        for (int i = 0; i < size; ++i) {
            this.inputs.add(ingredient);
        }
        return this;
    }

    public CookingPotRecipeJsonBuilder criterion(String name, class_184 conditions) {
        this.advancementBuilder.method_709(name, conditions);
        return this;
    }

    public CookingPotRecipeJsonBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    public class_1792 method_36441() {
        return this.output;
    }

    public void method_17972(Consumer<class_2444> exporter, class_2960 recipeId) {
        this.validate(recipeId);
        String fdCookingPrefix = "farmersdelight/cooking/";
        this.advancementBuilder.method_708(field_39377).method_709("has_the_recipe", (class_184)class_2119.method_27847((class_2960)recipeId.method_45138(fdCookingPrefix))).method_703(class_170.class_171.method_753((class_2960)recipeId.method_45138(fdCookingPrefix))).method_704(class_193.field_1257);
        exporter.accept(new CookingPotRecipeJsonProvider(recipeId.method_45138(fdCookingPrefix), this.group == null ? "" : this.group, this.cookingCategory, this.inputs, this.output, this.outputCount, this.container, this.experience, this.cookingTime, this.advancementBuilder, recipeId.method_45138("recipes/" + this.category.method_46203() + "/" + fdCookingPrefix)));
    }

    private void validate(class_2960 recipeId) {
        if (this.advancementBuilder.method_710().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + recipeId);
        }
    }

    public static class CookingPotRecipeJsonProvider
    implements class_2444 {
        private final class_2960 recipeId;
        private final String group;
        private final CookingPotRecipeCategory category;
        private final List<class_1856> inputs;
        private final class_1792 result;
        private final int resultCount;
        private final class_1799 container;
        private final float experience;
        private final int cookingTime;
        private final class_161.class_162 advancementBuilder;
        private final class_2960 advancementId;

        public CookingPotRecipeJsonProvider(class_2960 recipeId, String group, CookingPotRecipeCategory category, List<class_1856> inputs, class_1792 result, int resultCount, class_1799 container, float experience, int cookingTime, class_161.class_162 advancementBuilder, class_2960 advancementId) {
            this.recipeId = recipeId;
            this.group = group;
            this.category = category;
            this.inputs = inputs;
            this.result = result;
            this.container = container;
            this.resultCount = resultCount;
            this.experience = experience;
            this.cookingTime = cookingTime;
            this.advancementBuilder = advancementBuilder;
            this.advancementId = advancementId;
        }

        public void method_10416(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.addProperty("cookingtime", (Number)this.cookingTime);
            if (this.experience > 0.0f) {
                json.addProperty("experience", (Number)Float.valueOf(this.experience));
            }
            JsonArray jsonArray = new JsonArray();
            for (class_1856 ingredient : this.inputs) {
                jsonArray.add(ingredient.method_8089());
            }
            json.add("ingredients", (JsonElement)jsonArray);
            json.addProperty("recipe_book_tab", this.category.method_15434());
            JsonObject resultObject = new JsonObject();
            resultObject.addProperty("item", class_7923.field_41178.method_10221((Object)this.result).toString());
            if (this.resultCount > 1) {
                resultObject.addProperty("count", (Number)this.resultCount);
            }
            json.add("result", (JsonElement)resultObject);
            if (!this.container.method_7960() && this.result.method_7858() != null && !this.container.method_31574(this.result.method_7858())) {
                JsonObject containerObject = new JsonObject();
                containerObject.addProperty("item", class_7923.field_41178.method_10221((Object)this.container.method_7909()).toString());
                json.add("container", (JsonElement)containerObject);
            }
        }

        public class_1865<?> method_17800() {
            return RecipeTypesRegistry.COOKING_RECIPE_SERIALIZER.serializer();
        }

        public class_2960 method_10417() {
            return this.recipeId;
        }

        @Nullable
        public JsonObject method_10415() {
            return this.advancementBuilder.method_698();
        }

        @Nullable
        public class_2960 method_10418() {
            return this.advancementId;
        }
    }
}

