/*
 * Decompiled with CFR 0.152.
 */
package com.chefmoon.ubesdelight.recipe;

import com.chefmoon.ubesdelight.recipe.BakingMatRecipe;
import com.chefmoon.ubesdelight.recipe.ingredient.ChanceResult;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class BakingMatRecipeSerializer
implements class_1865<BakingMatRecipe> {
    public BakingMatRecipe read(class_2960 id, JsonObject json) {
        String group = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
        class_2371<class_1856> ingredientList = BakingMatRecipeSerializer.readIngredients(class_3518.method_15261((JsonObject)json, (String)"ingredients"));
        class_2371<class_1856> processingStages = BakingMatRecipeSerializer.readProcessingStages(class_3518.method_15261((JsonObject)json, (String)"processing_stages"));
        class_1856 tool = class_1856.method_52177((JsonElement)class_3518.method_15296((JsonObject)json, (String)"tool"));
        if (ingredientList.isEmpty()) {
            throw new JsonParseException("No ingredients for baking recipe");
        }
        if (tool.method_8103()) {
            throw new JsonParseException("No tool for baking recipe");
        }
        if (ingredientList.size() > 9) {
            throw new JsonParseException("Too many ingredients for baking recipe! Max ingredients is 9");
        }
        if (processingStages.size() > 5) {
            throw new JsonParseException("Too many processing stages for baking recipe! Max processing stages is 5");
        }
        class_2371<ChanceResult> resultList = BakingMatRecipeSerializer.readResultList(class_3518.method_15261((JsonObject)json, (String)"result"));
        if (resultList.size() > 4) {
            throw new JsonParseException("Too many results for baking recipe! The maximum quantity of unique results is 4");
        }
        String soundId = class_3518.method_15253((JsonObject)json, (String)"sound", (String)"");
        return new BakingMatRecipe(id, group, ingredientList, processingStages, tool, resultList, soundId);
    }

    public BakingMatRecipe read(class_2960 id, class_2540 buf) {
        String groupIn = buf.method_10800(Short.MAX_VALUE);
        class_2371 ingredientList = class_2371.method_10213((int)buf.method_10816(), (Object)class_1856.field_9017);
        ingredientList.replaceAll(ignored -> class_1856.method_8086((class_2540)buf));
        class_2371 processingStagesList = class_2371.method_10213((int)buf.method_10816(), (Object)class_1856.field_9017);
        processingStagesList.replaceAll(ignored -> class_1856.method_8086((class_2540)buf));
        class_1856 tool = class_1856.method_8086((class_2540)buf);
        class_2371 resultList = class_2371.method_10213((int)buf.method_10816(), (Object)ChanceResult.EMPTY);
        resultList.replaceAll(ignored -> ChanceResult.read(buf));
        String soundId = buf.method_19772();
        return new BakingMatRecipe(id, groupIn, (class_2371<class_1856>)ingredientList, (class_2371<class_1856>)processingStagesList, tool, (class_2371<ChanceResult>)resultList, soundId);
    }

    public void write(class_2540 buf, BakingMatRecipe recipe) {
        buf.method_10814(recipe.method_8112());
        buf.method_10804(recipe.method_8117().size());
        for (class_1856 ingredient : recipe.method_8117()) {
            ingredient.method_8088(buf);
        }
        buf.method_10804(recipe.getProcessStages().size());
        for (class_1856 processingStages : recipe.getProcessStages()) {
            processingStages.method_8088(buf);
        }
        recipe.getTool().method_8088(buf);
        buf.method_10804(recipe.getRollableResults().size());
        for (ChanceResult result : recipe.getRollableResults()) {
            result.write(buf);
        }
        buf.method_10814(recipe.getSoundEvent());
    }

    private static class_2371<class_1856> readIngredients(JsonArray ingredientArray) {
        class_2371 ingredientList = class_2371.method_10211();
        for (JsonElement ingredientJson : ingredientArray) {
            class_1856 ingredient = class_1856.method_52177((JsonElement)ingredientJson);
            if (ingredient.method_8103()) continue;
            ingredientList.add((Object)ingredient);
        }
        return ingredientList;
    }

    private static class_2371<class_1856> readProcessingStages(JsonArray processStagesArray) {
        class_2371 processingStageList = class_2371.method_10211();
        for (JsonElement ingredientJson : processStagesArray) {
            class_1856 ingredient = class_1856.method_52177((JsonElement)ingredientJson);
            if (ingredient.method_8103()) continue;
            processingStageList.add((Object)ingredient);
        }
        return processingStageList;
    }

    private static class_2371<ChanceResult> readResultList(JsonArray resultArray) {
        class_2371 resultList = class_2371.method_10211();
        for (JsonElement resultJson : resultArray) {
            resultList.add((Object)ChanceResult.deserialize(resultJson));
        }
        return resultList;
    }
}

