/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.athena.impl.client.models;

import com.google.gson.JsonObject;
import earth.terrarium.athena.api.client.models.AthenaBlockModel;
import earth.terrarium.athena.api.client.models.AthenaModelFactory;
import earth.terrarium.athena.api.client.models.AthenaQuad;
import earth.terrarium.athena.api.client.utils.AppearanceAndTintGetter;
import earth.terrarium.athena.api.client.utils.AthenaUtils;
import earth.terrarium.athena.api.client.utils.CtmUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1058;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_3518;
import net.minecraft.class_4730;

public class PanePillarBlockModel
implements AthenaBlockModel {
    public static final AthenaModelFactory FACTORY = new Factory();
    private static final List<AthenaQuad> MIDDLE = List.of(new AthenaQuad(6, 0.4375f, 0.5625f, 1.0f, 0.0f, class_2470.field_11467, 0.4375f));
    private final Int2ObjectMap<class_4730> materials;
    private static final AthenaQuad TOP_MIDDLE = new AthenaQuad(5, 0.4375f, 0.5625f, 0.5625f, 0.4375f, class_2470.field_11467, 0.0f, false);
    private static final AthenaQuad NORTH = new AthenaQuad(5, 0.4375f, 0.5625f, 1.0f, 0.5625f, class_2470.field_11467, 0.0f, false);
    private static final AthenaQuad SOUTH = new AthenaQuad(5, 0.4375f, 0.5625f, 0.4375f, 0.0f, class_2470.field_11467, 0.0f, false);
    private static final AthenaQuad EAST = new AthenaQuad(5, 0.5625f, 1.0f, 0.5625f, 0.4375f, class_2470.field_11467, 0.0f, false);
    private static final AthenaQuad WEST = new AthenaQuad(5, 0.0f, 0.4375f, 0.5625f, 0.4375f, class_2470.field_11467, 0.0f, false);

    public PanePillarBlockModel(Int2ObjectMap<class_4730> materials) {
        this.materials = materials;
    }

    @Override
    public List<AthenaQuad> getQuads(AppearanceAndTintGetter level, class_2680 state, class_2338 pos, class_2350 direction) {
        int texture;
        boolean belowState;
        if (direction.method_10166().method_10178()) {
            if (level.method_8320(pos.method_10093(direction)) == state) {
                return List.of();
            }
            return this.getTopQuad(state, direction.method_10171());
        }
        boolean rightState = AthenaUtils.getFromDir(state, direction.method_10160());
        boolean leftState = AthenaUtils.getFromDir(state, direction.method_10170());
        class_2680 upBlockState = level.getAppearance(pos.method_10084(), direction, state, pos);
        class_2680 downBlockState = level.getAppearance(pos.method_10074(), direction, state, pos);
        boolean upState = upBlockState.method_27852(state.method_26204()) && AthenaUtils.getFromDir(upBlockState, direction.method_10160()) && AthenaUtils.getFromDir(upBlockState, direction.method_10170());
        boolean bl = belowState = downBlockState.method_27852(state.method_26204()) && AthenaUtils.getFromDir(downBlockState, direction.method_10160()) && AthenaUtils.getFromDir(downBlockState, direction.method_10170());
        int n = upState && belowState ? 2 : (upState ? 3 : (texture = belowState ? 1 : 4));
        if (leftState && rightState) {
            float min = AthenaUtils.getFromDir(state, direction) ? 0.4375f : 0.5f;
            return List.of(new AthenaQuad(texture, 0.0f, min, 1.0f, 0.5f, class_2470.field_11467, 0.4375f), new AthenaQuad(texture, 1.0f - min, 1.0f, 1.0f, 0.5f, class_2470.field_11467, 0.4375f), new AthenaQuad(texture, 0.0f, min, 0.5f, 0.0f, class_2470.field_11467, 0.4375f), new AthenaQuad(texture, 1.0f - min, 1.0f, 0.5f, 0.0f, class_2470.field_11467, 0.4375f));
        }
        if (leftState) {
            float min = AthenaUtils.getFromDir(state, direction) ? 0.5625f : 0.4375f;
            return List.of(new AthenaQuad(0, 0.0f, 1.0f - min, 1.0f, 0.0f, class_2470.field_11467, 0.4375f));
        }
        if (rightState) {
            float min = AthenaUtils.getFromDir(state, direction) ? 0.5625f : 0.4375f;
            return List.of(new AthenaQuad(0, min, 1.0f, 1.0f, 0.0f, class_2470.field_11467, 0.4375f));
        }
        if (level.method_8320(pos.method_10093(direction)).method_26204() != state.method_26204() && !AthenaUtils.getFromDir(state, direction)) {
            return MIDDLE;
        }
        return List.of();
    }

    @Override
    public Int2ObjectMap<class_1058> getTextures(Function<class_4730, class_1058> getter) {
        Int2ObjectArrayMap textures = new Int2ObjectArrayMap();
        for (Int2ObjectMap.Entry entry : this.materials.int2ObjectEntrySet()) {
            textures.put(entry.getIntKey(), (Object)getter.apply((class_4730)entry.getValue()));
        }
        return textures;
    }

    private List<AthenaQuad> getTopQuad(class_2680 state, class_2350.class_2352 direction) {
        boolean north = AthenaUtils.getFromDir(state, class_2350.field_11043);
        boolean south = AthenaUtils.getFromDir(state, class_2350.field_11035);
        boolean east = AthenaUtils.getFromDir(state, class_2350.field_11034);
        boolean west = AthenaUtils.getFromDir(state, class_2350.field_11039);
        if (direction == class_2350.class_2352.field_11060) {
            boolean tempNorth = north;
            north = south;
            south = tempNorth;
            boolean tempEast = east;
            east = west;
            west = tempEast;
        }
        ArrayList<AthenaQuad> quads = new ArrayList<AthenaQuad>();
        quads.add(TOP_MIDDLE);
        if (north) {
            quads.add(NORTH);
        }
        if (south) {
            quads.add(SOUTH);
        }
        if (east) {
            quads.add(EAST);
        }
        if (west) {
            quads.add(WEST);
        }
        return quads;
    }

    private static class Factory
    implements AthenaModelFactory {
        private Factory() {
        }

        @Override
        public Supplier<AthenaBlockModel> create(JsonObject json) {
            Int2ObjectMap<class_4730> materials = Factory.parseMaterials(class_3518.method_15296((JsonObject)json, (String)"ctm_textures"));
            return () -> new PanePillarBlockModel(materials);
        }

        private static Int2ObjectMap<class_4730> parseMaterials(JsonObject json) {
            Int2ObjectArrayMap materials = new Int2ObjectArrayMap();
            materials.put(0, (Object)CtmUtils.blockMat(class_3518.method_15265((JsonObject)json, (String)"particle")));
            materials.put(4, (Object)CtmUtils.blockMat(class_3518.method_15265((JsonObject)json, (String)"self")));
            materials.put(1, (Object)CtmUtils.blockMat(class_3518.method_15265((JsonObject)json, (String)"top")));
            materials.put(2, (Object)CtmUtils.blockMat(class_3518.method_15265((JsonObject)json, (String)"center")));
            materials.put(3, (Object)CtmUtils.blockMat(class_3518.method_15265((JsonObject)json, (String)"bottom")));
            materials.put(5, (Object)CtmUtils.blockMat(class_3518.method_15253((JsonObject)json, (String)"edge", (String)class_3518.method_15265((JsonObject)json, (String)"particle"))));
            materials.put(6, (Object)CtmUtils.blockMat(class_3518.method_15253((JsonObject)json, (String)"side_edge", (String)class_3518.method_15265((JsonObject)json, (String)"particle"))));
            return materials;
        }
    }
}

