/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.sorter;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.InventoryImproved;
import com.tiviacz.travelersbackpack.inventory.sorter.SortType;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

public class InventorySorter {
    public static final byte SORT_BACKPACK = 0;
    public static final byte QUICK_STACK = 1;
    public static final byte TRANSFER_TO_BACKPACK = 2;
    public static final byte TRANSFER_TO_PLAYER = 3;
    public static final byte SORT = 4;
    public static final byte MEMORY = 5;

    public static void selectSort(ITravelersBackpackInventory inventory, class_1657 player, byte button, boolean shiftPressed) {
        if (button == 0) {
            InventorySorter.sortBackpack(inventory, player, SortType.Type.CATEGORY, shiftPressed);
        } else if (button == 1) {
            InventorySorter.quickStackToBackpackNoSort(inventory, player, shiftPressed);
        } else if (button == 2) {
            InventorySorter.transferToBackpackNoSort(inventory, player, shiftPressed);
        } else if (button == 3) {
            InventorySorter.transferToPlayer(inventory, player);
        } else if (button == 4) {
            InventorySorter.setUnsortable(inventory, player, shiftPressed);
        } else if (button == 5) {
            InventorySorter.setMemory(inventory, player, shiftPressed);
        }
    }

    public static void sortBackpack(ITravelersBackpackInventory inventory, class_1657 player, SortType.Type type, boolean shiftPressed) {
        if (!inventory.getSlotManager().isSelectorActive((byte)0)) {
            ArrayList<class_1799> stacks = new ArrayList<class_1799>();
            for (int i = 0; i < inventory.getInventory().method_5439(); ++i) {
                InventorySorter.addStackWithMerge(stacks, inventory.getSlotManager().isSlot((byte)0, i) ? class_1799.field_8037 : inventory.getInventory().method_5438(i));
            }
            if (!stacks.isEmpty()) {
                stacks.sort(Comparator.comparing(stack -> SortType.getStringForSort(stack, type)));
            }
            if (stacks.isEmpty()) {
                return;
            }
            int j = 0;
            for (int i = 0; i < inventory.getInventory().method_5439(); ++i) {
                if (inventory.getSlotManager().isSlot((byte)0, i)) continue;
                inventory.getInventory().method_5447(i, j < stacks.size() ? (class_1799)stacks.get(j) : class_1799.field_8037);
                ++j;
            }
            inventory.markDataDirty(0);
        }
    }

    public static void quickStackToBackpackNoSort(ITravelersBackpackInventory inventory, class_1657 player, boolean shiftPressed) {
        int i;
        int n = i = shiftPressed ? 0 : 9;
        while (i < 36) {
            boolean hasExistingStack;
            class_1799 playerStack = player.method_31548().method_5438(i);
            if (!playerStack.method_7960() && inventory.getInventory().method_5437(0, playerStack) && (inventory.getScreenID() != 1 || i != player.method_31548().field_7545) && (hasExistingStack = IntStream.range(0, inventory.getInventory().method_5439()).mapToObj(inventory.getInventory()::method_5438).filter(existing -> !existing.method_7960()).anyMatch(existing -> existing.method_7909() == playerStack.method_7909()))) {
                class_1799 ext = InventorySorter.extractItem(inventory, (class_1263)player.method_31548(), i, Integer.MAX_VALUE, false);
                for (int j = 0; j < inventory.getInventory().method_5439() && !(ext = InventorySorter.insertItem(inventory, inventory.getInventory(), j, ext, false)).method_7960(); ++j) {
                }
                if (!ext.method_7960()) {
                    InventorySorter.insertItem(inventory, (class_1263)player.method_31548(), i, ext, false);
                }
            }
            ++i;
        }
    }

    public static void transferToBackpackNoSort(ITravelersBackpackInventory inventory, class_1657 player, boolean shiftPressed) {
        int i;
        block10: {
            if (inventory.getSlotManager().getMemorySlots().isEmpty()) break block10;
            for (Pair<Integer, class_1799> pair : inventory.getSlotManager().getMemorySlots()) {
                int i2;
                int n = i2 = shiftPressed ? 0 : 9;
                while (i2 < 36) {
                    block11: {
                        class_1799 ext;
                        block12: {
                            class_1799 playerStack = player.method_31548().method_5438(i2);
                            if (playerStack.method_7960() || inventory.getScreenID() == 1 && i2 == player.method_31548().field_7545) break block11;
                            class_1799 extSimulate = InventorySorter.extractItem(inventory, (class_1263)player.method_31548(), i2, Integer.MAX_VALUE, true);
                            ext = class_1799.field_8037;
                            if (!ItemStackUtils.canCombine((class_1799)pair.getSecond(), extSimulate)) break block12;
                            ext = InventorySorter.extractItem(inventory, (class_1263)player.method_31548(), i2, Integer.MAX_VALUE, false);
                            ext = InventorySorter.insertItem(inventory, inventory.getInventory(), (Integer)pair.getFirst(), ext, false);
                            if (ext.method_7960()) break block11;
                        }
                        if (!ext.method_7960()) {
                            InventorySorter.insertItem(inventory, (class_1263)player.method_31548(), i2, ext, false);
                        }
                    }
                    ++i2;
                }
            }
        }
        int n = i = shiftPressed ? 0 : 9;
        while (i < 36) {
            class_1799 playerStack = player.method_31548().method_5438(i);
            if (!playerStack.method_7960() && inventory.getInventory().method_5437(0, playerStack) && (inventory.getScreenID() != 1 || i != player.method_31548().field_7545)) {
                class_1799 ext = InventorySorter.extractItem(inventory, (class_1263)player.method_31548(), i, Integer.MAX_VALUE, false);
                for (int j = 0; j < inventory.getInventory().method_5439() && !(ext = InventorySorter.insertItem(inventory, inventory.getInventory(), j, ext, false)).method_7960(); ++j) {
                }
                if (!ext.method_7960()) {
                    InventorySorter.insertItem(inventory, (class_1263)player.method_31548(), i, ext, false);
                }
            }
            ++i;
        }
    }

    public static void transferToPlayer(ITravelersBackpackInventory inventory, class_1657 player) {
        for (int i = 0; i < inventory.getInventory().method_5439(); ++i) {
            class_1799 stack = inventory.getInventory().method_5438(i);
            if (stack.method_7960()) continue;
            class_1799 ext = InventorySorter.extractItem(inventory, inventory.getInventory(), i, Integer.MAX_VALUE, false);
            for (int j = 9; j < 36 && !(ext = InventorySorter.insertItem(inventory, (class_1263)player.method_31548(), j, ext, false)).method_7960(); ++j) {
            }
            if (ext.method_7960()) continue;
            InventorySorter.insertItem(inventory, inventory.getInventory(), i, ext, true);
        }
    }

    public static void setUnsortable(ITravelersBackpackInventory container, class_1657 player, boolean shiftPressed) {
        container.getSlotManager().setSelectorActive((byte)0, !container.getSlotManager().isSelectorActive((byte)0));
    }

    public static void setMemory(ITravelersBackpackInventory container, class_1657 player, boolean shiftPressed) {
        container.getSlotManager().setSelectorActive((byte)1, !container.getSlotManager().isSelectorActive((byte)1));
    }

    private static void addStackWithMerge(List<class_1799> stacks, class_1799 newStack) {
        if (newStack.method_7960()) {
            return;
        }
        if (newStack.method_7946() && newStack.method_7947() != newStack.method_7914()) {
            for (int j = stacks.size() - 1; j >= 0; --j) {
                class_1799 oldStack = stacks.get(j);
                if (!InventorySorter.canMergeItems(newStack, oldStack)) continue;
                InventorySorter.combineStacks(newStack, oldStack);
                if (!oldStack.method_7960() && oldStack.method_7947() != 0) continue;
                stacks.remove(j);
            }
        }
        stacks.add(newStack);
    }

    private static void combineStacks(class_1799 stack, class_1799 stack2) {
        if (stack.method_7914() >= stack.method_7947() + stack2.method_7947()) {
            stack.method_7933(stack2.method_7947());
            stack2.method_7939(0);
        }
        int maxInsertAmount = Math.min(stack.method_7914() - stack.method_7947(), stack2.method_7947());
        stack.method_7933(maxInsertAmount);
        stack2.method_7934(maxInsertAmount);
    }

    private static boolean canMergeItems(class_1799 stack1, class_1799 stack2) {
        if (!stack1.method_7946() || !stack2.method_7946()) {
            return false;
        }
        if (stack1.method_7947() == stack2.method_7914() || stack2.method_7947() == stack2.method_7914()) {
            return false;
        }
        if (stack1.method_7909() != stack2.method_7909()) {
            return false;
        }
        if (stack1.method_7919() != stack2.method_7919()) {
            return false;
        }
        return class_1799.method_31577((class_1799)stack1, (class_1799)stack2);
    }

    public static class_1799 insertItem(ITravelersBackpackInventory inventory, class_1263 target, int slot, @NotNull class_1799 stack, boolean isTransferToPlayer) {
        boolean reachedLimit;
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        if (!target.method_5437(slot, stack)) {
            return stack;
        }
        if (target instanceof InventoryImproved && inventory.getSlotManager().isSlot((byte)0, slot)) {
            return stack;
        }
        if (target instanceof InventoryImproved && inventory.getSlotManager().isSlot((byte)1, slot) && inventory.getSlotManager().getMemorySlots().stream().noneMatch(pair -> (Integer)pair.getFirst() == slot && ItemStackUtils.canCombine((class_1799)pair.getSecond(), stack)) && !isTransferToPlayer) {
            return stack;
        }
        class_1799 existing = target.method_5438(slot);
        int limit = stack.method_7914();
        if (!existing.method_7960()) {
            if (!InventorySorter.canItemStacksStack(stack, existing)) {
                return stack;
            }
            limit -= existing.method_7947();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.method_7947() > limit;
        if (existing.method_7960()) {
            target.method_5447(slot, reachedLimit ? InventorySorter.copyStackWithSize(stack, limit) : stack);
        } else {
            existing.method_7933(reachedLimit ? limit : stack.method_7947());
        }
        target.method_5431();
        return reachedLimit ? InventorySorter.copyStackWithSize(stack, stack.method_7947() - limit) : class_1799.field_8037;
    }

    public static class_1799 extractItem(ITravelersBackpackInventory inventory, class_1263 target, int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return class_1799.field_8037;
        }
        if (target instanceof InventoryImproved && inventory.getSlotManager().isSlot((byte)0, slot)) {
            return class_1799.field_8037;
        }
        class_1799 existing = target.method_5438(slot);
        if (existing.method_7960()) {
            return class_1799.field_8037;
        }
        int toExtract = Math.min(amount, existing.method_7914());
        if (existing.method_7947() <= toExtract) {
            if (!simulate) {
                target.method_5447(slot, class_1799.field_8037);
                target.method_5431();
                return existing;
            }
            return existing.method_7972();
        }
        if (!simulate) {
            target.method_5447(slot, InventorySorter.copyStackWithSize(existing, existing.method_7947() - toExtract));
            target.method_5431();
        }
        return InventorySorter.copyStackWithSize(existing, toExtract);
    }

    public static boolean canItemStacksStack(@NotNull class_1799 a, @NotNull class_1799 b) {
        if (a.method_7960() || !class_1799.method_7984((class_1799)a, (class_1799)b) || a.method_7985() != b.method_7985()) {
            return false;
        }
        return !a.method_7985() || a.method_7969().equals((Object)b.method_7969());
    }

    public static class_1799 copyStackWithSize(@NotNull class_1799 itemStack, int size) {
        if (size == 0) {
            return class_1799.field_8037;
        }
        class_1799 copy = itemStack.method_7972();
        copy.method_7939(size);
        return copy;
    }
}

