/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.config;

import com.aizistral.nochatreports.common.NCRCore;
import com.aizistral.nochatreports.common.config.JSONConfig;
import com.aizistral.nochatreports.common.config.NCRConfigClient;
import com.aizistral.nochatreports.common.config.NCRConfigCommon;
import com.aizistral.nochatreports.common.config.NCRConfigEncryption;
import com.aizistral.nochatreports.common.config.NCRServerPreferences;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public final class NCRConfig {
    private static NCRConfigCommon common = null;
    private static NCRConfigClient client = null;
    private static NCRServerPreferences serverPreferences = null;
    private static NCRConfigEncryption encryption = null;

    private NCRConfig() {
        throw new IllegalStateException("Can't touch this");
    }

    public static NCRConfigCommon getCommon() {
        return NCRConfig.checkLoaded(() -> common);
    }

    @Environment(value=EnvType.CLIENT)
    public static NCRConfigClient getClient() {
        return NCRConfig.checkLoaded(() -> client);
    }

    @Environment(value=EnvType.CLIENT)
    public static NCRServerPreferences getServerPreferences() {
        return NCRConfig.checkLoaded(() -> serverPreferences);
    }

    @Environment(value=EnvType.CLIENT)
    public static NCRConfigEncryption getEncryption() {
        return NCRConfig.checkLoaded(() -> encryption);
    }

    private static <T extends JSONConfig> T checkLoaded(Supplier<T> config) {
        if (config.get() == null) {
            NCRConfig.load();
        }
        return (T)((JSONConfig)config.get());
    }

    public static void load() {
        common = JSONConfig.loadConfig(NCRConfigCommon.class, NCRConfigCommon::new, "NoChatReports/NCR-Common.json");
        if (NCRCore.getProvider().isOnClient()) {
            client = JSONConfig.loadConfig(NCRConfigClient.class, NCRConfigClient::new, "NoChatReports/NCR-Client.json");
            serverPreferences = JSONConfig.loadConfig(NCRServerPreferences.class, NCRServerPreferences::new, "NoChatReports/NCR-ServerPreferences.json");
            encryption = JSONConfig.loadConfig(NCRConfigEncryption.class, NCRConfigEncryption::new, "NoChatReports/NCR-Encryption.json");
        }
        NCRConfig.save();
    }

    public static void save() {
        NCRConfig.checkLoaded(() -> common).saveFile();
        if (NCRCore.getProvider().isOnClient()) {
            NCRConfig.checkLoaded(() -> client).saveFile();
            NCRConfig.checkLoaded(() -> serverPreferences).saveFile();
            NCRConfig.checkLoaded(() -> encryption).saveFile();
        }
        Path readme = JSONConfig.CONFIG_DIR.resolve("NoChatReports/README.md");
        try {
            Files.writeString(readme, (CharSequence)"# No Chat Reports\nYou can find updated documentation of configuration files on the wiki:\nhttps://github.com/Aizistral-Studios/No-Chat-Reports/wiki/Configuration-Files\n", StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (Exception ex) {
            NCRCore.LOGGER.fatal("Could not write README file: {}", (Object)readme);
            throw new RuntimeException(ex);
        }
    }
}

