/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.chiseling;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.rechiseled.chiseling.ChiselingEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class ChiselingRecipe {
    private final class_2960 recipeId;
    final class_2960 parentRecipeId;
    final boolean overwrite;
    private final List<ChiselingEntry> entries;

    private ChiselingRecipe(class_2960 recipeId, class_2960 parentRecipeId, boolean overwrite, Collection<ChiselingEntry> entries) {
        this.recipeId = recipeId;
        this.parentRecipeId = parentRecipeId;
        this.overwrite = overwrite;
        this.entries = Collections.unmodifiableList(Arrays.asList((ChiselingEntry[])entries.toArray(ChiselingEntry[]::new)));
    }

    ChiselingRecipe(class_2960 recipeId, class_2960 parentRecipeId, Collection<ChiselingEntry> entries) {
        this(recipeId, parentRecipeId, false, entries);
    }

    public List<ChiselingEntry> getEntries() {
        return this.entries;
    }

    public boolean contains(class_1799 stack) {
        for (ChiselingEntry entry : this.entries) {
            if ((!entry.hasRegularItem() || entry.getRegularItem() != stack.method_7909()) && (!entry.hasConnectingItem() || entry.getConnectingItem() != stack.method_7909())) continue;
            return true;
        }
        return false;
    }

    public class_2960 getRecipeId() {
        return this.recipeId;
    }

    public static class Serializer {
        public static ChiselingRecipe fromJson(class_2960 resourceLocation, JsonObject json) {
            ArrayList<ChiselingEntry> chiselingEntries = new ArrayList<ChiselingEntry>();
            String parentRecipeString = class_3518.method_15253((JsonObject)json, (String)"parent", null);
            class_2960 parentRecipe = parentRecipeString == null ? null : new class_2960(parentRecipeString);
            boolean overwrite = class_3518.method_15258((JsonObject)json, (String)"overwrite", (boolean)false);
            if (!class_3518.method_15264((JsonObject)json, (String)"entries")) {
                throw new JsonParseException("Recipe must have an 'entries' array!");
            }
            JsonArray array = class_3518.method_15261((JsonObject)json, (String)"entries");
            for (JsonElement element : array) {
                class_1792 connectingItem;
                class_1792 regularItem;
                if (!element.isJsonObject()) {
                    throw new JsonParseException("Recipe entries must be json objects with 'item' and 'connecting_item' keys!");
                }
                JsonObject object = element.getAsJsonObject();
                if (!object.has("item") && !object.has("connecting_item")) {
                    throw new JsonParseException("Recipe entry must be have at least one of 'item' or 'connecting_item' keys!");
                }
                boolean optional = class_3518.method_15258((JsonObject)object, (String)"optional", (boolean)false);
                String regularItemName = class_3518.method_15253((JsonObject)object, (String)"item", (String)"");
                if (regularItemName.isEmpty()) {
                    regularItem = null;
                } else {
                    regularItem = (class_1792)Registries.ITEMS.getValue(new class_2960(regularItemName));
                    if (regularItem == null && !optional) {
                        throw new JsonParseException("Unknown item '" + regularItemName + "'");
                    }
                }
                String connectingItemName = class_3518.method_15253((JsonObject)object, (String)"connecting_item", (String)"");
                if (connectingItemName.isEmpty()) {
                    connectingItem = null;
                } else {
                    connectingItem = (class_1792)Registries.ITEMS.getValue(new class_2960(connectingItemName));
                    if (connectingItem == null && !optional) {
                        throw new JsonParseException("Unknown item '" + connectingItemName + "'");
                    }
                }
                if (regularItem == null && connectingItem == null) {
                    throw new JsonParseException("Recipe entry must be have at least one of 'item' or 'connecting_item' keys!");
                }
                chiselingEntries.add(new ChiselingEntry(regularItem, connectingItem));
            }
            return new ChiselingRecipe(resourceLocation, parentRecipe, overwrite, chiselingEntries);
        }

        public static ChiselingRecipe fromNetwork(class_2540 buffer) {
            ArrayList<ChiselingEntry> chiselingEntries = new ArrayList<ChiselingEntry>();
            class_2960 recipeId = buffer.method_10810();
            int entries = buffer.readInt();
            for (int i = 0; i < entries; ++i) {
                chiselingEntries.add(new ChiselingEntry(buffer.readBoolean() ? class_1792.method_7875((int)buffer.method_10816()) : null, buffer.readBoolean() ? class_1792.method_7875((int)buffer.method_10816()) : null));
            }
            return new ChiselingRecipe(recipeId, null, false, chiselingEntries);
        }

        public static void toNetwork(class_2540 buffer, ChiselingRecipe recipe) {
            buffer.method_10812(recipe.recipeId);
            buffer.writeInt(recipe.entries.size());
            for (ChiselingEntry entry : recipe.entries) {
                buffer.writeBoolean(entry.getRegularItem() != null);
                if (entry.getRegularItem() != null) {
                    buffer.method_10804(class_1792.method_7880((class_1792)entry.getRegularItem()));
                }
                buffer.writeBoolean(entry.getConnectingItem() != null);
                if (entry.getConnectingItem() == null) continue;
                buffer.method_10804(class_1792.method_7880((class_1792)entry.getConnectingItem()));
            }
        }
    }
}

