/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.screen;

import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.core.gui.BaseContainerType;
import com.supermartijn642.rechiseled.chiseling.ChiselingEntry;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipe;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipes;
import com.supermartijn642.rechiseled.screen.DummySlot;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;

public abstract class BaseChiselingContainer
extends BaseContainer {
    public ChiselingRecipe currentRecipe = null;
    public ChiselingEntry currentEntry = null;
    public boolean connecting = false;

    public BaseChiselingContainer(BaseContainerType<?> type, class_1657 player) {
        super(type, player);
        this.addSlots();
    }

    protected void addSlots(class_1657 playerEntity) {
        this.method_7621(new DummySlot(0, 154, 102){

            @Override
            public void method_7673(class_1799 stack) {
                BaseChiselingContainer.this.setCurrentStack(stack);
                BaseChiselingContainer.this.updateRecipe();
            }

            @Override
            public class_1799 method_7677() {
                return BaseChiselingContainer.this.getCurrentStack();
            }

            public boolean method_7680(class_1799 stack) {
                return ChiselingRecipes.getRecipe(stack) != null;
            }
        });
        this.addPlayerSlots(31, 144);
    }

    public boolean method_7597(class_1657 playerIn) {
        return !this.shouldBeClosed();
    }

    protected void updateRecipe() {
        class_1799 stack = this.getCurrentStack();
        if (stack.method_7960()) {
            this.currentRecipe = null;
            this.currentEntry = null;
            this.connecting = false;
        } else {
            this.currentRecipe = ChiselingRecipes.getRecipe(stack);
            if (this.currentRecipe != null) {
                for (ChiselingEntry entry : this.currentRecipe.getEntries()) {
                    if (entry.hasRegularItem() && entry.getRegularItem() == stack.method_7909()) {
                        this.currentEntry = entry;
                        this.connecting = false;
                        return;
                    }
                    if (!entry.hasConnectingItem() || entry.getConnectingItem() != stack.method_7909()) continue;
                    this.currentEntry = entry;
                    this.connecting = true;
                    return;
                }
            } else {
                this.currentEntry = null;
                this.connecting = false;
            }
        }
    }

    public void setCurrentEntry(int index) {
        if (this.currentRecipe == null || index >= this.currentRecipe.getEntries().size()) {
            return;
        }
        ChiselingEntry entry = this.currentRecipe.getEntries().get(index);
        class_1792 item = this.connecting && entry.hasConnectingItem() || !entry.hasRegularItem() ? entry.getConnectingItem() : entry.getRegularItem();
        class_1799 stack = new class_1799((class_1935)item, this.getCurrentStack().method_7947());
        this.setCurrentStack(stack);
        this.updateRecipe();
    }

    public void toggleConnecting() {
        if (this.currentRecipe == null) {
            return;
        }
        if (this.connecting) {
            if (this.currentEntry.hasRegularItem()) {
                class_1799 stack = new class_1799((class_1935)this.currentEntry.getRegularItem(), this.getCurrentStack().method_7947());
                this.setCurrentStack(stack);
                this.updateRecipe();
            }
        } else if (this.currentEntry.hasConnectingItem()) {
            class_1799 stack = new class_1799((class_1935)this.currentEntry.getConnectingItem(), this.getCurrentStack().method_7947());
            this.setCurrentStack(stack);
            this.updateRecipe();
        }
    }

    public void chiselAll() {
        if (this.currentRecipe == null) {
            return;
        }
        class_1661 inventory = this.player.method_31548();
        for (int index = 0; index < inventory.method_5439(); ++index) {
            class_1792 item;
            class_1799 stack = inventory.method_5438(index);
            class_1792 class_17922 = item = this.connecting ? this.currentEntry.getConnectingItem() : this.currentEntry.getRegularItem();
            if (stack.method_7947() > item.method_7882()) continue;
            for (ChiselingEntry entry : this.currentRecipe.getEntries()) {
                if (stack.method_7985() && !stack.method_7969().method_33133() || (!entry.hasConnectingItem() || stack.method_7909() != entry.getConnectingItem()) && (!entry.hasRegularItem() || stack.method_7909() != entry.getRegularItem())) continue;
                stack = new class_1799((class_1935)item, stack.method_7947());
                inventory.method_5447(index, stack);
            }
        }
    }

    public abstract class_1799 getCurrentStack();

    public abstract void setCurrentStack(class_1799 var1);

    public abstract boolean shouldBeClosed();

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 stack = this.method_7611(index).method_7677();
        if (stack.method_7960()) {
            return stack;
        }
        if (index == 0 ? !this.method_7616(stack, 1, this.field_7761.size(), true) : !this.method_7616(stack, 0, 1, true)) {
            return class_1799.field_8037;
        }
        if (stack.method_7960()) {
            ((class_1735)this.field_7761.get(index)).method_7673(stack);
        }
        return stack;
    }

    protected boolean method_7616(class_1799 stack, int minSlot, int maxSlot, boolean reversed) {
        class_1799 slotStack;
        class_1735 slot;
        boolean changed = false;
        int index = minSlot;
        if (reversed) {
            index = maxSlot - 1;
        }
        if (stack.method_7946()) {
            while (!stack.method_7960() && !(!reversed ? index >= maxSlot : index < minSlot)) {
                slot = (class_1735)this.field_7761.get(index);
                slotStack = slot.method_7677();
                if (!slotStack.method_7960() && class_1799.method_31577((class_1799)stack, (class_1799)slotStack)) {
                    int maxSize;
                    int sumCount = slotStack.method_7947() + stack.method_7947();
                    if (sumCount <= (maxSize = Math.min(slot.method_7675(), stack.method_7914()))) {
                        stack.method_7939(0);
                        slotStack.method_7939(sumCount);
                        slot.method_7673(slotStack);
                        changed = true;
                    } else if (slotStack.method_7947() < maxSize) {
                        stack.method_7934(maxSize - slotStack.method_7947());
                        slotStack.method_7939(maxSize);
                        slot.method_7673(slotStack);
                        changed = true;
                    }
                }
                if (reversed) {
                    --index;
                    continue;
                }
                ++index;
            }
        }
        if (!stack.method_7960()) {
            index = reversed ? maxSlot - 1 : minSlot;
            while (!(!reversed ? index >= maxSlot : index < minSlot)) {
                slot = (class_1735)this.field_7761.get(index);
                slotStack = slot.method_7677();
                if (slotStack.method_7960() && slot.method_7680(stack)) {
                    if (stack.method_7947() > slot.method_7675()) {
                        slot.method_7673(stack.method_7971(slot.method_7675()));
                    } else {
                        slot.method_7673(stack.method_7971(stack.method_7947()));
                    }
                    changed = true;
                    break;
                }
                if (reversed) {
                    --index;
                    continue;
                }
                ++index;
            }
        }
        return changed;
    }
}

