/*
 * Decompiled with CFR 0.152.
 */
package cc.abbie.emi_ores.compat.emi.recipe;

import cc.abbie.emi_ores.compat.emi.EmiOresRecipeCategories;
import cc.abbie.emi_ores.compat.emi.recipe.AbstractPlacedFeatureEmiRecipe;
import cc.abbie.emi_ores.compat.emi.stack.BiomeEmiStack;
import cc.abbie.emi_ores.mixin.accessor.BlockMatchTestAccessor;
import cc.abbie.emi_ores.mixin.accessor.BlockStateMatchTestAccessor;
import cc.abbie.emi_ores.mixin.accessor.CountPlacementAccessor;
import cc.abbie.emi_ores.mixin.accessor.HeightRangePlacementAccessor;
import cc.abbie.emi_ores.mixin.accessor.RandomBlockMatchTestAccessor;
import cc.abbie.emi_ores.mixin.accessor.RandomBlockStateMatchTestAccessor;
import cc.abbie.emi_ores.mixin.accessor.RarityFilterAccessor;
import cc.abbie.emi_ores.mixin.accessor.TagMatchTestAccessor;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3124;
import net.minecraft.class_3798;
import net.minecraft.class_3819;
import net.minecraft.class_3820;
import net.minecraft.class_3823;
import net.minecraft.class_3824;
import net.minecraft.class_3825;
import net.minecraft.class_5875;
import net.minecraft.class_6017;
import net.minecraft.class_6122;
import net.minecraft.class_6792;
import net.minecraft.class_6793;
import net.minecraft.class_6795;
import net.minecraft.class_6796;
import net.minecraft.class_6797;
import net.minecraft.class_6799;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class OreGenEmiRecipe
extends AbstractPlacedFeatureEmiRecipe {
    private final class_2960 id;
    private final List<EmiIngredient> inputs;
    private final List<EmiStack> outputs;
    private final class_6122 heightProvider;
    private final EmiIngredient biomes;
    private final float discardChanceOnAirExposure;
    private final int countMin;
    private final int countMax;
    private final int rarityChance;

    public OreGenEmiRecipe(class_6796 feature, class_2960 id) {
        this.id = id;
        ArrayList inputs = new ArrayList();
        ArrayList outputs = new ArrayList();
        class_3124 oreConfig = (class_3124)((class_2975)feature.comp_334().comp_349()).comp_333();
        this.discardChanceOnAirExposure = oreConfig.field_29064;
        oreConfig.field_29063.forEach(targetBlockState -> {
            class_3825 target = targetBlockState.field_29068;
            if (target instanceof class_3798) {
                class_3798 tagMatchTest = (class_3798)target;
                class_6862<class_2248> tag = ((TagMatchTestAccessor)tagMatchTest).getTag();
                List l = class_7923.field_41175.method_40260(tag).method_40239().map(class_6880::comp_349).map(EmiStack::of).collect(Collectors.toList());
                inputs.add(EmiIngredient.of(l));
            } else if (target instanceof class_3819) {
                class_3819 blockMatchTest = (class_3819)target;
                class_2248 block = ((BlockMatchTestAccessor)blockMatchTest).getBlock();
                inputs.add(EmiStack.of((class_1935)block));
            } else if (target instanceof class_3820) {
                class_3820 blockStateMatchTest = (class_3820)target;
                class_2680 state = ((BlockStateMatchTestAccessor)blockStateMatchTest).getBlockState();
                inputs.add(EmiStack.of((class_1935)state.method_26204()));
            } else if (target instanceof class_3824) {
                class_3824 randomBlockMatchTest = (class_3824)target;
                RandomBlockMatchTestAccessor accessor = (RandomBlockMatchTestAccessor)randomBlockMatchTest;
                class_2248 block = accessor.getBlock();
                float probability = accessor.getProbability();
                inputs.add(EmiStack.of((class_1935)block).setChance(probability));
            } else if (target instanceof class_3823) {
                class_3823 randomBlockStateMatchTest = (class_3823)target;
                RandomBlockStateMatchTestAccessor accessor = (RandomBlockStateMatchTestAccessor)randomBlockStateMatchTest;
                class_2248 block = accessor.getBlockState().method_26204();
                float probability = accessor.getProbability();
                inputs.add(EmiStack.of((class_1935)block).setChance(probability));
            } else {
                inputs.add(EmiStack.EMPTY);
            }
            outputs.add(EmiStack.of((class_1935)targetBlockState.field_29069.method_26204()).setAmount((long)oreConfig.field_13723));
        });
        this.inputs = Collections.unmodifiableList(inputs);
        this.outputs = Collections.unmodifiableList(outputs);
        class_6122 heightProvider = null;
        List<Object> biomes = List.of();
        int countMin = -1;
        int countMax = -1;
        int rarityChance = -1;
        for (class_6797 modifier : feature.comp_335()) {
            if (modifier instanceof class_6795) {
                class_6795 heightRange = (class_6795)modifier;
                heightProvider = ((HeightRangePlacementAccessor)heightRange).getHeight();
                continue;
            }
            if (modifier instanceof class_6792) {
                biomes = OreGenEmiRecipe.getBiomes(id, feature);
                continue;
            }
            if (modifier instanceof class_6793) {
                class_6793 countPlacement = (class_6793)modifier;
                class_6017 countIntProvider = ((CountPlacementAccessor)countPlacement).getCount();
                countMin = countIntProvider.method_35009();
                countMax = countIntProvider.method_35011();
                continue;
            }
            if (!(modifier instanceof class_6799)) continue;
            class_6799 rarityFilter = (class_6799)modifier;
            rarityChance = ((RarityFilterAccessor)rarityFilter).getChance();
        }
        if (((class_2975)feature.comp_334().comp_349()).comp_332() instanceof class_5875) {
            countMax = 1;
            countMin = 1;
        }
        this.countMin = countMin;
        this.countMax = countMax;
        this.rarityChance = rarityChance;
        this.heightProvider = heightProvider;
        this.biomes = EmiIngredient.of(biomes.stream().map(BiomeEmiStack::new).toList());
    }

    public EmiRecipeCategory getCategory() {
        return EmiOresRecipeCategories.OREGEN;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return Stream.concat(this.inputs.stream(), Stream.of(this.biomes)).toList();
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return 160;
    }

    public int getDisplayHeight() {
        return Math.max(54, 18 + 18 * this.inputs.size());
    }

    public boolean supportsRecipeTree() {
        return false;
    }

    public void addWidgets(WidgetHolder widgets) {
        class_2561 veinFreq;
        for (int i = 0; i < this.inputs.size(); ++i) {
            widgets.addSlot(this.inputs.get(i), 0, 18 + i * 18);
            widgets.addTexture(EmiTexture.EMPTY_ARROW, 20, 18 + i * 18);
            widgets.addSlot((EmiIngredient)this.outputs.get(i), 46, 18 + i * 18).recipeContext((EmiRecipe)this);
        }
        OreGenEmiRecipe.addDistributionGraph(widgets, 64, 0, this.heightProvider);
        if (!this.biomes.isEmpty()) {
            widgets.addSlot(this.biomes, 96, 18);
        }
        if (this.discardChanceOnAirExposure > 0.0f) {
            widgets.addSlot((EmiIngredient)EmiStack.of((class_1935)class_1802.field_8077).setChance(this.discardChanceOnAirExposure), 142, 18).appendTooltip((class_2561)class_2561.method_43471((String)"emi_ores.discard_on_air_chance"));
        }
        if ((veinFreq = OreGenEmiRecipe.getVeinFreqComponent(this.countMin, this.countMax, this.rarityChance)) != null) {
            widgets.addText(veinFreq, 160, 45, 0, false).horizontalAlign(TextWidget.Alignment.END).verticalAlign(TextWidget.Alignment.CENTER);
        }
    }
}

