/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.network;

import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.network.v3.serialization.MessageSerializers;
import fuzs.puzzleslib.impl.core.FabricProxy;
import fuzs.puzzleslib.impl.network.NetworkHandlerRegistryImpl;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2547;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2792;
import net.minecraft.class_2960;

public class NetworkHandlerFabricV3
extends NetworkHandlerRegistryImpl {
    private final Map<Class<?>, class_2960> messageChannelNames = Maps.newIdentityHashMap();
    private final AtomicInteger discriminator = new AtomicInteger();
    private boolean building = true;

    public NetworkHandlerFabricV3(class_2960 channelIdentifier) {
        super(channelIdentifier);
    }

    @Override
    public <T extends Record> void registerClientbound$Internal(Class<?> clazz) {
        this.register(clazz, ((FabricProxy)Proxy.INSTANCE)::registerClientReceiver);
    }

    @Override
    public <T extends Record> void registerServerbound$Internal(Class<?> clazz) {
        this.register(clazz, ((FabricProxy)Proxy.INSTANCE)::registerServerReceiver);
    }

    private <T> void register(Class<T> clazz, BiConsumer<class_2960, Function<class_2540, T>> register) {
        if (!clazz.isRecord()) {
            throw new IllegalArgumentException("Message of type %s is not a record".formatted(clazz));
        }
        if (this.building) {
            throw new IllegalStateException("channel is null");
        }
        class_2960 channelName = this.nextIdentifier();
        if (this.messageChannelNames.put(clazz, channelName) != null) {
            throw new IllegalStateException("Duplicate message of type %s".formatted(clazz));
        }
        register.accept(channelName, MessageSerializers.findByType(clazz)::read);
    }

    private class_2960 nextIdentifier() {
        return new class_2960(this.channelIdentifier.method_12836(), this.channelIdentifier.method_12832() + "/" + this.discriminator.getAndIncrement());
    }

    @Override
    public <T extends Record> class_2596<class_2602> toClientboundPacket(T message) {
        if (this.building) {
            throw new IllegalStateException("channel is null");
        }
        Objects.requireNonNull(message, "message is null");
        return this.toPacket(ServerPlayNetworking::createS2CPacket, message);
    }

    @Override
    public <T extends Record> class_2596<class_2792> toServerboundPacket(T message) {
        if (this.building) {
            throw new IllegalStateException("channel is null");
        }
        Objects.requireNonNull(message, "message is null");
        return this.toPacket(ClientPlayNetworking::createC2SPacket, message);
    }

    private <T extends Record, S extends class_2547> class_2596<S> toPacket(BiFunction<class_2960, class_2540, class_2596<S>> packetFactory, T message) {
        Class<?> clazz = message.getClass();
        if (!clazz.isRecord()) {
            throw new IllegalArgumentException("Message of type %s is not a record".formatted(clazz));
        }
        class_2540 byteBuf = PacketByteBufs.create();
        MessageSerializers.findByType(clazz).write(byteBuf, message);
        class_2960 channelName = this.messageChannelNames.get(clazz);
        Objects.requireNonNull(channelName, "Unknown message of type %s".formatted(clazz));
        return packetFactory.apply(channelName, byteBuf);
    }

    @Override
    public void build() {
        this.building = false;
        super.build();
    }
}

