/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion;

import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.FusionModelTypeRegistry;
import com.supermartijn642.fusion.api.predicate.FusionPredicateRegistry;
import com.supermartijn642.fusion.api.texture.DefaultTextureTypes;
import com.supermartijn642.fusion.api.texture.FusionTextureTypeRegistry;
import com.supermartijn642.fusion.api.texture.data.ConnectingTextureData;
import com.supermartijn642.fusion.model.ModelTypeRegistryImpl;
import com.supermartijn642.fusion.predicate.AndConnectionPredicate;
import com.supermartijn642.fusion.predicate.IsFaceVisibleConnectionPredicate;
import com.supermartijn642.fusion.predicate.IsSameBlockConnectionPredicate;
import com.supermartijn642.fusion.predicate.IsSameStateConnectionPredicate;
import com.supermartijn642.fusion.predicate.MatchBlockConnectionPredicate;
import com.supermartijn642.fusion.predicate.MatchStateConnectionPredicate;
import com.supermartijn642.fusion.predicate.NotConnectionPredicate;
import com.supermartijn642.fusion.predicate.OrConnectionPredicate;
import com.supermartijn642.fusion.predicate.PredicateRegistryImpl;
import com.supermartijn642.fusion.texture.TextureTypeRegistryImpl;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.MaterialFinder;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionClient
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"fusion");
    private static final RenderMaterial[] RENDER_MATERIALS = new RenderMaterial[ConnectingTextureData.RenderType.values().length];

    public void onInitializeClient() {
        FusionTextureTypeRegistry.registerTextureType(new class_2960("fusion", "vanilla"), DefaultTextureTypes.VANILLA);
        FusionTextureTypeRegistry.registerTextureType(new class_2960("fusion", "connecting"), DefaultTextureTypes.CONNECTING);
        FusionTextureTypeRegistry.registerTextureType(new class_2960("fusion", "scrolling"), DefaultTextureTypes.SCROLLING);
        FusionModelTypeRegistry.registerModelType(new class_2960("fusion", "unknown"), DefaultModelTypes.UNKNOWN);
        FusionModelTypeRegistry.registerModelType(new class_2960("fusion", "vanilla"), DefaultModelTypes.VANILLA);
        FusionModelTypeRegistry.registerModelType(new class_2960("fusion", "connecting"), DefaultModelTypes.CONNECTING);
        FusionPredicateRegistry.registerConnectionPredicate(new class_2960("fusion", "and"), AndConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new class_2960("fusion", "or"), OrConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new class_2960("fusion", "not"), NotConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new class_2960("fusion", "is_face_visible"), IsFaceVisibleConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new class_2960("fusion", "is_same_block"), IsSameBlockConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new class_2960("fusion", "is_same_state"), IsSameStateConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new class_2960("fusion", "match_block"), MatchBlockConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new class_2960("fusion", "match_state"), MatchStateConnectionPredicate.SERIALIZER);
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> TextureTypeRegistryImpl.finalizeRegistration());
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> ModelTypeRegistryImpl.finalizeRegistration());
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> PredicateRegistryImpl.finalizeRegistration());
    }

    public static RenderMaterial getRenderTypeMaterial(ConnectingTextureData.RenderType renderType) {
        RenderMaterial material = RENDER_MATERIALS[renderType.ordinal()];
        if (material == null) {
            MaterialFinder materialFinder = RendererAccess.INSTANCE.getRenderer().materialFinder();
            for (ConnectingTextureData.RenderType value : ConnectingTextureData.RenderType.values()) {
                BlendMode mode = value == ConnectingTextureData.RenderType.OPAQUE ? BlendMode.SOLID : (value == ConnectingTextureData.RenderType.CUTOUT ? BlendMode.CUTOUT : (value == ConnectingTextureData.RenderType.TRANSLUCENT ? BlendMode.TRANSLUCENT : null));
                FusionClient.RENDER_MATERIALS[value.ordinal()] = materialFinder.blendMode(mode).find();
            }
            material = RENDER_MATERIALS[renderType.ordinal()];
        }
        return material;
    }
}

