/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.api.provider;

import com.google.gson.JsonElement;
import com.supermartijn642.fusion.api.model.FusionModelTypeRegistry;
import com.supermartijn642.fusion.api.model.ModelInstance;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7403;

public abstract class FusionModelProvider
implements class_2405 {
    private final Map<class_2960, ModelInstance<?>> models = new HashMap();
    private final String modName;
    private final FabricDataOutput output;

    public FusionModelProvider(String modid, FabricDataOutput output) {
        this.modName = FabricLoader.getInstance().getModContainer(modid).map(ModContainer::getMetadata).map(ModMetadata::getName).orElse(modid);
        this.output = output;
    }

    public final CompletableFuture<?> method_10319(class_7403 cache) {
        this.generate();
        ArrayList<CompletableFuture> tasks = new ArrayList<CompletableFuture>();
        Path output = this.output.method_45971();
        for (Map.Entry<class_2960, ModelInstance<?>> entry : this.models.entrySet()) {
            class_2960 location = entry.getKey();
            ModelInstance<?> model = entry.getValue();
            String extension = location.method_12832().lastIndexOf(".") > location.method_12832().lastIndexOf("/") ? "" : ".json";
            Path path = Path.of("assets", location.method_12836(), "models", location.method_12832() + extension);
            tasks.add(class_2405.method_10320((class_7403)cache, (JsonElement)FusionModelTypeRegistry.serializeModelData(model), (Path)output.resolve(path)));
        }
        return CompletableFuture.allOf((CompletableFuture[])tasks.toArray(CompletableFuture[]::new));
    }

    protected abstract void generate();

    public final void addModel(class_2960 location, ModelInstance<?> model) {
        ModelInstance<?> previousValue = this.models.put(location, model);
        if (previousValue != null) {
            throw new RuntimeException("Duplicate model for '" + location + "'!");
        }
    }

    public String method_10321() {
        return "Fusion Model Provider: " + this.modName;
    }
}

