/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.api.texture.data;

import com.supermartijn642.fusion.texture.types.scrolling.ScrollingTextureDataImpl;

public interface ScrollingTextureData {
    public static Builder builder() {
        return new Builder();
    }

    public Position getStartPosition();

    public Position getEndPosition();

    public int getFrameTime();

    public int getFrameWidth();

    public int getFrameHeight();

    public LoopType getLoopType();

    public int getLoopPause();

    public static final class Builder {
        private Position startPosition = Position.TOP_LEFT;
        private Position endPosition = Position.BOTTOM_LEFT;
        private int frameTime = 10;
        private int frameWidth = 16;
        private int frameHeight = 16;
        private LoopType loopType = LoopType.RESET;
        private int loopPause = 0;

        private Builder() {
        }

        public Builder startPosition(Position position) {
            this.startPosition = position;
            return this;
        }

        public Builder endPosition(Position position) {
            this.endPosition = position;
            return this;
        }

        public Builder frameTime(int ticks) {
            this.frameTime = ticks;
            return this;
        }

        public Builder frameWidth(int width) {
            this.frameWidth = width;
            return this;
        }

        public Builder frameHeight(int height) {
            this.frameHeight = height;
            return this;
        }

        public Builder frameSize(int width, int height) {
            this.frameWidth = width;
            this.frameHeight = height;
            return this;
        }

        public Builder loopType(LoopType type) {
            this.loopType = type;
            return this;
        }

        public Builder loopPause(int ticks) {
            this.loopPause = ticks;
            return this;
        }

        public ScrollingTextureData build() {
            return new ScrollingTextureDataImpl(this.startPosition, this.endPosition, this.frameTime, this.frameWidth, this.frameHeight, this.loopType, this.loopPause);
        }
    }

    public static enum LoopType {
        RESET,
        REVERSE;

    }

    public static enum Position {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

