/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.extensions.TextureAtlasSpriteExtension;
import com.supermartijn642.fusion.texture.FusionTextureMetadataSection;
import com.supermartijn642.fusion.texture.SpriteCreationContextImpl;
import com.supermartijn642.fusion.texture.SpritePreparationContextImpl;
import com.supermartijn642.fusion.texture.TextureTypeRegistryImpl;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1079;
import net.minecraft.class_2960;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7764;
import net.minecraft.class_7766;
import net.minecraft.class_7771;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_7766.class}, priority=900)
public class SpriteLoaderMixin {
    @Unique
    private static final Map<class_2960, Pair<TextureType<Object>, Object>> fusionTextureMetadata = new ConcurrentHashMap<class_2960, Pair<TextureType<Object>, Object>>();

    @Inject(method={"loadSprite"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/resources/metadata/animation/AnimationMetadataSection;calculateFrameSize(II)Lnet/minecraft/client/resources/metadata/animation/FrameSize;", shift=At.Shift.BEFORE)}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void gatherMetadata(class_2960 identifier, class_3298 resource, CallbackInfoReturnable<class_7764> ci, class_1079 animationMetadataSection, class_1011 image) {
        Pair metadata = null;
        try {
            metadata = resource.method_14481().method_43041((class_3270)FusionTextureMetadataSection.INSTANCE).orElse(null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (metadata != null) {
            Pair<Integer, Integer> newSize;
            fusionTextureMetadata.put(identifier, metadata);
            class_7771 originalSize = animationMetadataSection.method_24143(image.method_4307(), image.method_4323());
            try {
                newSize = ((TextureType)metadata.left()).getFrameSize(new SpritePreparationContextImpl(originalSize.comp_1049(), originalSize.comp_1050(), image.method_4307(), image.method_4323(), identifier), metadata.right());
            }
            catch (Exception e) {
                throw new RuntimeException("Encountered an exception whilst getting frame size from texture type '" + TextureTypeRegistryImpl.getIdentifier((TextureType)metadata.left()) + "' for texture '" + identifier + "'!", e);
            }
            if (newSize == null) {
                throw new RuntimeException("Received null frame size from texture type '" + TextureTypeRegistryImpl.getIdentifier((TextureType)metadata.left()) + "' for texture '" + identifier + "'!");
            }
            class_7771 newFrameSize = new class_7771(newSize.left().intValue(), newSize.right().intValue());
            ci.setReturnValue((Object)new class_7764(identifier, newFrameSize, image, animationMetadataSection));
        }
    }

    @Inject(method={"loadAndStitch"}, at={@At(value="RETURN")})
    private void initializeTextures(class_3300 resourceManager, class_2960 atlas, int i, Executor executor, CallbackInfoReturnable<CompletableFuture<class_7766.class_7767>> ci) {
        ((CompletableFuture)ci.getReturnValue()).thenApply(preparations -> {
            Map textures = preparations.comp_1044();
            for (Map.Entry<class_2960, Pair<TextureType<Object>, Object>> entry : fusionTextureMetadata.entrySet()) {
                class_1058 newTexture;
                class_2960 identifier = entry.getKey();
                class_1058 texture = (class_1058)textures.get(identifier);
                Pair<TextureType<Object>, Object> textureData = entry.getValue();
                if (texture == null) continue;
                try (SpriteCreationContextImpl context = new SpriteCreationContextImpl((class_7766.class_7767)preparations, atlas, texture);){
                    newTexture = textureData.left().createSprite(context, textureData.right());
                }
                catch (Exception e) {
                    throw new RuntimeException("Encountered an exception whilst initialising texture '" + identifier + "' for texture type '" + TextureTypeRegistryImpl.getIdentifier(textureData.left()) + "'!", e);
                }
                if (newTexture == null) {
                    throw new RuntimeException("Received null texture from texture type '" + TextureTypeRegistryImpl.getIdentifier(textureData.left()) + "' for texture '" + identifier + "'!");
                }
                ((TextureAtlasSpriteExtension)newTexture).setFusionTextureType(textureData.left());
                textures.put(identifier, newTexture);
            }
            return preparations;
        });
    }
}

