/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.gui;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1661;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import shetiphian.core.client.gui.ButtonIcon;
import shetiphian.core.client.gui.GuiHelper;
import shetiphian.core.client.gui.WidgetInfoBox;
import shetiphian.core.common.inventory.ISideAssignableWrapper;
import shetiphian.core.common.inventory.SidedScreenHandler;
import shetiphian.core.internal.ShetiPhianCore;
import shetiphian.core.internal.network.NetworkHandler;
import shetiphian.core.internal.network.PacketSidedWrapper;
import shetiphian.core.mixins.SPC_Screen_Accessor;

@Environment(value=EnvType.CLIENT)
public abstract class GuiSidedContainer<T extends SidedScreenHandler<?>>
extends class_465<T> {
    private final String TEXT_SIDE_DISABLED = class_1074.method_4662((String)"gui.side_disabled", (Object[])new Object[0]);
    private static final class_2960 GUI_TEXTURE = new class_2960("shetiphiancore", "textures/gui/info_config.png");
    protected Mode mode = Mode.NORMAL;
    protected WidgetInfoBox infoBox;
    protected byte[] indexSide = new byte[]{-1, -1, -1, -1, -1, -1};
    protected String[] faceNames;
    protected String[] invNames;
    protected class_4185 hoveredButton;
    protected int hoverTime;
    private class_4185 buttonSave;
    public final List<class_4068> renderables;

    public GuiSidedContainer(T container, boolean rotatable, class_1661 inventory, class_2561 title) {
        super(container, inventory, title);
        String[] stringArray;
        if (rotatable) {
            String[] stringArray2 = new String[6];
            stringArray2[0] = "bottom";
            stringArray2[1] = "top";
            stringArray2[2] = "back";
            stringArray2[3] = "front";
            stringArray2[4] = "left";
            stringArray = stringArray2;
            stringArray2[5] = "right";
        } else {
            String[] stringArray3 = new String[6];
            stringArray3[0] = "down";
            stringArray3[1] = "up";
            stringArray3[2] = "north";
            stringArray3[3] = "south";
            stringArray3[4] = "west";
            stringArray = stringArray3;
            stringArray3[5] = "east";
        }
        this.faceNames = stringArray;
        for (int index = 0; index < 6; ++index) {
            this.faceNames[index] = class_1074.method_4662((String)("info." + this.faceNames[index]), (Object[])new Object[0]);
        }
        if (this instanceof SPC_Screen_Accessor) {
            this.renderables = ((SPC_Screen_Accessor)((Object)this)).getDrawables();
        } else {
            this.renderables = Lists.newArrayList();
            ShetiPhianCore.LOGGER.error("Mixin Accessor failed to load. GUI will not render or function correctly");
        }
    }

    protected abstract List<String> getInfoBoxText();

    public void method_25426() {
        super.method_25426();
        this.method_37067();
        switch (this.mode) {
            case NORMAL: {
                this.method_37063((class_364)new ButtonMode(this.field_2776 - 18, this.field_2800 + 16, Mode.INFO));
                this.method_37063((class_364)new ButtonMode(this.field_2776 - 18, this.field_2800 + 40, Mode.CONFIG));
                this.initSidedContainer();
                break;
            }
            case INFO: {
                this.method_37063((class_364)new ButtonMode(this.field_2776 - 18, this.field_2800 + 16, Mode.NORMAL));
                this.method_37063((class_364)new ButtonMode(this.field_2776 - 18, this.field_2800 + 40, Mode.CONFIG));
                this.infoBox = new WidgetInfoBox(this.field_22787, this.field_2776 + 13, this.field_2800 + this.field_2779 - 84, 158, 72).addHeader(this.getInfoBoxText());
                break;
            }
            case CONFIG: {
                this.method_37063((class_364)new ButtonMode(this.field_2776 - 18, this.field_2800 + 16, Mode.NORMAL));
                this.method_37063((class_364)new ButtonMode(this.field_2776 - 18, this.field_2800 + 40, Mode.INFO));
                this.buttonSave = new ButtonSave(this.field_2776 + 158, this.field_2800 + this.field_2779 - 88);
                this.method_37063((class_364)this.buttonSave);
                if (((SidedScreenHandler)this.field_2797).getTile() != null) {
                    this.indexSide = (byte[])((ISideAssignableWrapper)((SidedScreenHandler)this.field_2797).getTile()).getIndexes().clone();
                }
                int x = this.field_2776 + 91;
                int y = this.field_2800 + this.field_2779 - 48;
                this.method_37063((class_364)new ButtonFace(x + 1, y - 11, 22, 22, class_2350.field_11034));
                this.method_37063((class_364)new ButtonFace(x - 47, y - 11, 22, 22, class_2350.field_11039));
                this.method_37063((class_364)new ButtonFace(x - 23, y - 11, 22, 22, class_2350.field_11035));
                this.method_37063((class_364)new ButtonFace(x + 25, y - 11, 22, 22, class_2350.field_11043));
                this.method_37063((class_364)new ButtonFace(x - 23, y - 35, 22, 22, class_2350.field_11036));
                this.method_37063((class_364)new ButtonFace(x - 23, y + 13, 22, 22, class_2350.field_11033));
            }
        }
    }

    private String getFaceText(int index) {
        return this.faceNames[index].substring(0, 1).toUpperCase();
    }

    protected abstract void initSidedContainer();

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(graphics);
        if (this.mode == Mode.NORMAL) {
            super.method_25394(graphics, mouseX, mouseY, partialTicks);
            this.method_2380(graphics, mouseX, mouseY);
            return;
        }
        this.method_2389(graphics, partialTicks, mouseX, mouseY);
        RenderSystem.disableDepthTest();
        class_4185 lastButton = this.hoveredButton;
        this.hoveredButton = null;
        for (class_4068 widget : this.renderables) {
            widget.method_25394(graphics, mouseX, mouseY, partialTicks);
            if (!(widget instanceof class_4185) || !((class_4185)widget).method_25405((double)mouseX, (double)mouseY)) continue;
            if (lastButton != widget) {
                this.hoverTime = 0;
            }
            this.hoveredButton = (class_4185)widget;
        }
        this.hoverTime = this.hoveredButton == null ? 0 : class_3532.method_15340((int)(this.hoverTime + 1), (int)0, (int)Integer.MAX_VALUE);
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)this.field_2776, (float)this.field_2800, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.method_2388(graphics, mouseX, mouseY);
        graphics.method_51448().method_22909();
        RenderSystem.enableDepthTest();
    }

    protected void method_2389(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        if (this.mode == Mode.NORMAL) {
            this.drawNormal(graphics, partialTicks, mouseX, mouseY);
            return;
        }
        GuiHelper.drawTexture(graphics, this.field_2776, this.field_2800 + this.field_2779 - 98, 0, 158, 182, 98, GUI_TEXTURE);
        if (this.mode == Mode.INFO) {
            GuiHelper.drawTexture(graphics, this.field_2776 + 12, this.field_2800 + this.field_2779 - 85, 0, 84, 160, 74, GUI_TEXTURE);
        } else {
            GuiHelper.drawTexture(graphics, this.buttonSave.method_46426(), this.buttonSave.method_46427(), 208, 208, this.buttonSave.method_25368(), this.buttonSave.method_25364(), GUI_TEXTURE);
        }
        if (this.mode == Mode.INFO) {
            this.drawInfo(graphics, partialTicks, mouseX, mouseY);
            GuiHelper.drawTexture(graphics, this.field_2776 + 12, this.field_2800 + this.field_2779 - 92, 12, 164, 160, 8, GUI_TEXTURE);
            GuiHelper.drawTexture(graphics, this.field_2776 + 12, this.field_2800 + this.field_2779 - 85, 0, 84, 160, 1, GUI_TEXTURE);
            GuiHelper.drawTexture(graphics, this.field_2776 + 12, this.field_2800 + this.field_2779 - 12, 0, 157, 160, 1, GUI_TEXTURE);
            GuiHelper.drawTexture(graphics, this.field_2776 + 12, this.field_2800 + this.field_2779 - 11, 12, 245, 160, 8, GUI_TEXTURE);
        } else {
            this.drawConfig(graphics, partialTicks, mouseX, mouseY);
        }
    }

    protected abstract void drawNormal(class_332 var1, float var2, int var3, int var4);

    protected abstract void drawInfo(class_332 var1, float var2, int var3, int var4);

    protected abstract void drawConfig(class_332 var1, float var2, int var3, int var4);

    protected void renderFaceButton(class_332 graphics, class_4185 button, class_2350 face, int mouseX, int mouseY, float partialTicks) {
    }

    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
        if (this.mode == Mode.CONFIG && this.hoverTime >= 40 && this.hoveredButton instanceof ButtonFace) {
            int id = ((ButtonFace)this.hoveredButton).faceIndex;
            byte index = this.indexSide[id];
            ArrayList<class_5250> list = new ArrayList<class_5250>();
            list.add(class_2561.method_43470((String)("\u00a7l" + this.faceNames[id])));
            if (this.invNames != null) {
                list.add(class_2561.method_43470((String)("\u00a7o" + (index > -1 && index < this.invNames.length ? this.invNames[index] : this.TEXT_SIDE_DISABLED))));
            }
            graphics.method_51434(this.field_22793, list, mouseX - this.field_2776, mouseY - this.field_2800);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.mode == Mode.INFO && this.infoBox.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (this.mode == Mode.INFO && this.infoBox.method_16803(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char character, int value) {
        if (this.mode == Mode.INFO && this.infoBox.method_25400(character, value)) {
            return true;
        }
        return super.method_25400(character, value);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.mode == Mode.INFO && this.infoBox.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double accelX, double accelY) {
        if (this.mode == Mode.INFO && this.infoBox.method_25403(mouseX, mouseY, button, accelX, accelY)) {
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, accelX, accelY);
    }

    public boolean method_25401(double mouseX, double mouseY, double scroll) {
        if (this.mode == Mode.INFO && this.infoBox.method_25401(mouseX, mouseY, scroll)) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, scroll);
    }

    protected static enum Mode {
        NORMAL(192, 240, 192, 224, 192, 240),
        INFO(224, 240, 224, 224, 224, 240),
        CONFIG(240, 240, 240, 224, 240, 240);

        private final int[] normal;
        private final int[] hover;
        private final int[] pressed;

        private Mode(int nU, int nV, int hU, int hV, int pU, int pV) {
            this.normal = new int[]{nU, nV};
            this.hover = new int[]{hU, hV};
            this.pressed = new int[]{pU, pV};
        }
    }

    private class ButtonMode
    extends ButtonIcon {
        private final GuiSidedContainer<T> parent;
        private final Mode mode;

        ButtonMode(int posX, int posY, Mode mode) {
            super(posX, posY, 16, 16, GUI_TEXTURE, mode.normal, mode.hover, mode.pressed);
            this.parent = GuiSidedContainer.this;
            this.mode = mode;
        }

        @Override
        public void method_25306() {
            this.parent.mode = this.mode;
            this.parent.method_25426();
        }
    }

    private class ButtonSave
    extends ButtonIcon {
        private final GuiSidedContainer<T> parent;

        ButtonSave(int posX, int posY) {
            super(posX, posY, 16, 16, GUI_TEXTURE, 208, 240, 208, 224, 208, 240);
            this.parent = GuiSidedContainer.this;
            this.field_22764 = false;
        }

        @Override
        public void method_25306() {
            NetworkHandler.sendToServer(new PacketSidedWrapper(((SidedScreenHandler)this.parent.field_2797).getTile().method_11016(), this.parent.indexSide));
            this.field_22764 = false;
        }
    }

    private class ButtonFace
    extends ButtonIcon {
        private final GuiSidedContainer<T> parent;
        private final class_2350 face;
        private final int faceIndex;

        ButtonFace(int posX, int posY, int sizeX, int sizeY, class_2350 face) {
            super(posX, posY, sizeX, sizeY);
            this.parent = GuiSidedContainer.this;
            this.face = face;
            this.faceIndex = face.method_10146();
            this.setText(this.parent.getFaceText(this.faceIndex));
        }

        @Override
        public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
            if (!this.field_22764) {
                return;
            }
            this.parent.renderFaceButton(graphics, this, this.face, mouseX, mouseY, partialTicks);
            if (!Strings.isNullOrEmpty((String)this.displayString)) {
                graphics.method_25300(this.parent.field_22793, this.displayString, this.method_46426() + this.field_22758 / 2, this.method_46427() + (this.field_22759 - 8) / 2, -1);
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.method_25361(mouseX, mouseY)) {
                this.method_25354(class_310.method_1551().method_1483());
                ISideAssignableWrapper wrapper = (ISideAssignableWrapper)((SidedScreenHandler)this.parent.field_2797).getTile();
                byte max = (byte)(wrapper.getGroupCount() - 1);
                switch (button) {
                    case 0: {
                        int n = this.faceIndex;
                        this.parent.indexSide[n] = (byte)(this.parent.indexSide[n] + 1);
                        if (this.parent.indexSide[this.faceIndex] <= max) break;
                        this.parent.indexSide[this.faceIndex] = -1;
                        break;
                    }
                    case 1: {
                        int n = this.faceIndex;
                        this.parent.indexSide[n] = (byte)(this.parent.indexSide[n] - 1);
                        if (this.parent.indexSide[this.faceIndex] >= -1) break;
                        this.parent.indexSide[this.faceIndex] = max;
                        break;
                    }
                    case 2: {
                        this.parent.indexSide[this.faceIndex] = -1;
                    }
                }
                if (this.parent.buttonSave != null) {
                    this.parent.buttonSave.field_22764 = false;
                    byte[] original = wrapper.getIndexes();
                    for (int index = 0; index < 6; ++index) {
                        if (original[index] == this.parent.indexSide[index]) continue;
                        this.parent.buttonSave.field_22764 = true;
                        break;
                    }
                }
                return true;
            }
            return false;
        }
    }
}

