/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_2754;
import net.minecraft.class_3542;

public class BlockLightingHelper {
    public static final class_2754<PackedData> LIGHTING = class_2754.method_11850((String)"lighting", PackedData.class);
    private static final Map<class_2680, Boolean> TRANSMISSIVE = new HashMap<class_2680, Boolean>();
    private static final Map<class_2680, Integer> LUMINOSITY = new HashMap<class_2680, Integer>();

    private static void addBlockData(class_2680 state) {
        TRANSMISSIVE.put(state, state.method_26167((class_1922)class_2682.field_12294, class_2338.field_10980));
        LUMINOSITY.put(state, state.method_26213());
    }

    public static boolean isTransmissive(class_1799 stack) {
        return !stack.method_7960() && BlockLightingHelper.isTransmissive(stack.method_7909());
    }

    public static boolean isTransmissive(class_1792 item) {
        return item instanceof class_1747 && BlockLightingHelper.isTransmissive(((class_1747)item).method_7711());
    }

    public static boolean isTransmissive(class_2248 block) {
        return BlockLightingHelper.isTransmissive(block.method_9564());
    }

    public static boolean isTransmissive(class_2680 state) {
        if (!TRANSMISSIVE.containsKey(state)) {
            BlockLightingHelper.addBlockData(state);
        }
        return TRANSMISSIVE.getOrDefault(state, false);
    }

    public static int getLuminosity(class_1799 stack) {
        return !stack.method_7960() ? BlockLightingHelper.getLuminosity(stack.method_7909()) : 0;
    }

    public static int getLuminosity(class_1792 item) {
        return item instanceof class_1747 ? BlockLightingHelper.getLuminosity(((class_1747)item).method_7711()) : 0;
    }

    public static int getLuminosity(class_2248 block) {
        return BlockLightingHelper.getLuminosity(block.method_9564());
    }

    public static int getLuminosity(class_2680 state) {
        if (!LUMINOSITY.containsKey(state)) {
            BlockLightingHelper.addBlockData(state);
        }
        return LUMINOSITY.getOrDefault(state, 0);
    }

    public static class_2680 setLighting(class_2680 state, int value, boolean onZeroPassLight) {
        if (state.method_28498(LIGHTING)) {
            return (class_2680)state.method_11657(LIGHTING, (Comparable)((Object)((PackedData)((Object)state.method_11654(LIGHTING))).setLight(value, onZeroPassLight)));
        }
        return state;
    }

    public static boolean doesLightPassThrough(class_2680 state) {
        return state.method_28498(LIGHTING) && ((PackedData)((Object)state.method_11654(LIGHTING))).passesSkylight();
    }

    public static int getLightValue(class_2680 state) {
        return state.method_28498(LIGHTING) ? ((PackedData)((Object)state.method_11654(LIGHTING))).getLightValue() : 0;
    }

    public static enum PackedData implements class_3542
    {
        UNKNOWEN("unknowen"),
        BLOCKING("blocking"),
        PASSING("passing"),
        LVL3("emitting_3"),
        LVL6("emitting_6"),
        LVL9("emitting_9"),
        LVL12("emitting_12"),
        LVL15("emitting_15");

        private final String name;

        private PackedData(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public boolean passesSkylight() {
            return this != UNKNOWEN && this != BLOCKING;
        }

        public int getLightValue() {
            return switch (this) {
                case LVL3 -> 3;
                case LVL6 -> 6;
                case LVL9 -> 9;
                case LVL12 -> 12;
                case LVL15 -> 15;
                default -> 0;
            };
        }

        public PackedData setLight(int value, boolean onZeroPassLight) {
            return switch (value / 3 * 3) {
                case 3 -> LVL3;
                case 6 -> LVL6;
                case 9 -> LVL9;
                case 12 -> LVL12;
                case 15 -> LVL15;
                default -> onZeroPassLight ? PASSING : BLOCKING;
            };
        }
    }
}

