/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.server.MinecraftServer;
import shetiphian.core.common.DistExecutor;
import shetiphian.core.internal.network.NetworkHandler;
import shetiphian.core.internal.network.PacketNameSync;
import shetiphian.core.internal.teams.TeamHelper;

public class NameHelper {
    private static final Cache<String, String> NAMECACHE = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).build();
    private static final Cache<String, String> TEMPCACHE = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
    private static final Map<UUID, String> PLAYERS = Maps.newHashMap();
    private static final Map<String, String> TEAMS = Maps.newHashMap();

    private static class_1657 getClientPlayer() {
        AtomicReference<Object> player = new AtomicReference<Object>(null);
        DistExecutor.runWhenOn(EnvType.CLIENT, () -> () -> player.set(class_310.method_1551().field_1724));
        return player.get();
    }

    public static String getDisplayNameFor(String id) {
        UUID uuid = null;
        try {
            uuid = UUID.fromString(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String name = uuid != null ? NameHelper.getLastKnownUsername(uuid) : NameHelper.getLastKnownTeamName(id);
        return !Strings.isNullOrEmpty((String)name) ? name : id;
    }

    public static String getLastKnownUsername(MinecraftServer server, UUID uuid) {
        AtomicReference<String> name = new AtomicReference<String>("");
        server.method_3793().method_14512(uuid).ifPresent(profile -> name.set(profile.getName()));
        NameHelper.setPlayerName(uuid, name.get());
        if (PLAYERS.containsKey(uuid)) {
            name.set(PLAYERS.get(uuid));
            NAMECACHE.put((Object)uuid.toString(), (Object)name.get());
        }
        return name.get();
    }

    public static String getLastKnownUsername(UUID uuid) {
        class_1657 player;
        Preconditions.checkNotNull((Object)uuid);
        String name = (String)NAMECACHE.getIfPresent((Object)uuid.toString());
        if (Strings.isNullOrEmpty((String)name) && (player = NameHelper.getClientPlayer()) != null && player.method_37908().method_8608()) {
            name = (String)NAMECACHE.getIfPresent((Object)uuid.toString());
            if (!Strings.isNullOrEmpty((String)name)) {
                return name;
            }
            if (PLAYERS.containsKey(uuid)) {
                name = PLAYERS.get(uuid);
                NAMECACHE.put((Object)uuid.toString(), (Object)name);
            }
            NetworkHandler.sendToServer(new PacketNameSync(uuid, name));
        }
        return !Strings.isNullOrEmpty((String)name) ? name : uuid.toString();
    }

    public static String getLastKnownTeamName(String teamID) {
        return NameHelper.getLastKnownTeamName(teamID, false);
    }

    public static String getLastKnownTeamName(String teamID, boolean fromSyncPacket) {
        class_1657 player;
        Preconditions.checkNotNull((Object)teamID);
        Object name = (String)NAMECACHE.getIfPresent((Object)teamID);
        if (!Strings.isNullOrEmpty((String)name)) {
            return name;
        }
        if (!fromSyncPacket && (player = NameHelper.getClientPlayer()) != null && player.method_37908().method_8608()) {
            name = (String)TEMPCACHE.getIfPresent((Object)teamID);
            if (!Strings.isNullOrEmpty((String)name)) {
                return name;
            }
            if (TEAMS.containsKey(teamID)) {
                name = TEAMS.get(teamID);
            }
            NetworkHandler.sendToServer(new PacketNameSync(teamID, (String)name));
            name = !Strings.isNullOrEmpty((String)name) ? name : "~" + teamID + "~";
            TEMPCACHE.put((Object)teamID, name);
            return name;
        }
        name = TeamHelper.getTeamDisplayName(teamID).getString();
        name = !Strings.isNullOrEmpty((String)name) ? name : "~" + teamID + "~";
        NAMECACHE.put((Object)teamID, name);
        return name;
    }

    public static void setPlayerName(UUID uuid, String name) {
        if (uuid != null && !Strings.isNullOrEmpty((String)name) && !name.equals(PLAYERS.get(uuid))) {
            PLAYERS.put(uuid, name);
        }
    }

    public static void setTeamName(String teamId, String name) {
        if (!Strings.isNullOrEmpty((String)teamId) && !Strings.isNullOrEmpty((String)name)) {
            if (!name.equals(TEAMS.get(teamId))) {
                TEAMS.put(teamId, name);
            }
            if (name.startsWith("|")) {
                TEMPCACHE.put((Object)teamId, (Object)name.substring(1, name.length() - 2));
            } else {
                NAMECACHE.put((Object)teamId, (Object)name);
            }
        }
    }
}

