/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.rgb16;

import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_3532;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16Helper;

public class RGB16StackHelper {
    public static class_1799 setRGB16(class_1799 stack, String colorName) {
        return RGB16StackHelper.setRGB16(stack, RGB16Helper.getIndexFor(colorName));
    }

    public static class_1799 setRGB16(class_1799 stack, RGB16 rgb16) {
        return RGB16StackHelper.setRGB16(stack, rgb16.getIndex());
    }

    public static class_1799 setRGB16(class_1799 stack, short rgbIndex) {
        if (stack.method_7909() instanceof IRGB16_Item) {
            ((IRGB16_Item)stack.method_7909()).setRGB16(stack, rgbIndex);
        }
        return stack;
    }

    public static short getRGB16Index(class_1799 stack) {
        if (stack.method_7909() instanceof IRGB16_Item) {
            return ((IRGB16_Item)stack.method_7909()).getRGB16(stack);
        }
        return -1;
    }

    public static RGB16 getRGB16(class_1799 stack) {
        short index = RGB16StackHelper.getRGB16Index(stack);
        return index >= 0 ? new RGB16(index) : null;
    }

    public static short readColorTag(class_1799 stack) {
        return RGB16StackHelper.readColorTag(stack, (short)4095);
    }

    public static short readColorTag(class_1799 stack, short defaultIndex) {
        class_2487 nbt = RGB16StackHelper.getNBTTag(stack);
        if (!nbt.method_10545("rgb16")) {
            RGB16StackHelper.writeColorTags(stack, defaultIndex);
        }
        return nbt.method_10568("rgb16");
    }

    public static byte readSimpleColorTag(class_1799 stack) {
        return RGB16StackHelper.readSimpleColorTag(stack, (short)4095);
    }

    public static byte readSimpleColorTag(class_1799 stack, short defaultIndex) {
        class_2487 nbt = RGB16StackHelper.getNBTTag(stack);
        if (!nbt.method_10545("rgbsimple")) {
            RGB16StackHelper.writeColorTags(stack, defaultIndex);
        }
        return nbt.method_10571("rgbsimple");
    }

    public static boolean writeColorTags(class_1799 stack, short rgbIndex) {
        rgbIndex = (short)class_3532.method_15340((int)rgbIndex, (int)0, (int)4096);
        class_2487 nbt = RGB16StackHelper.getNBTTag(stack);
        if (!nbt.method_10545("rgb16") || rgbIndex != RGB16StackHelper.readColorTag(stack)) {
            nbt.method_10575("rgb16", rgbIndex);
            nbt.method_10567("rgbsimple", RGB16Helper.getSimpleColor(rgbIndex));
            stack.method_7980(nbt);
            return true;
        }
        return false;
    }

    private static class_2487 getNBTTag(class_1799 stack) {
        return stack.method_7985() ? stack.method_7969() : new class_2487();
    }
}

