/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal;

import com.google.common.base.Strings;
import com.mojang.brigadier.CommandDispatcher;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1945;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_5556;
import net.minecraft.class_5620;
import net.minecraft.class_5819;
import net.minecraft.class_7157;
import net.minecraft.class_7923;
import net.minecraft.class_8566;
import shetiphian.core.common.DyeHelper;
import shetiphian.core.common.Function;
import shetiphian.core.common.IBonemealable;
import shetiphian.core.common.TagHelper;
import shetiphian.core.common.events.VillagerTradesCallback;
import shetiphian.core.common.rgb16.IRGB16_Block;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.RGB16StackHelper;
import shetiphian.core.internal.ShetiPhianCore;
import shetiphian.core.internal.teams.TeamCommand;
import shetiphian.core.mixins.SPC_AxeItem_Invoker;

public class EventHandler {
    private static final Map<class_2248, class_2248> LOG_LOOKUP = new HashMap<class_2248, class_2248>();
    private static boolean GENERATE_LOG_LOOKUP = true;
    public static final class_5620 RGB16WASH = (state, world, pos, player, hand, stack) -> {
        class_1792 item = stack.method_7909();
        if (RGB16StackHelper.getRGB16Index(stack) == ((IRGB16_Item)item).getStartingIndex(stack)) {
            return class_1269.field_5811;
        }
        if (!world.method_8608()) {
            class_1799 washedStack = stack.method_7972();
            washedStack.method_7939(1);
            IRGB16_Item itemRGB16 = (IRGB16_Item)item;
            short baseColor = itemRGB16.getStartingIndex(washedStack);
            if (itemRGB16.setRGB16(washedStack, baseColor)) {
                stack.method_7934(1);
                if (!player.method_31549().field_7477) {
                    class_5556.method_31650((class_2680)state, (class_1937)world, (class_2338)pos);
                }
                if (stack.method_7960()) {
                    player.method_6122(hand, washedStack);
                } else if (!player.method_31548().method_7394(washedStack)) {
                    player.method_7328(washedStack, false);
                }
            }
        }
        return class_1269.method_29236((boolean)world.method_8608());
    };

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 access, class_2170.class_5364 environment) {
        TeamCommand.register(dispatcher);
    }

    public static class_1269 onApplyBonemeal(class_2680 state, class_1937 world, class_2338 pos, class_1799 stack) {
        if (state != null) {
            IBonemealable bonemealable;
            class_2248 block = state.method_26204();
            if (ShetiPhianCore.CONFIG.COMMON.bonemeal_restores_bark) {
                if (GENERATE_LOG_LOOKUP) {
                    GENERATE_LOG_LOOKUP = false;
                    class_1792 axeItem = class_1802.field_8556;
                    if (axeItem instanceof SPC_AxeItem_Invoker) {
                        TagHelper.getBlocks("minecraft:logs").forEach(unstripped -> {
                            try {
                                ((SPC_AxeItem_Invoker)axeItem).invokeGetStrippedState(unstripped.method_9564()).ifPresent(result -> LOG_LOOKUP.compute(result.method_26204(), (stripped, cached) -> {
                                    class_5321 uKey;
                                    if (cached == null) {
                                        return unstripped;
                                    }
                                    class_5321 sKey = class_7923.field_41175.method_29113(stripped).orElse(null);
                                    class_5321 cKey = class_7923.field_41175.method_29113(cached).orElse(null);
                                    if (sKey != null && cKey != null && !sKey.method_29177().method_12836().equals(cKey.method_29177().method_12836()) && (uKey = (class_5321)class_7923.field_41175.method_29113(unstripped).orElse(null)) != null && sKey.method_29177().method_12836().equals(uKey.method_29177().method_12836())) {
                                        return unstripped;
                                    }
                                    return cached;
                                }));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        });
                    }
                }
                if (LOG_LOOKUP.containsKey(block)) {
                    class_2680 unstripped2 = LOG_LOOKUP.get(block).method_9564();
                    state.method_28501().forEach(property -> EventHandler.copyProperty(property, state, unstripped2));
                    Function.setBlock((class_1945)world, pos, unstripped2, true);
                    return class_1269.field_5812;
                }
            }
            if (block instanceof IBonemealable && (bonemealable = (IBonemealable)state.method_26204()).canGrow(world, pos, state, world.method_8608())) {
                if (!world.method_8608() && bonemealable.canUseBonemeal(world, world.field_9229, pos, state)) {
                    bonemealable.grow(world, world.field_9229, pos, state);
                }
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    private static <T extends Comparable<T>> void copyProperty(class_2769<T> property, class_2680 stripped, class_2680 unstripped) {
        if (unstripped.method_28498(property)) {
            unstripped.method_11657(property, stripped.method_11654(property));
        }
    }

    public static void onItemCrafted(class_1657 player, class_1799 result, class_8566 inventory) {
        IRGB16_Item rgb16Item;
        class_1792 class_17922;
        if (!result.method_7960() && (class_17922 = result.method_7909()) instanceof IRGB16_Item && (rgb16Item = (IRGB16_Item)class_17922).enableDyeRecipe(result) && rgb16Item.dyeUseChance(result)) {
            class_5819 rand = player.method_37908().method_8409();
            rand.method_43052((long)RGB16StackHelper.readColorTag(result));
            int counter = 0;
            for (int index = 0; index < inventory.method_5439(); ++index) {
                class_1799 invStack = inventory.method_5438(index);
                if (invStack.method_7960() || !invStack.method_7946() || !DyeHelper.isDye(invStack) || invStack.method_7909().method_7857()) continue;
                double chance = rgb16Item.getDyeUseChance(result, invStack, counter);
                ++counter;
                if (!(chance < 1.0) || chance != 0.0 && !(rand.method_43058() >= chance)) continue;
                invStack.method_7933(1);
            }
        }
    }

    public static class_1269 playerRightClickBlock(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        String dyeName;
        class_2680 state;
        class_2248 block;
        class_1799 stack;
        if (player != null && hitResult != null && !(stack = player.method_5998(hand)).method_7960() && (block = (state = world.method_8320(hitResult.method_17777())).method_26204()) instanceof IRGB16_Block && !Strings.isNullOrEmpty((String)(dyeName = DyeHelper.getDyeName(stack))) && ((IRGB16_Block)block).recolorBlock(state, (class_1936)world, hitResult.method_17777(), player, hand, hitResult.method_17780(), hitResult.method_17784(), dyeName)) {
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    static void setupVillagerTradeOffers() {
        HashMap PROFESSION_TRADES = new HashMap();
        class_3853.field_17067.forEach((profession, map) -> {
            Int2ObjectOpenHashMap trades = new Int2ObjectOpenHashMap();
            map.int2ObjectEntrySet().forEach(arg_0 -> EventHandler.lambda$setupVillagerTradeOffers$5((Int2ObjectMap)trades, arg_0));
            PROFESSION_TRADES.put(profession, trades);
        });
        int MAX_VILLAGER_LEVEL = Math.max(5, 5);
        class_7923.field_41195.forEach(profession -> {
            Int2ObjectMap defaults = (Int2ObjectMap)PROFESSION_TRADES.getOrDefault(profession, new Int2ObjectOpenHashMap());
            Int2ObjectOpenHashMap trades = new Int2ObjectOpenHashMap();
            for (int level = 1; level <= Math.max(MAX_VILLAGER_LEVEL, defaults.size() - 1); ++level) {
                trades.put(level, (Object)class_2371.method_10211());
            }
            defaults.int2ObjectEntrySet().forEach(arg_0 -> EventHandler.lambda$setupVillagerTradeOffers$7((Int2ObjectMap)trades, arg_0));
            ((VillagerTradesCallback.ProfessionTrades)VillagerTradesCallback.PROFESSION_TRADES.invoker()).gather((class_3852)profession, (Int2ObjectMap<List<class_3853.class_1652>>)trades);
            Int2ObjectOpenHashMap gathered = new Int2ObjectOpenHashMap();
            trades.int2ObjectEntrySet().forEach(arg_0 -> EventHandler.lambda$setupVillagerTradeOffers$8((Int2ObjectMap)gathered, arg_0));
            class_3853.field_17067.put(profession, gathered);
        });
        Int2ObjectOpenHashMap WANDERER_TRADES = new Int2ObjectOpenHashMap();
        class_3853.field_17724.int2ObjectEntrySet().forEach(arg_0 -> EventHandler.lambda$setupVillagerTradeOffers$10((Int2ObjectMap)WANDERER_TRADES, arg_0));
        class_2371 generic = class_2371.method_10211();
        class_2371 rare = class_2371.method_10211();
        generic.addAll(Arrays.asList((class_3853.class_1652[])WANDERER_TRADES.get(1)));
        rare.addAll(Arrays.asList((class_3853.class_1652[])WANDERER_TRADES.get(2)));
        ((VillagerTradesCallback.WandererTrades)VillagerTradesCallback.WANDERER_TRADES.invoker()).gather((List<class_3853.class_1652>)generic, (List<class_3853.class_1652>)rare);
        class_3853.field_17724.put(1, (Object)generic.toArray(new class_3853.class_1652[0]));
        class_3853.field_17724.put(2, (Object)rare.toArray(new class_3853.class_1652[0]));
    }

    private static /* synthetic */ void lambda$setupVillagerTradeOffers$10(Int2ObjectMap WANDERER_TRADES, Int2ObjectMap.Entry entry) {
        WANDERER_TRADES.put(entry.getIntKey(), (Object)Arrays.copyOf((class_3853.class_1652[])entry.getValue(), ((class_3853.class_1652[])entry.getValue()).length));
    }

    private static /* synthetic */ void lambda$setupVillagerTradeOffers$8(Int2ObjectMap gathered, Int2ObjectMap.Entry entry) {
        gathered.put(entry.getIntKey(), (Object)((List)entry.getValue()).toArray(new class_3853.class_1652[0]));
    }

    private static /* synthetic */ void lambda$setupVillagerTradeOffers$7(Int2ObjectMap trades, Int2ObjectMap.Entry entry) {
        Arrays.stream((class_3853.class_1652[])entry.getValue()).forEach(((List)trades.get(entry.getIntKey()))::add);
    }

    private static /* synthetic */ void lambda$setupVillagerTradeOffers$5(Int2ObjectMap trades, Int2ObjectMap.Entry entry) {
        trades.put(entry.getIntKey(), (Object)Arrays.copyOf((class_3853.class_1652[])entry.getValue(), ((class_3853.class_1652[])entry.getValue()).length));
    }
}

