/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal.teams;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import shetiphian.core.internal.network.NetworkHandler;
import shetiphian.core.internal.teams.PacketTeamSync;
import shetiphian.core.internal.teams.TeamHelper;

public class PlayerTeam {
    private final String id;
    private class_2561 displayName;
    @Nullable
    private UUID leader;
    private final Set<UUID> managers = new HashSet<UUID>();
    private final Set<UUID> members = new HashSet<UUID>();

    public static PlayerTeam create(String id, class_1657 leader, class_2561 displayName) {
        UUID uuid = leader != null ? leader.method_5667() : null;
        PlayerTeam team = new PlayerTeam(id, uuid, displayName);
        TeamHelper.SAVEDATA.TEAMS.put(id, team);
        if (leader != null) {
            TeamHelper.PLAYER_TEAM.put(uuid, team);
            team.syncChanges(leader);
        }
        TeamHelper.markDirty();
        TeamHelper.syncDisplayName(team.id, team.displayName.getString());
        return team;
    }

    public String getId() {
        return this.id;
    }

    public class_2561 getDisplayName() {
        return this.displayName;
    }

    public List<UUID> getMembers() {
        return ImmutableList.copyOf(this.members);
    }

    public boolean isManager(UUID player) {
        return this.managers.contains(player);
    }

    public List<UUID> getManagers() {
        return ImmutableList.copyOf(this.managers);
    }

    private PlayerTeam(String id, UUID leader, class_2561 displayName) {
        this.id = id;
        Object object = this.displayName = displayName != null ? displayName : class_2561.method_43470((String)id);
        if (leader != null) {
            this.leader = leader;
            this.managers.add(leader);
            this.members.add(leader);
        }
    }

    @Nullable
    UUID getLeader() {
        return this.leader;
    }

    boolean changeDisplayName(class_2561 displayName) {
        Object object = displayName = displayName != null ? displayName : class_2561.method_43470((String)this.id);
        if (!this.displayName.equals(displayName)) {
            this.displayName = displayName;
            TeamHelper.markDirty();
            TeamHelper.syncDisplayName(this.id, this.displayName.getString());
            return true;
        }
        return false;
    }

    void add(class_1657 player) {
        UUID uuid = player.method_5667();
        this.members.add(uuid);
        TeamHelper.PLAYER_TEAM.put(uuid, this);
        TeamHelper.markDirty();
        this.syncChanges(player);
    }

    void leave(class_1657 player) {
        UUID uuid = player.method_5667();
        if (!uuid.equals(this.leader)) {
            this.managers.remove(uuid);
            this.members.remove(uuid);
            TeamHelper.PLAYER_TEAM.remove(uuid);
            TeamHelper.markDirty();
        }
        this.syncChanges(player);
    }

    void kick(class_1657 player) {
        UUID uuid = player.method_5667();
        if (uuid.equals(this.leader)) {
            this.leader = null;
        }
        this.managers.remove(uuid);
        this.members.remove(uuid);
        TeamHelper.PLAYER_TEAM.remove(uuid);
        TeamHelper.markDirty();
        this.syncChanges(player);
    }

    boolean promote(class_1657 player) {
        UUID uuid = player.method_5667();
        if (!this.managers.contains(uuid)) {
            this.managers.add(uuid);
            this.members.add(uuid);
            TeamHelper.markDirty();
            this.syncChanges(player);
            return true;
        }
        return false;
    }

    boolean demote(class_1657 player) {
        UUID uuid = player.method_5667();
        if (!uuid.equals(this.leader) && this.managers.contains(uuid)) {
            this.managers.remove(uuid);
            TeamHelper.markDirty();
            this.syncChanges(player);
            return true;
        }
        return false;
    }

    boolean transfer(class_1657 player) {
        UUID uuid = player.method_5667();
        if (!uuid.equals(this.leader)) {
            this.leader = uuid;
            this.managers.add(uuid);
            this.members.add(uuid);
            TeamHelper.PLAYER_TEAM.put(uuid, this);
            TeamHelper.markDirty();
            this.syncChanges(player);
            return true;
        }
        return false;
    }

    private void syncChanges(class_1657 player) {
        if (player instanceof class_3222) {
            NetworkHandler.sendToPlayer(new PacketTeamSync(this, player), (class_3222)player);
        }
    }

    byte getPlayerStatus(class_1657 player) {
        UUID uuid = player.method_5667();
        return (byte)(this.members.contains(uuid) ? (this.leader == uuid ? 3 : (this.managers.contains(uuid) ? 2 : 1)) : 0);
    }

    @Environment(value=EnvType.CLIENT)
    void setPlayerStatus(byte status, UUID uuid) {
        if (status > 0) {
            switch (status) {
                case 3: {
                    this.leader = uuid;
                }
                case 2: {
                    this.managers.add(uuid);
                }
                case 1: {
                    this.members.add(uuid);
                }
            }
            TeamHelper.PLAYER_TEAM.put(uuid, this);
        }
    }

    static PlayerTeam load(String teamId, class_2487 nbt) {
        UUID leader = null;
        try {
            leader = nbt.method_10573("leader", 11) ? nbt.method_25926("leader") : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        class_5250 displayName = null;
        try {
            displayName = nbt.method_10573("display_name", 8) ? class_2561.class_2562.method_10877((String)nbt.method_10558("display_name")) : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        PlayerTeam team = new PlayerTeam(teamId, leader, (class_2561)displayName);
        if (nbt.method_10573("members", 9)) {
            nbt.method_10554("members", 11).forEach(player -> {
                try {
                    team.members.add(class_2512.method_25930((class_2520)player));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        if (nbt.method_10573("managers", 9)) {
            nbt.method_10554("managers", 11).forEach(player -> {
                try {
                    team.managers.add(class_2512.method_25930((class_2520)player));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        return team;
    }

    class_2487 write() {
        class_2487 nbt = new class_2487();
        nbt.method_10582("display_name", class_2561.class_2562.method_10867((class_2561)this.displayName));
        if (this.leader != null) {
            nbt.method_25927("leader", this.leader);
        }
        class_2499 memberNBT = new class_2499();
        this.members.forEach(player -> {
            try {
                memberNBT.add((Object)class_2512.method_25929((UUID)player));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        nbt.method_10566("members", (class_2520)memberNBT);
        class_2499 adminNBT = new class_2499();
        this.managers.forEach(player -> {
            try {
                adminNBT.add((Object)class_2512.method_25929((UUID)player));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        nbt.method_10566("managers", (class_2520)adminNBT);
        return nbt;
    }
}

