/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraheads.client;

import com.google.common.base.Strings;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1047;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2484;
import net.minecraft.class_2549;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3888;
import net.minecraft.class_4013;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_827;
import shetiphian.terraheads.BlockMobHead;
import shetiphian.terraheads.EnumHeadType;
import shetiphian.terraheads.TileEntityMobHead;
import shetiphian.terraheads.client.ModelVillagerHead;
import shetiphian.terraheads.client.ModelWitchHead;

@Environment(value=EnvType.CLIENT)
public class RenderMobHead
implements class_827<TileEntityMobHead>,
class_4013 {
    public static RenderMobHead INSTANCE;
    public static class_1799 ENTITY_EQUIPPED;
    private static final Table<String, String, class_2960> TEXTURE_CACHE;
    private static final Map<class_2960, class_3888.class_3889> HAT_CACHE;
    private static final ModelVillagerHead MODEL_VILLAGER;
    private static final ModelWitchHead MODEL_WITCH;

    public RenderMobHead() {
        if (INSTANCE == null) {
            INSTANCE = this;
        }
    }

    public void method_14491(class_3300 resourceManager) {
        TEXTURE_CACHE.clear();
        HAT_CACHE.clear();
    }

    public void render(TileEntityMobHead tile, float partialTicks, class_4587 matrixStack, class_4597 buffer, int combinedLight, int combinedOverlay) {
        float animation = 0.0f;
        class_2680 blockstate = tile.method_11010();
        boolean isWall = blockstate.method_26204() instanceof class_2549;
        class_2350 direction = isWall ? (class_2350)blockstate.method_11654((class_2769)class_2549.field_11724) : null;
        float rotation = 22.5f * (float)(isWall ? (2 + direction.method_10161()) * 4 : (Integer)blockstate.method_11654((class_2769)class_2484.field_11505));
        this.render(direction, rotation, ((BlockMobHead.MobHead)blockstate.method_26204()).getHeadType(), animation, tile.getData1(), tile.getData2(), matrixStack, buffer, combinedLight, combinedOverlay);
    }

    public void render(class_2350 facing, float rotation, EnumHeadType type, float animation, String data1, String data2, class_4587 matrixStack, class_4597 buffer, int combinedLight, int combinedOverlay) {
        matrixStack.method_22903();
        class_238 aabb = type.getShapeGround().method_1107();
        matrixStack.method_22904(aabb.field_1320 - aabb.field_1323, 0.0, aabb.field_1324 - aabb.field_1321);
        if (facing != null) {
            double height = (1.0 - (aabb.field_1325 - aabb.field_1322)) / 2.0;
            switch (facing) {
                case field_11043: {
                    matrixStack.method_22904(0.0, height, aabb.field_1321);
                    break;
                }
                case field_11035: {
                    matrixStack.method_22904(0.0, height, -aabb.field_1321);
                    break;
                }
                case field_11039: {
                    matrixStack.method_22904(aabb.field_1323, height, 0.0);
                    break;
                }
                default: {
                    matrixStack.method_22904(-aabb.field_1323, height, 0.0);
                }
            }
        }
        matrixStack.method_22905(-1.0f, -1.0f, 1.0f);
        switch (type) {
            case VILLAGER: {
                this.renderVillagerHead(rotation, "villager", data1, data2, matrixStack, buffer, combinedLight, combinedOverlay);
                break;
            }
            case ZOMBIE_VILLAGER: {
                this.renderVillagerHead(rotation, "zombie_villager", data1, data2, matrixStack, buffer, combinedLight, combinedOverlay);
                break;
            }
            case ILLAGER: {
                this.renderVillagerHead(rotation, "illager", !Strings.isNullOrEmpty((String)data1) ? data1 : "pillager", matrixStack, buffer, combinedLight, combinedOverlay);
                break;
            }
            case WANDERING_TRADER: {
                this.renderVillagerHead(rotation, "", "wandering_trader", matrixStack, buffer, combinedLight, combinedOverlay);
                break;
            }
            case WITCH: {
                this.renderWitchHead(rotation, matrixStack, buffer, combinedLight, combinedOverlay);
            }
        }
        matrixStack.method_22909();
    }

    private void renderVillagerHead(float rotation, String folder, String type, class_4587 matrixStack, class_4597 buffer, int combinedLight, int combinedOverlay) {
        MODEL_VILLAGER.renderWithHood(rotation, 0.0f, matrixStack, this.getVertexBuilder(buffer, folder, type), combinedLight, combinedOverlay);
    }

    private void renderVillagerHead(float rotation, String folder, String type, String profession, class_4587 matrixStack, class_4597 buffer, int combinedLight, int combinedOverlay) {
        boolean renderTypeHat;
        MODEL_VILLAGER.renderBase(rotation, 0.0f, matrixStack, this.getVertexBuilder(buffer, folder, folder), combinedLight, combinedOverlay);
        class_2960 texType = this.getTexture(folder + "/type", type);
        class_2960 texProfession = this.getTexture(folder + "/profession", Strings.isNullOrEmpty((String)profession) || profession.endsWith("none") ? "" : profession);
        class_3888.class_3889 tHat = this.getHatType(texType);
        class_3888.class_3889 pHat = this.getHatType(texProfession);
        boolean bl = renderTypeHat = pHat == class_3888.class_3889.field_17160 || pHat == class_3888.class_3889.field_17161 && tHat != class_3888.class_3889.field_17162;
        if (renderTypeHat && texType != class_1047.method_4539()) {
            MODEL_VILLAGER.renderOverlay(rotation, 0.0f, matrixStack, this.getVertexBuilder(buffer, texType), combinedLight, combinedOverlay);
        }
        if (texProfession != class_1047.method_4539()) {
            MODEL_VILLAGER.renderOverlay(rotation, 0.0f, matrixStack, this.getVertexBuilder(buffer, texProfession), combinedLight, combinedOverlay);
        }
    }

    private class_3888.class_3889 getHatType(class_2960 location) {
        if (location != null && location != class_1047.method_4539()) {
            if (!HAT_CACHE.containsKey(location)) {
                class_3888.class_3889 type = class_3888.class_3889.field_17160;
                Optional iresource = class_310.method_1551().method_1478().method_14486(location);
                if (iresource.isPresent()) {
                    Optional villagermetadatasection;
                    try {
                        villagermetadatasection = ((class_3298)iresource.get()).method_14481().method_43041((class_3270)class_3888.field_17158);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    if (villagermetadatasection.isPresent()) {
                        type = ((class_3888)villagermetadatasection.get()).method_17167();
                    }
                }
                HAT_CACHE.put(location, type);
            }
            return HAT_CACHE.get(location);
        }
        return class_3888.class_3889.field_17160;
    }

    private void renderWitchHead(float rotation, class_4587 matrixStack, class_4597 buffer, int combinedLight, int combinedOverlay) {
        MODEL_WITCH.render(rotation, 0.0f, matrixStack, this.getVertexBuilder(buffer, "", "witch"), combinedLight, combinedOverlay);
    }

    private class_4588 getVertexBuilder(class_4597 buffer, String subFolder, String file) {
        return this.getVertexBuilder(buffer, this.getTexture(subFolder, file));
    }

    private class_4588 getVertexBuilder(class_4597 buffer, class_2960 texture) {
        return buffer.getBuffer(class_1921.method_23578((class_2960)texture));
    }

    private class_2960 getTexture(String subFolder, String file) {
        if (!Strings.isNullOrEmpty((String)file)) {
            if (Strings.isNullOrEmpty((String)subFolder)) {
                subFolder = "|";
            }
            if (!TEXTURE_CACHE.contains((Object)subFolder, (Object)file)) {
                int i = file.indexOf(":");
                String modId = i > 0 ? file.substring(0, i) : "minecraft";
                String name = i > 0 ? file.substring(i + 1) : file;
                class_2960 location = new class_2960(modId, "textures/entity/" + (String)(subFolder.equals("|") ? "" : subFolder + "/") + name + ".png");
                TEXTURE_CACHE.put((Object)subFolder, (Object)file, (Object)location);
            }
            return (class_2960)TEXTURE_CACHE.get((Object)subFolder, (Object)file);
        }
        return class_1047.method_4539();
    }

    static {
        ENTITY_EQUIPPED = class_1799.field_8037;
        TEXTURE_CACHE = HashBasedTable.create();
        HAT_CACHE = new HashMap<class_2960, class_3888.class_3889>();
        MODEL_VILLAGER = new ModelVillagerHead();
        MODEL_WITCH = new ModelWitchHead();
    }
}

