/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import shetiphian.core.common.Function;
import shetiphian.core.common.TagHelper;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.item.ItemColorizer;
import shetiphian.terraqueous.common.misc.BlueFlowerHandler;
import shetiphian.terraqueous.common.misc.PlantFunctions;
import shetiphian.terraqueous.common.tileentity.TileEntityFlowerPot;

@Config(name="terraqueous")
public class Configuration
extends PartitioningSerializer.GlobalData {
    @ConfigEntry.Category(value="client")
    @ConfigEntry.Gui.TransitiveObject
    public ClientFile CLIENT = new ClientFile();
    @ConfigEntry.Category(value="common")
    @ConfigEntry.Gui.TransitiveObject
    public CommonFile COMMON = new CommonFile();

    private static Set<String> getListOf(String ... values) {
        return new HashSet<String>(Arrays.asList(values));
    }

    private static void process_client(ClientFile clientFile) {
        Values.flowerpotOverrides.clear();
        if (Values.canProcessTags) {
            Configuration.processTagLists(clientFile);
        }
    }

    public static void processTagLists(ClientFile clientFile) {
        Configuration.processRenderList(TileEntityFlowerPot.RenderStyle.CROSS_SINGLE.ordinal(), clientFile.FLOWERPOTS.forceSingleCrossRender);
        Configuration.processRenderList(TileEntityFlowerPot.RenderStyle.CROSS_MULTI.ordinal(), clientFile.FLOWERPOTS.forceMultiCrossRender);
        Configuration.processRenderList(TileEntityFlowerPot.RenderStyle.BLOCK.ordinal(), clientFile.FLOWERPOTS.forceBlockRender);
        Configuration.processRenderList(TileEntityFlowerPot.RenderStyle.PANE.ordinal(), clientFile.FLOWERPOTS.forcePaneRender);
        Configuration.processRenderList(TileEntityFlowerPot.RenderStyle.TALL.ordinal(), clientFile.FLOWERPOTS.forceTallRender);
        Configuration.processRenderList(TileEntityFlowerPot.RenderStyle.BULB.ordinal(), clientFile.FLOWERPOTS.forceBulbRender);
    }

    private static void processRenderList(int style, Set<String> names) {
        for (String name : names) {
            if (Strings.isNullOrEmpty((String)name)) continue;
            if (name.toLowerCase().startsWith("tag|")) {
                name = name.substring(4);
                TagHelper.getItems((String)name).forEach(item -> {
                    class_2960 registration;
                    if (item != null && (registration = class_7923.field_41178.method_10221(item)) != class_7923.field_41178.method_10137()) {
                        Values.flowerpotOverrides.put(registration.toString(), (byte)style);
                    }
                });
                continue;
            }
            Values.flowerpotOverrides.put(name, (byte)style);
        }
    }

    private static void process_common(CommonFile commonFile) {
        BlueFlowerHandler.INSTANCE.buildList(commonFile.trickster_bloom_effects);
        PlantFunctions.load(commonFile.PLANTS, commonFile.TREES);
        Values.rebuildDustList = true;
        Values.rebuildGardnerList = true;
        ItemColorizer.buildClassLookUpMap(commonFile.TWEAKS.colorizer_class_mappings);
    }

    @Config(name="client")
    public static class ClientFile
    implements ConfigData {
        @ConfigEntry.Gui.CollapsibleObject
        @Comment(value="Select A GUI Style")
        public Menu_GUI GUI_STYLE = new Menu_GUI();
        @ConfigEntry.Gui.CollapsibleObject
        @Comment(value="Adjust how items render in flower pots")
        Menu_FlowerPots FLOWERPOTS = new Menu_FlowerPots();

        public void validatePostLoad() throws ConfigData.ValidationException {
            super.validatePostLoad();
            Configuration.process_client(this);
        }

        public static class Menu_GUI {
            public STYLE cloud_furnace = STYLE.DEFAULT;
            public STYLE cloud_workbench = STYLE.DEFAULT;
            public STYLE cloud_craftbench = STYLE.DEFAULT;
            public STYLE cloud_craftfurnace = STYLE.DEFAULT;
            public STYLE colorizer = STYLE.DEFAULT;
            public STYLE craftbench = STYLE.DEFAULT;
            public STYLE craftfurnace = STYLE.DEFAULT;
            public STYLE endertable = STYLE.DEFAULT;
            public STYLE stormforge = STYLE.DEFAULT;

            public static enum STYLE {
                DEFAULT,
                VANILLA;

            }
        }

        private static class Menu_FlowerPots {
            @Comment(value="Items Listed will render in flower pots using the Cross render style\nSaplings use this by default")
            public Set<String> forceSingleCrossRender = Configuration.getListOf(new String[0]);
            @Comment(value="Items Listed will render in flower pots using the Cross render style\n2D items use this by default")
            public Set<String> forceMultiCrossRender = Configuration.getListOf(new String[0]);
            @Comment(value="Items Listed will render in flower pots using the Block render style\n3D items use this by default")
            public Set<String> forceBlockRender = Configuration.getListOf(new String[0]);
            @Comment(value="Items Listed will render in flower pots using the Pane render style")
            public Set<String> forcePaneRender = Configuration.getListOf(new String[0]);
            @Comment(value="Items Listed will render in flower pots using the Tall render style")
            public Set<String> forceTallRender = Configuration.getListOf("minecraft:cactus");
            @Comment(value="Items Listed will render in flower pots using the Bulb render style (mostly buried)")
            public Set<String> forceBulbRender = Configuration.getListOf(new String[0]);

            private Menu_FlowerPots() {
            }
        }
    }

    @Config(name="common")
    public static class CommonFile
    implements ConfigData {
        @Comment(value="List of effects Trickster Bloom can apply")
        public Set<String> trickster_bloom_effects = BlueFlowerHandler.DEFAULTS;
        @ConfigEntry.Gui.CollapsibleObject
        @Comment(value="Small decoration objects")
        public Menu_Doodads DOODADS = new Menu_Doodads();
        @ConfigEntry.Gui.CollapsibleObject
        public Menu_Plants PLANTS = new Menu_Plants();
        @ConfigEntry.Gui.CollapsibleObject
        public Menu_Trees TREES = new Menu_Trees();
        @ConfigEntry.Gui.CollapsibleObject
        public Menu_StormForge STORMFORGE = new Menu_StormForge();
        @ConfigEntry.Gui.CollapsibleObject
        public Menu_WaterPearl WATER_PEARL = new Menu_WaterPearl();
        @ConfigEntry.Gui.CollapsibleObject
        @Comment(value="Make adjustments to how different blocks/items function")
        public Menu_Tweaks TWEAKS = new Menu_Tweaks();
        @ConfigEntry.Gui.CollapsibleObject
        @Comment(value="Controls which loot table injections are applied")
        public Menu_LootTables LOOT_TABLES = new Menu_LootTables();
        @ConfigEntry.Gui.CollapsibleObject
        @Comment(value="Options used by the world generator")
        public Menu_Generator GENERATOR = new Menu_Generator();

        public void validatePostLoad() throws ConfigData.ValidationException {
            super.validatePostLoad();
            Configuration.process_common(this);
        }

        public static class Menu_Doodads {
            @ConfigEntry.Gui.CollapsibleObject
            public SubMenu_Branch STICK = new SubMenu_Branch();
            @ConfigEntry.Gui.CollapsibleObject
            public SubMenu_Stone STONE = new SubMenu_Stone();
            @ConfigEntry.Gui.CollapsibleObject
            public SubMenu_Bone BONE = new SubMenu_Bone();
            @ConfigEntry.Gui.CollapsibleObject
            public SubMenu_SandStone SANDSTONE = new SubMenu_SandStone();
            @ConfigEntry.Gui.CollapsibleObject
            public SubMenu_RedSandStone REDSANDSTONE = new SubMenu_RedSandStone();
            @ConfigEntry.Gui.CollapsibleObject
            public SubMenu_Endimium ENDIMIUM = new SubMenu_Endimium();
            @ConfigEntry.Gui.CollapsibleObject
            public SubMenu_Burnium BURNIUM = new SubMenu_Burnium();

            public static class SubMenu_Branch {
                @Comment(value="The number of attempts made to successfully drop an item\npositive numbers are exact, negative are a random chance between 0 and the number")
                @ConfigEntry.BoundedDiscrete(min=-100L, max=100L)
                public int drop_attempts = 1;
                @Comment(value="'1 in x' chance the doodad will drop something from the whitelist, excluding items from the blacklist")
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int drop_chance = 1;
                @Comment(value="The number of items to drop on a successful attempt\npositive numbers are exact, negative are a random chance between 0 and the number")
                @ConfigEntry.BoundedDiscrete(min=-100L, max=100L)
                public int drop_count = -2;
                @Comment(value="Items listed here have a chance to drop\nFormats: ItemTag: 'tag|<tagId>#<count>', Mod Item: '<modId>:<itemId>#<count>'")
                public Set<String> whitelist = Configuration.getListOf("minecraft:stick#1-3");
                @Comment(value="Items listed here can never drop\nFormats: ItemTag: 'tag|<tagId>', Mod Item: '<modId>:<itemId>', Entire Mod: 'mod|<modId>'")
                public Set<String> blacklist = Configuration.getListOf(new String[0]);
            }

            public static class SubMenu_Stone {
                @Comment(value="The number of attempts made to successfully drop an item\npositive numbers are exact, negative are a random chance between 0 and the number")
                @ConfigEntry.BoundedDiscrete(min=-100L, max=100L)
                public int drop_attempts = 1;
                @Comment(value="'1 in x' chance the doodad will drop something from the whitelist, excluding items from the blacklist")
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int drop_chance = 1;
                @Comment(value="The number of items to drop on a successful attempt\npositive numbers are exact, negative are a random chance between 0 and the number")
                @ConfigEntry.BoundedDiscrete(min=-100L, max=100L)
                public int drop_count = -2;
                @Comment(value="Items listed here have a chance to drop\nFormats: ItemTag: 'tag|<tagId>#<count>', Mod Item: '<modId>:<itemId>#<count>'")
                public Set<String> whitelist = Configuration.getListOf("tag|c:dusts#1", "terraqueous:gravel_lump#1");
                @Comment(value="Items listed here can never drop\nFormats: ItemTag: 'tag|<tagId>', Mod Item: '<modId>:<itemId>', Entire Mod: 'mod|<modId>'")
                public Set<String> blacklist = Configuration.getListOf("tag|c:burnium_dusts", "tag|c:endimium_dusts");
            }

            public static class SubMenu_Bone {
                @Comment(value="The number of attempts made to successfully drop an item\npositive numbers are exact, negative are a random chance between 0 and the number")
                @ConfigEntry.BoundedDiscrete(min=-100L, max=100L)
                public int drop_attempts = 1;
                @Comment(value="'1 in x' chance the doodad will drop something from the whitelist, excluding items from the blacklist")
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int drop_chance = 1;
                @Comment(value="The number of items to drop on a successful attempt\npositive numbers are exact, negative are a random chance between 0 and the number")
                @ConfigEntry.BoundedDiscrete(min=-100L, max=100L)
                public int drop_count = -2;
                @Comment(value="Items listed here have a chance to drop\nFormats: ItemTag: 'tag|<tagId>#<count>', Mod Item: '<modId>:<itemId>#<count>'")
                public Set<String> whitelist = Configuration.getListOf("tag|c:bones#1", "minecraft:bone_meal#1-3");
                @Comment(value="Items listed here can never drop\nFormats: ItemTag: 'tag|<tagId>', Mod Item: '<modId>:<itemId>', Entire Mod: 'mod|<modId>'")
                public Set<String> blacklist = Configuration.getListOf(new String[0]);
            }

            public static class SubMenu_SandStone {
                @Comment(value="The number of attempts made to successfully drop an item\npositive numbers are exact, negative are a random chance between 0 and the number")
                @ConfigEntry.BoundedDiscrete(min=-100L, max=100L)
                public int drop_attempts = 1;
                @Comment(value="'1 in x' chance the doodad will drop something from the whitelist, excluding items from the blacklist")
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int drop_chance = 1;
                @Comment(value="The number of items to drop on a successful attempt\npositive numbers are exact, negative are a random chance between 0 and the number")
                @ConfigEntry.BoundedDiscrete(min=-100L, max=100L)
                public int drop_count = -2;
                @Comment(value="Items listed here have a chance to drop\nFormats: ItemTag: 'tag|<tagId>#<count>', Mod Item: '<modId>:<itemId>#<count>'")
                public Set<String> whitelist = Configuration.getListOf("tag|c:dusts#1", "terraqueous:sandstone_lump#1");
                @Comment(value="Items listed here can never drop\nFormats: ItemTag: 'tag|<tagId>', Mod Item: '<modId>:<itemId>', Entire Mod: 'mod|<modId>'")
                public Set<String> blacklist = Configuration.getListOf("tag|c:burnium_dusts", "tag|c:endimium_dusts");
            }

            public static class SubMenu_RedSandStone {
                @Comment(value="The number of attempts made to successfully drop an item\npositive numbers are exact, negative are a random chance between 0 and the number")
                @ConfigEntry.BoundedDiscrete(min=-100L, max=100L)
                public int drop_attempts = 1;
                @Comment(value="'1 in x' chance the doodad will drop something from the whitelist, excluding items from the blacklist")
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int drop_chance = 1;
                @Comment(value="The number of items to drop on a successful attempt\npositive numbers are exact, negative are a random chance between 0 and the number")
                @ConfigEntry.BoundedDiscrete(min=-100L, max=100L)
                public int drop_count = -2;
                @Comment(value="Items listed here have a chance to drop\nFormats: ItemTag: 'tag|<tagId>#<count>', Mod Item: '<modId>:<itemId>#<count>'")
                public Set<String> whitelist = Configuration.getListOf("tag|c:dusts#1", "terraqueous:red_sandstone_lump#1");
                @Comment(value="Items listed here can never drop\nFormats: ItemTag: 'tag|<tagId>', Mod Item: '<modId>:<itemId>', Entire Mod: 'mod|<modId>'")
                public Set<String> blacklist = Configuration.getListOf("tag|c:burnium_dusts", "tag|c:endimium_dusts");
            }

            public static class SubMenu_Endimium {
                @Comment(value="The number of attempts made to successfully drop an item\npositive numbers are exact, negative are a random chance between 0 and the number")
                @ConfigEntry.BoundedDiscrete(min=-100L, max=100L)
                public int drop_attempts = 1;
                @Comment(value="'1 in x' chance the doodad will drop something from the whitelist, excluding items from the blacklist")
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int drop_chance = 1;
                @Comment(value="The number of items to drop on a successful attempt\npositive numbers are exact, negative are a random chance between 0 and the number")
                @ConfigEntry.BoundedDiscrete(min=-100L, max=100L)
                public int drop_count = -3;
                @Comment(value="Items listed here have a chance to drop\nFormats: ItemTag: 'tag|<tagId>#<count>', Mod Item: '<modId>:<itemId>#<count>'")
                public Set<String> whitelist = Configuration.getListOf("tag|c:endimium_gems#1-4", "tag|c:endimium_dusts#1-4");
                @Comment(value="Items listed here can never drop\nFormats: ItemTag: 'tag|<tagId>', Mod Item: '<modId>:<itemId>', Entire Mod: 'mod|<modId>'")
                public Set<String> blacklist = Configuration.getListOf(new String[0]);
            }

            public static class SubMenu_Burnium {
                @Comment(value="The number of attempts made to successfully drop an item\npositive numbers are exact, negative are a random chance between 0 and the number")
                @ConfigEntry.BoundedDiscrete(min=-100L, max=100L)
                public int drop_attempts = 1;
                @Comment(value="'1 in x' chance the doodad will drop something from the whitelist, excluding items from the blacklist")
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int drop_chance = 1;
                @Comment(value="The number of items to drop on a successful attempt\npositive numbers are exact, negative are a random chance between 0 and the number")
                @ConfigEntry.BoundedDiscrete(min=-100L, max=100L)
                public int drop_count = -3;
                @Comment(value="Items listed here have a chance to drop\nFormats: ItemTag: 'tag|<tagId>#<count>', Mod Item: '<modId>:<itemId>#<count>'")
                public Set<String> whitelist = Configuration.getListOf("tag|c:burnium_gems#1-4", "tag|c:burnium_dusts#1-4");
                @Comment(value="Items listed here can never drop\nFormats: ItemTag: 'tag|<tagId>', Mod Item: '<modId>:<itemId>', Entire Mod: 'mod|<modId>'")
                public Set<String> blacklist = Configuration.getListOf(new String[0]);
            }
        }

        public static class Menu_Plants {
            @Comment(value="If enabled Terraqueous flowers require shears to harvest, otherwise nothing will drop")
            public boolean flowers_require_shears = true;
            @ConfigEntry.Gui.CollapsibleObject
            @Comment(value="Chance the plant will grow on the next block update")
            public SubMenu_PlantGrow PLANT_GROW = new SubMenu_PlantGrow();
            @ConfigEntry.Gui.CollapsibleObject
            @Comment(value="Chance the plant will spread on the next block update")
            public SubMenu_PlantSpread PLANT_SPREAD = new SubMenu_PlantSpread();
            @ConfigEntry.Gui.CollapsibleObject
            @Comment(value="Chance the plant will grow fruit on the next block update")
            public SubMenu_FruitGrow FRUIT_GROW = new SubMenu_FruitGrow();

            public static class SubMenu_PlantGrow {
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int flower_normal = 10;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int flower_rain = 9;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int grass_normal = 95;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int grass_rain = 75;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int pineapple_normal = 8;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int pineapple_rain = 5;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int cactus_day = 0;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int cactus_night = 8;
            }

            public static class SubMenu_PlantSpread {
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int flower_normal = 20;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int flower_rain = 18;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int grass_normal = 20;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int grass_rain = 18;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int grapevine_normal = 15;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int grapevine_rain = 13;
                @ConfigEntry.BoundedDiscrete(min=15L, max=100L)
                public int lifevine_normal = 0;
                @ConfigEntry.BoundedDiscrete(min=13L, max=100L)
                public int lifevine_rain = 8;
                @ConfigEntry.BoundedDiscrete(min=15L, max=100L)
                public int deathvine_normal = 0;
                @ConfigEntry.BoundedDiscrete(min=13L, max=100L)
                public int deathvine_rain = 8;
            }

            public static class SubMenu_FruitGrow {
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int pineapple_normal = 40;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int pineapple_rain = 40;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int cactus_day = 0;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int cactus_night = 40;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int grapevine_normal = 40;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int grapevine_rain = 40;
                @ConfigEntry.BoundedDiscrete(min=15L, max=100L)
                public int lifevine_normal = 40;
                @ConfigEntry.BoundedDiscrete(min=13L, max=100L)
                public int lifevine_rain = 40;
                @ConfigEntry.BoundedDiscrete(min=15L, max=100L)
                public int deathvine_normal = 40;
                @ConfigEntry.BoundedDiscrete(min=13L, max=100L)
                public int deathvine_rain = 40;
            }
        }

        public static class Menu_Trees {
            @Comment(value="Controls if the fruit stays on the trees or randomly falls off")
            public boolean fruit_stays_on_trees = true;
            @ConfigEntry.Gui.CollapsibleObject
            @Comment(value="'1 in x' chance the sapling will grow on the next block update")
            public SubMenu_SaplingGrow SAPLING_GROW = new SubMenu_SaplingGrow();
            @ConfigEntry.Gui.CollapsibleObject
            @Comment(value="'1 in x' chance the fruit flower will grow on the next block update")
            public SubMenu_FlowerGrow FLOWER_GROW = new SubMenu_FlowerGrow();
            @ConfigEntry.Gui.CollapsibleObject
            @Comment(value="'1 in x' chance the fruit will grow on the next block update")
            public SubMenu_FruitGrow FRUIT_GROW = new SubMenu_FruitGrow();
            @ConfigEntry.Gui.CollapsibleObject
            @Comment(value="'1 in x' chance a fruit will fall on the next block update\nIf 'fruit_stays_on_trees' is set true, fruit will never drop")
            public SubMenu_FruitFall FRUIT_FALL = new SubMenu_FruitFall();

            public static class SubMenu_SaplingGrow {
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int apple = 7;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int cherry = 7;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int orange = 7;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int pear = 7;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int peach = 7;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int mango = 7;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int lemon = 7;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int plum = 7;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int coconut = 7;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int banana = 7;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int mulberry = 7;

                public int[] getValues() {
                    return new int[]{this.apple, this.cherry, this.orange, this.pear, this.peach, this.mango, this.lemon, this.plum, this.coconut, this.banana, this.mulberry};
                }
            }

            public static class SubMenu_FlowerGrow {
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int apple = 25;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int cherry = 25;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int orange = 25;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int pear = 25;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int peach = 25;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int mango = 25;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int lemon = 25;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int plum = 25;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int banana = 15;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int mulberry = 25;

                public int[] getValues() {
                    return new int[]{this.apple, this.cherry, this.orange, this.pear, this.peach, this.mango, this.lemon, this.plum, 0, this.banana, this.mulberry};
                }
            }

            public static class SubMenu_FruitGrow {
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int apple = 40;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int cherry = 40;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int orange = 40;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int pear = 50;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int peach = 40;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int mango = 50;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int lemon = 30;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int plum = 40;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int coconut = 20;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int banana = 20;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int mulberry = 40;

                public int[] getValues() {
                    return new int[]{this.apple, this.cherry, this.orange, this.pear, this.peach, this.mango, this.lemon, this.plum, this.coconut, this.banana, this.mulberry};
                }
            }

            public static class SubMenu_FruitFall {
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int apple = 50;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int cherry = 50;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int orange = 50;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int pear = 60;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int peach = 50;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int mango = 60;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int lemon = 40;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int plum = 50;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int coconut = 70;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int mulberry = 50;

                public int[] getValues() {
                    return new int[]{this.apple, this.cherry, this.orange, this.pear, this.peach, this.mango, this.lemon, this.plum, this.coconut, 0, this.mulberry};
                }
            }
        }

        public static class Menu_StormForge {
            @Comment(value="Controls who has permission to create a StormForge.\nNOTE: Does not disable/remove existing StormForges")
            public LEVEL permissions = LEVEL.EVERYONE;
            @ConfigEntry.BoundedDiscrete(min=1L, max=100L)
            @Comment(value="A smelting recipe's 'cookingtime' will be multiplied by this value when processed in a StormForge")
            public double smelt_time_multiplier = 2.0;
            @ConfigEntry.BoundedDiscrete(min=20L, max=600L)
            @Comment(value="The number of ticks needed to repair an item by one point")
            public int ticks_per_repair_point = 100;
            @ConfigEntry.BoundedDiscrete(min=1L, max=2048L)
            @Comment(value="The base amount of energy charged per tick\nThis value is multiplied by the PowerMultiplier that matches the items requirements")
            public int power_per_tick_base = 32;

            public static enum LEVEL {
                NO_ONE,
                OPS_ONLY,
                OPS_CREATIVE,
                EVERYONE;


                public boolean check(class_1657 player) {
                    return switch (this) {
                        default -> throw new IncompatibleClassChangeError();
                        case NO_ONE -> false;
                        case OPS_ONLY -> Function.isOP((class_1657)player);
                        case OPS_CREATIVE -> {
                            if (Function.isOP((class_1657)player) || player.method_31549().field_7477) {
                                yield true;
                            }
                            yield false;
                        }
                        case EVERYONE -> true;
                    };
                }
            }
        }

        public static class Menu_WaterPearl {
            @Comment(value="Prevent breath loss while held, or in the hotbar, or equipped as a bauble")
            public boolean enable_water_breathing = true;
            @Comment(value="Allows the placement water into the world, and filling fluid inventories")
            public boolean enable_world_interaction = true;
        }

        public static class Menu_Tweaks {
            @Comment(value="Glass Blocks will drop shards when broken, if it would otherwise drop nothing")
            public boolean enable_glass_shard_drops_for_blocks = true;
            @Comment(value="Throwable Potions will drop a shard when broken")
            public boolean enable_glass_shard_drops_for_potions = true;
            @Comment(value="Adds feather moulting")
            public boolean chickens_moult = true;
            @Comment(value="Adds two AITasks\nAnimals the follow for wheat will also follow for hay\nAnimals that eat grass will also eat hay")
            public boolean add_hay_ai_tasks = true;
            @Comment(value="Burnium will hiss and produce steam when touching water")
            public boolean burnium_reacts_to_water = true;
            @Comment(value="Water filled Planters can act as infinite water sources\neg. middle block in a 1x3 layout, or all blocks in a 2x2 layout")
            public boolean planter_infinite_water = true;
            @Comment(value="Vines overgrow Pergola Gates, that haven't been used in a while, locking them in their open/closed state until the vine is broken")
            public boolean vines_overgrow_gates = true;
            @Comment(value="Map of non-colored blocks that have colored variants but do not just add the color name to the start or end (eg. Glass & Stained Glass\nFormat: <modId>:<base_blockId>:<colored_blockId> Note: the colored_blockId must include * in place of the color (eg. 'orange_stained_glass' = '*_stained_glass'")
            private final Set<String> colorizer_class_mappings = Configuration.getListOf("minecraft:glass:*_stained_glass", "minecraft:glass_pane:*_stained_glass_pane");
            @ConfigEntry.Gui.CollapsibleObject
            public SubMenu_Villager VILLAGER = new SubMenu_Villager();

            public static class SubMenu_Villager {
                @Comment(value="Villagers will no longer trample Farmland back to dirt")
                public boolean disable_villager_trample = true;
                @Comment(value="Gardner Villager will cleanup excess grass and flowers (from this mod only) while wandering around")
                public boolean gardner_weeds = true;
                @Comment(value="Weighted list of item blocks the Gardner can plant\nFormats: ItemTag: 'tag|<tagId>#<weight>', Mod Item: '<modId>:<itemId>#<weight>', Note: Items are processed in listed order and are not overwritten. For instance; if you wanted Botania flowers be rare (a low weight), you must list their flowers or flower tag before 'tag|minecraft:flowers', otherwise their weight will be locked to the global tags weight")
                public Set<String> gardner_whitelist = Configuration.getListOf("tag|minecraft:flowers#10", "tag|minecraft:saplings#8", "minecraft:cactus#6", "terraqueous:cactus#6");
                @Comment(value="Gardner will never plant the following\nFormats: ItemTag: 'tag|<tagId>', Mod Item: '<modId>:<itemId>', Entire Mod: 'mod|<modId>'")
                public Set<String> gardner_blacklist = Configuration.getListOf("minecraft:sunflower");
            }
        }

        public static class Menu_LootTables {
            @ConfigEntry.Gui.CollapsibleObject
            public SubMenu_Chests CHESTS = new SubMenu_Chests();
            @ConfigEntry.Gui.CollapsibleObject
            public SubMenu_Mobs MOBS = new SubMenu_Mobs();

            public static class SubMenu_Chests {
                @Comment(value="Spawn Bonus Chests can contain LifeFruit")
                public boolean spawn_bonus_lifefruit = true;
                @Comment(value="Mineshaft Chests can contain DeathFruit")
                public boolean mineshaft_deathfruit = true;
                @Comment(value="Village Toolsmith Chests can contain a Molecular Colorizer")
                public boolean toolsmith_colorizer = true;
                @Comment(value="Dungeon Chests can contain a Molecular Colorizer")
                public boolean dungeon_colorizer = true;
                @Comment(value="Stronghold Library Chests can contain a Strange Scroll")
                public boolean stronghold_strange_scroll = true;
                @Comment(value="Nether Bridge Chests can contain a Strange Scroll")
                public boolean nether_bridge_strange_scroll = true;
                @Comment(value="Dungeon Chests can contain the Toon Trotters")
                public boolean dungeon_toon_trotters = true;
            }

            public static class SubMenu_Mobs {
                @Comment(value="Must be enabled for any of the mob specific ones to work")
                public boolean enable_extra_drops = true;
                public boolean blaze_burnium_dust = true;
                public boolean blaze_burnium_gem = true;
                public boolean enderman_ender_dust = true;
                public boolean enderman_endimium_dust = true;
                public boolean enderman_endimium_gem = true;
                public boolean endermite_ender_dust = true;
                public boolean endermite_endimium_dust = true;
                public boolean magma_cube_burnium_gem = true;
                public boolean piglin_gold_dust = true;
                public boolean wither_skeleton_coal_dust = true;
                public boolean zombie_leather_scraps = true;
            }
        }

        public static class Menu_Generator {
            @Comment(value="This is a general on/off toggle\nFor more control see the sub menu")
            public boolean generate_clouds = true;
            @Comment(value="This is a general on/off toggle\nFor more control see the sub menu")
            public boolean generate_doodads = true;
            @Comment(value="This is a general on/off toggle\nFor more control see the sub menu")
            public boolean generate_flowers = true;
            @Comment(value="This is a general on/off toggle\nFor more control see the sub menu")
            public boolean generate_plants = true;
            @Comment(value="This is a general on/off toggle\nFor more control see the sub menu")
            public boolean generate_trees = true;
            @Comment(value="This is a general on/off toggle\nFor more control see the sub menu")
            public boolean generate_structures = true;
            @ConfigEntry.Gui.CollapsibleObject
            @Comment(value="Generators will not generate in the biomes on this list\nThe registered name is expected. [eg: minecraft:forest, minecraft:stony_shore] (regex supported)")
            public SubMenu_BiomeBlacklist BIOME_BLACKLIST = new SubMenu_BiomeBlacklist();
            @ConfigEntry.Gui.CollapsibleObject
            @Comment(value="Generators will not generate in the dimensions on this list\nThe registered name is expected. [eg: minecraft:overworld, minecraft:the_nether, minecraft:the_end] (regex supported)\nFinding the registered name:\nWith an open source mod, running a search for RegistryKey<DimensionType> should get you the name.\nWith closed sourced mods, asking the author or using a decompiler like JD-GUI are your options.")
            public SubMenu_DimBlacklist DIM_BLACKLIST = new SubMenu_DimBlacklist();
            @ConfigEntry.Gui.CollapsibleObject
            public SubMenu_Clouds CLOUDS = new SubMenu_Clouds();
            @ConfigEntry.Gui.CollapsibleObject
            public SubMenu_Doodads DOODADS = new SubMenu_Doodads();
            @ConfigEntry.Gui.CollapsibleObject
            public SubMenu_Flowers FLOWERS = new SubMenu_Flowers();
            @ConfigEntry.Gui.CollapsibleObject
            public SubMenu_Plants PLANTS = new SubMenu_Plants();
            @ConfigEntry.Gui.CollapsibleObject
            public SubMenu_Trees TREES = new SubMenu_Trees();
            @ConfigEntry.Gui.CollapsibleObject
            public SubMenu_Structures STRUCTURES = new SubMenu_Structures();

            public static class SubMenu_BiomeBlacklist {
                @Comment(value="Biomes here are blacklist from all generators")
                public final Set<String> global = Configuration.getListOf(new String[0]);
                public final Set<String> clouds = Configuration.getListOf(new String[0]);
                public final Set<String> doodads = Configuration.getListOf(new String[0]);
                public final Set<String> flowers = Configuration.getListOf(new String[0]);
                public final Set<String> plants = Configuration.getListOf(new String[0]);
                public final Set<String> trees = Configuration.getListOf(new String[0]);
            }

            public static class SubMenu_DimBlacklist {
                @Comment(value="Dimensions here are blacklist from all generators")
                public final Set<String> global = Configuration.getListOf("randomthings:spectre", "compactmachines:compactmachines");
                public final Set<String> clouds = Configuration.getListOf(new String[0]);
                public final Set<String> doodads = Configuration.getListOf(new String[0]);
                public final Set<String> flowers = Configuration.getListOf(new String[0]);
                public final Set<String> plants = Configuration.getListOf(new String[0]);
                public final Set<String> trees = Configuration.getListOf(new String[0]);
            }

            public static class SubMenu_Clouds {
                @Comment(value="Enable the generation of light cloud clusters")
                public boolean generate_light = true;
                @Comment(value="Enable the generation of dense cloud clusters")
                public boolean generate_dense = true;
                @Comment(value="Enable the generation of storm cloud clusters")
                public boolean generate_storm = true;
            }

            public static class SubMenu_Doodads {
                @Comment(value="Enable the generation of stick/branch doodads")
                public boolean generate_stick = true;
                @Comment(value="Enable the generation of stone, sandstone, and red sandstone doodads")
                public boolean generate_stone = true;
                @Comment(value="Enable the generation of bone/fossil doodads")
                public boolean generate_bone = true;
                @Comment(value="Enable the generation of endimium crystals and ore")
                public boolean generate_endimium = true;
                @Comment(value="Enable the generation of burnium crystals and ore")
                public boolean generate_burnium = true;
            }

            public static class SubMenu_Flowers {
                @Comment(value="While true flowers generated will differ by biome type")
                public boolean per_biome_flowers = true;
            }

            public static class SubMenu_Plants {
                @Comment(value="Can Pineapples Generate")
                public boolean generate_pineapple = true;
                @Comment(value="Can Prickly Pear Cactus Generate")
                public boolean generate_cactus = true;
            }

            public static class SubMenu_Trees {
                public boolean generate_apple = true;
                public boolean generate_cherry = true;
                public boolean generate_orange = true;
                public boolean generate_pear = true;
                public boolean generate_peach = true;
                public boolean generate_mango = true;
                public boolean generate_lemon = true;
                public boolean generate_plum = true;
                public boolean generate_coconut = true;
                public boolean generate_banana = true;
                public boolean generate_mulberry = true;
            }

            public static class SubMenu_Structures {
                @Comment(value="Add structures to the Desert Village")
                public boolean desert_village = true;
                @Comment(value="Add structures to the Plains Village")
                public boolean plains_village = true;
                @Comment(value="Add structures to the Savanna Village")
                public boolean savanna_village = true;
                @Comment(value="Add structures to the Snowy Village")
                public boolean snowy_village = true;
                @Comment(value="Add structures to the Taiga Village")
                public boolean taiga_village = true;
                @Comment(value="Add structures to the Pillager Outpost")
                public boolean pillager_outpost = true;
            }
        }
    }

    public static class Validators {
        public static final Pattern PATTERN_MOD = Pattern.compile("(?>mod\\|)([a-z0-9_.-]+)");
        public static final Pattern PATTERN_ITEM = Pattern.compile("(?>tag\\|)?((?>[a-z0-9_.-]+):(?>[a-z0-9\\/_.-]+))(?>#(\\d+(?>-\\d+)?))?");
        private final Predicate<Object> WHITELIST = object -> {
            String string;
            if (object instanceof String && !Strings.isNullOrEmpty((String)(string = (String)object))) {
                if (string.startsWith("mod|")) {
                    return PATTERN_MOD.matcher(string).find();
                }
                Matcher matcher = PATTERN_ITEM.matcher(string);
                return matcher.find() && string.contains("#");
            }
            return false;
        };
        private final Predicate<Object> BLACKLIST = object -> {
            String string;
            if (object instanceof String && !Strings.isNullOrEmpty((String)(string = (String)object))) {
                if (string.startsWith("mod|")) {
                    return PATTERN_MOD.matcher(string).find();
                }
                Matcher matcher = PATTERN_ITEM.matcher(string);
                return matcher.find();
            }
            return false;
        };
        private final Predicate<Object> ID = object -> {
            String string;
            if (object instanceof String && !Strings.isNullOrEmpty((String)(string = (String)object))) {
                return string.split(":").length == 2;
            }
            return false;
        };
    }
}

