/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.api.cloud;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3542;
import net.minecraft.class_3620;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import shetiphian.terraqueous.api.cloud.ICloud;

public class CloudAPI {
    public static final class_2746 KICKABLE = class_2746.method_11825((String)"generated");
    public static final class_6862<class_2248> TAG_CLOUD_BLOCK = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("terraqueous:is_cloud_block"));
    public static class_2498 soundTypeCloud = new class_2498(1.0f, -5.0f, class_3417.field_15165, class_3417.field_15060, class_3417.field_14945, class_3417.field_15040, class_3417.field_15092);
    private static final HashMap<String, Boolean> CLOUD_BLOCKS = new HashMap();
    private static final HashSet<String> CLOUD_WALK_ITEMS = new HashSet();
    public static final class_6862<class_1792> TAG_CLOUD_WALK = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("terraqueous:status/cloud_walk"));
    private static final HashMap<UUID, HashSet<String>> CLOUD_WALKING_ENTITIES = new HashMap();

    public static void addCloudBlock(class_2248 block, boolean punchable) {
        if (block != null) {
            CloudAPI.addCloudBlock(class_7923.field_41175.method_10221((Object)block).toString(), punchable);
        }
    }

    public static void addCloudBlock(String key, boolean punchable) {
        if (!Strings.isNullOrEmpty((String)key)) {
            CLOUD_BLOCKS.put(key, punchable);
        }
    }

    public static void addCloudWalkItem(class_1799 stack) {
        if (!stack.method_7960()) {
            CloudAPI.addCloudWalkItem(class_7923.field_41178.method_10221((Object)stack.method_7909()).toString());
        }
    }

    public static void addCloudWalkItem(String key) {
        if (!Strings.isNullOrEmpty((String)key)) {
            CLOUD_WALK_ITEMS.add(key);
        }
    }

    public static void grantCloudWalk(class_1309 entity, String source) {
        if (entity != null && !Strings.isNullOrEmpty((String)source)) {
            CloudAPI.getOrCreate(entity.method_5667()).add(source.toLowerCase().trim());
        }
    }

    public static void revokeCloudWalk(class_1309 entity, String source) {
        if (entity != null && !Strings.isNullOrEmpty((String)source)) {
            CloudAPI.getOrCreate(entity.method_5667()).remove(source.toLowerCase().trim());
        }
    }

    public static boolean hasCloudWalk(class_1309 entity) {
        if (entity != null) {
            return !CloudAPI.getOrCreate(entity.method_5667()).isEmpty();
        }
        return false;
    }

    private static Set<String> getOrCreate(UUID uuid) {
        if (!CLOUD_WALKING_ENTITIES.containsKey(uuid)) {
            CLOUD_WALKING_ENTITIES.put(uuid, new HashSet());
        }
        return CLOUD_WALKING_ENTITIES.get(uuid);
    }

    public static boolean entityCanBeOnClouds(class_1309 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (player.method_31549().field_7477 || player.method_31549().field_7478) {
                return true;
            }
        }
        return entity != null && CloudAPI.hasCloudWalk(entity);
    }

    public static boolean isCloud(class_2680 state, class_1922 world, class_2338 pos) {
        if (state.method_26204() instanceof ICloud) {
            return ((ICloud)state.method_26204()).isCloudBlock(state, world, pos);
        }
        return CloudAPI.isCloud(state);
    }

    public static boolean isCloud(class_2680 state) {
        if (state.method_26204() instanceof ICloud || state.method_26164(TAG_CLOUD_BLOCK)) {
            return true;
        }
        class_2960 id = class_7923.field_41175.method_10221((Object)state.method_26204());
        return id != null && CLOUD_BLOCKS.containsKey(id);
    }

    public static boolean isCloudWalkItem(class_1799 stack) {
        if (!stack.method_7960()) {
            return stack.method_31573(TAG_CLOUD_WALK) || CLOUD_WALK_ITEMS.contains(class_7923.field_41178.method_10221((Object)stack.method_7909()).toString());
        }
        return false;
    }

    public static boolean isCloudKickable(class_2680 state, class_1922 world, class_2338 pos) {
        if (state.method_26204() instanceof ICloud) {
            return ((ICloud)state.method_26204()).isCloudKickable(state, world, pos);
        }
        boolean kickable = false;
        try {
            kickable = (Boolean)state.method_11654((class_2769)KICKABLE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return kickable || CloudAPI.isCloudKickable(state.method_26204());
    }

    public static boolean isCloudKickable(class_2248 block) {
        class_2960 id = class_7923.field_41175.method_10221((Object)block);
        return id != null && CLOUD_BLOCKS.containsKey(id) && CLOUD_BLOCKS.get(id) != false;
    }

    public static boolean getKickable(class_2680 state) {
        boolean kickable;
        try {
            kickable = (Boolean)state.method_11654((class_2769)KICKABLE);
        }
        catch (Exception e) {
            kickable = false;
        }
        return kickable;
    }

    public static enum CloudType implements class_3542
    {
        LIGHT("light", class_3620.field_15988),
        DENSE("dense", class_3620.field_16027),
        STORM("storm", class_3620.field_16007);

        private final String name;
        private final class_3620 color;

        private CloudType(String name, class_3620 color) {
            this.name = name;
            this.color = color;
        }

        public String method_15434() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        @Deprecated
        public byte getID() {
            return (byte)this.ordinal();
        }

        public static CloudType byID(int index) {
            CloudType[] values = CloudType.values();
            return index < 0 || index >= values.length ? LIGHT : values[index];
        }

        public class_3620 getColor() {
            return this.color;
        }
    }
}

