/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.api.machines;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import shetiphian.terraqueous.api.machines.IEnderTableRecipe;

public class EnderTableRecipeHandler {
    public static final EnderTableRecipeHandler INSTANCE = new EnderTableRecipeHandler();
    private final List<IEnderTableRecipe> tableRecipes = new ArrayList<IEnderTableRecipe>();

    public void addEnderTableRecipe(IEnderTableRecipe recipe) {
        this.tableRecipes.add(recipe);
    }

    public void removeEnderTableRecipe(IEnderTableRecipe recipe) {
        this.tableRecipes.remove(recipe);
    }

    public List<IEnderTableRecipe> getTableRecipes() {
        return ImmutableList.copyOf(this.tableRecipes);
    }

    public RecipeSet getRecipes(@NotNull class_1799 enchantStack, @NotNull class_1799 materialStack, float enchantPower, class_1937 world) {
        return RecipeSet.create(enchantStack, materialStack, enchantPower, world);
    }

    public IEnderTableRecipe getRecipe(@NotNull class_1799 enchantStack, @NotNull class_1799 materialStack, float enchantPower, @NotNull IEnderTableRecipe.EnumOption option, class_1937 world) {
        for (IEnderTableRecipe recipe : this.tableRecipes) {
            if (!recipe.matches(enchantStack, materialStack, enchantPower, option, world)) continue;
            return recipe;
        }
        return null;
    }

    public boolean hasAnyEnchantResult(@NotNull class_1799 enchantStack, @NotNull class_1799 materialStack, float enchantPower, class_1937 world) {
        return this.hasAnyEnchantResult(this.getRecipes(enchantStack, materialStack, enchantPower, world), enchantStack, materialStack);
    }

    public boolean hasAnyEnchantResult(RecipeSet recipes, @NotNull class_1799 enchantStack, @NotNull class_1799 materialStack) {
        if (recipes != null && !recipes.isEmpty()) {
            for (int index = 0; index < 3; ++index) {
                if (!this.hasEnchantResult(recipes.get(index), enchantStack, materialStack, IEnderTableRecipe.EnumOption.byIndex(index))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasEnchantResult(IEnderTableRecipe recipe, @NotNull class_1799 enchantStack, @NotNull class_1799 materialStack, @NotNull IEnderTableRecipe.EnumOption option) {
        return !this.getEnchantResult(recipe, enchantStack, materialStack, option).method_7960();
    }

    @NotNull
    public class_1799 getEnchantResult(IEnderTableRecipe recipe, @NotNull class_1799 enchantStack, @NotNull class_1799 materialStack, @NotNull IEnderTableRecipe.EnumOption option) {
        return recipe == null ? class_1799.field_8037 : recipe.getResult(enchantStack, materialStack, option);
    }

    public int getExpCost(IEnderTableRecipe recipe, @NotNull class_1799 enchantStack, @NotNull class_1799 materialStack, @NotNull IEnderTableRecipe.EnumOption option) {
        return recipe == null ? 0 : recipe.getExpCost(enchantStack, materialStack, option);
    }

    public int getMaterialCost(IEnderTableRecipe recipe, @NotNull class_1799 enchantStack, @NotNull class_1799 materialStack, @NotNull IEnderTableRecipe.EnumOption option) {
        return recipe == null ? 0 : recipe.getMaterialCost(enchantStack, materialStack, option);
    }

    public String getTooltip(IEnderTableRecipe recipe, @NotNull class_1799 enchantStack, @NotNull class_1799 materialStack, @NotNull IEnderTableRecipe.EnumOption option) {
        return recipe == null ? "" : recipe.getTooltip(enchantStack, materialStack, option);
    }

    public boolean obfuscateTooltip(IEnderTableRecipe recipe, @NotNull class_1799 enchantStack, @NotNull class_1799 materialStack, @NotNull IEnderTableRecipe.EnumOption option) {
        return recipe == null || recipe.obfuscateTooltip(enchantStack, materialStack, option);
    }

    public void doneEnchant(IEnderTableRecipe recipe, @NotNull class_1799 enchantStack, @NotNull class_1799 materialStack, float enchantPower, @NotNull IEnderTableRecipe.EnumOption option, class_1937 world) {
        if (recipe != null) {
            recipe.doneEnchant(enchantStack, materialStack, enchantPower, option, world);
        }
    }

    public static class RecipeSet {
        public static final RecipeSet EMPTY = new RecipeSet(null, null, null);
        private final IEnderTableRecipe first;
        private final IEnderTableRecipe second;
        private final IEnderTableRecipe third;

        public static RecipeSet create(@NotNull class_1799 enchantStack, @NotNull class_1799 materialStack, float enchantPower, class_1937 world) {
            IEnderTableRecipe first = INSTANCE.getRecipe(enchantStack, materialStack, enchantPower, IEnderTableRecipe.EnumOption.FIRST, world);
            IEnderTableRecipe second = INSTANCE.getRecipe(enchantStack, materialStack, enchantPower, IEnderTableRecipe.EnumOption.SECOND, world);
            IEnderTableRecipe third = INSTANCE.getRecipe(enchantStack, materialStack, enchantPower, IEnderTableRecipe.EnumOption.THIRD, world);
            return first == null && second == null && third == null ? EMPTY : new RecipeSet(first, second, third);
        }

        private RecipeSet(IEnderTableRecipe first, IEnderTableRecipe second, IEnderTableRecipe third) {
            this.first = first;
            this.second = second;
            this.third = third;
        }

        public boolean isEmpty() {
            return this == EMPTY;
        }

        public IEnderTableRecipe get(IEnderTableRecipe.EnumOption option) {
            return this.get(option.ordinal());
        }

        public IEnderTableRecipe get(int index) {
            return switch (class_3532.method_15340((int)index, (int)0, (int)2)) {
                case 0 -> this.first;
                case 1 -> this.second;
                case 2 -> this.third;
                default -> null;
            };
        }
    }
}

