/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.api.plant;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3620;
import shetiphian.terraqueous.api.plant.IPlantControl;

public class PlantAPI {
    private static final List<IPlantControl> CONTROLLERS = Collections.synchronizedList(new ArrayList());

    public static void registerPlantController(IPlantControl controller) {
        CONTROLLERS.add(controller);
    }

    public static int getTreeEventChance(TreeEvent event, Tree type, class_1922 world, class_2338 pos, int defaultChance) {
        double chance = defaultChance;
        for (IPlantControl plantController : CONTROLLERS) {
            chance *= plantController.getChanceMultiplier(event, type, world, pos);
        }
        return class_3532.method_15384((double)chance);
    }

    public static int getPlantEventChance(PlantEvent event, Plant type, class_1922 world, class_2338 pos, int defaultChance) {
        double chance = defaultChance;
        for (IPlantControl plantController : CONTROLLERS) {
            chance *= plantController.getChanceMultiplier(event, type, world, pos);
        }
        return class_3532.method_15384((double)chance);
    }

    public static byte getPlacementValue(PlacementValue placement, class_1922 world, class_2338 pos, int defaultValue) {
        double value = defaultValue;
        for (IPlantControl plantController : CONTROLLERS) {
            value *= plantController.getValueMultiplier(placement, world, pos);
        }
        return (byte)class_3532.method_15384((double)value);
    }

    public static enum TreeEvent {
        FruitFlower,
        FruitGrow,
        FruitFall,
        SaplingGrow;

    }

    public static enum Tree implements class_3542
    {
        APPLE("apple", class_3620.field_16028),
        CHERRY("cherry", class_3620.field_15982),
        ORANGE("orange", class_3620.field_15981),
        PEAR("pear", class_3620.field_16018),
        PEACH("peach", class_3620.field_15981),
        MANGO("mango", class_3620.field_15981),
        LEMON("lemon", class_3620.field_16013),
        PLUM("plum", class_3620.field_16029),
        COCONUT("coconut", class_3620.field_16003),
        BANANA("banana", class_3620.field_16003),
        MULBERRY("mulberry", class_3620.field_16015);

        private final String name;
        private final class_3620 color;

        private Tree(String name, class_3620 color) {
            this.name = name;
            this.color = color;
        }

        public String method_15434() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static Tree byID(int index) {
            Tree[] values = Tree.values();
            return index < 0 || index >= values.length ? APPLE : values[index];
        }

        public class_3620 getBarkColor() {
            return this.color;
        }

        public class_3620 getWoodColor() {
            return this.color;
        }
    }

    public static enum PlantEvent {
        PlantGrow,
        PlantSpread,
        FruitGrow;

    }

    public static enum Plant implements class_3542
    {
        FLOWER("flower"),
        GRASS("grass"),
        PINEAPPLE("pineapple"),
        CACTUS("cactus"),
        GRAPEVINE("grapevine"),
        LIFEVINE("lifevine"),
        DEATHVINE("deathvine");

        private final String name;

        private Plant(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static Plant byID(int index) {
            Plant[] values = Plant.values();
            return index < 0 || index >= values.length ? FLOWER : values[index];
        }
    }

    public static enum PlacementValue {
        FlowerSpreadRadius,
        FlowerMaxAttempts,
        GrassSpreadRadius,
        GrassMaxAttempts;

    }
}

