/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.client.misc;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1920;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_3685;
import net.minecraft.class_6539;
import shetiphian.terraqueous.api.plant.PlantAPI;

@Environment(value=EnvType.CLIENT)
public class FoliageColor {
    private static final class_2960 LIGHT_VIBRANT = new class_2960("terraqueous:textures/colormap/lightvibrant.png");
    private static final class_2960 DARK_MEDIUM = new class_2960("terraqueous:textures/colormap/darkmedium.png");
    private static final class_2960 PLUM_CHERRY = new class_2960("terraqueous:textures/colormap/plumcherry.png");
    private static final class_2960 LIFE_DEATH = new class_2960("terraqueous:textures/colormap/lifedeath.png");
    private static final FoliageColor INSTANCE = new FoliageColor();
    public static int[][] colorBuffer = new int[4][65536];

    public static void onResourceManagerReload() {
        int[][] colorBuffer = new int[4][65536];
        colorBuffer[0] = FoliageColor.get(LIGHT_VIBRANT);
        colorBuffer[1] = FoliageColor.get(DARK_MEDIUM);
        colorBuffer[2] = FoliageColor.get(PLUM_CHERRY);
        colorBuffer[3] = FoliageColor.get(LIFE_DEATH);
        FoliageColor.colorBuffer = colorBuffer;
    }

    private static int[] get(class_2960 location) {
        try {
            return class_3685.method_16049((class_3300)class_310.method_1551().method_1478(), (class_2960)location);
        }
        catch (Exception exception) {
            return new int[65536];
        }
    }

    public static int getRenderColor(EnumFoliage foliage) {
        return INSTANCE.getBiomeFoliageColor(0.5, 1.0, foliage);
    }

    public static int getBiomeColor(class_1920 world, class_2338 pos, EnumFoliage foliage) {
        try {
            return world.method_23752(pos, (class_6539)foliage);
        }
        catch (Exception exception) {
            return FoliageColor.getRenderColor(foliage);
        }
    }

    private int getBiomeFoliageColor(double temperature, double rainfall, EnumFoliage foliage) {
        if (foliage == null) {
            return 0xFFFFFF;
        }
        int colorPoint = this.getFoliagePoint(temperature, rainfall, foliage.useAlt());
        return colorBuffer[foliage.getBufferIndex()][colorPoint];
    }

    private int getFoliagePoint(double temperature, double rainfall, boolean useAlt) {
        int valueT = (int)((1.0 - temperature) * 252.0);
        int valueR = (int)((1.0 - (rainfall *= temperature)) * 252.0);
        if (useAlt) {
            return valueT << 8 | ++valueR;
        }
        return valueR << 8 | (valueT += 256);
    }

    public static enum EnumFoliage implements class_6539
    {
        LIGHT(0, false),
        VIBRANT(0, true),
        DARK(1, false),
        MEDIUM(1, true),
        PLUM(2, false),
        CHERRY(2, true),
        LIFE(3, false),
        DEATH(3, true);

        private final int bufferIndex;
        private final boolean useAlt;

        private EnumFoliage(int bufferIndex, boolean useAlt) {
            this.bufferIndex = bufferIndex;
            this.useAlt = useAlt;
        }

        private int getBufferIndex() {
            return this.bufferIndex;
        }

        private boolean useAlt() {
            return this.useAlt;
        }

        public static EnumFoliage getFoliage(PlantAPI.Tree type) {
            if (type == null) {
                return null;
            }
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case PlantAPI.Tree.APPLE -> LIGHT;
                case PlantAPI.Tree.CHERRY -> CHERRY;
                case PlantAPI.Tree.ORANGE -> MEDIUM;
                case PlantAPI.Tree.PEAR -> MEDIUM;
                case PlantAPI.Tree.PEACH -> MEDIUM;
                case PlantAPI.Tree.MANGO -> DARK;
                case PlantAPI.Tree.LEMON -> VIBRANT;
                case PlantAPI.Tree.PLUM -> PLUM;
                case PlantAPI.Tree.COCONUT -> VIBRANT;
                case PlantAPI.Tree.BANANA -> LIGHT;
                case PlantAPI.Tree.MULBERRY -> LIGHT;
            };
        }

        public static EnumFoliage getFoliage(PlantAPI.Plant type) {
            if (type == null) {
                return null;
            }
            return switch (type) {
                case PlantAPI.Plant.GRAPEVINE -> LIGHT;
                case PlantAPI.Plant.LIFEVINE -> LIFE;
                case PlantAPI.Plant.DEATHVINE -> DEATH;
                default -> null;
            };
        }

        public int getColor(class_1959 biome, double posX, double posZ) {
            double temperature = class_3532.method_15363((float)biome.method_8712(), (float)0.0f, (float)1.0f);
            double rainfall = class_3532.method_15363((float)biome.field_26393.comp_846, (float)0.0f, (float)1.0f);
            return INSTANCE.getBiomeFoliageColor(temperature, rainfall, this);
        }
    }
}

