/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.client.model;

import com.google.common.collect.ImmutableTable;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3518;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_7775;
import net.minecraft.class_793;
import net.minecraft.class_806;
import net.minecraft.class_809;
import shetiphian.core.client.model.CompositeBakedModel;

@Environment(value=EnvType.CLIENT)
public class ModelMultiLayer {
    public static class_1100 load(JsonObject modelContents) {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        if (modelContents.has("children")) {
            JsonObject modelChildren = modelContents.getAsJsonObject("children");
            for (Map.Entry entry : modelChildren.entrySet()) {
                BlendMode blendMode;
                Object v = entry.getValue();
                if (!(v instanceof JsonObject)) continue;
                JsonObject subModel = (JsonObject)v;
                String name = (String)entry.getKey();
                GraphicsMode graphicsMode = name.endsWith("_fast") ? GraphicsMode.FAST : (name.endsWith("_fancy") ? GraphicsMode.FANCY : GraphicsMode.BOTH);
                if (class_3518.method_15289((JsonObject)subModel, (String)"render_type")) {
                    switch (class_3518.method_15265((JsonObject)subModel, (String)"render_type")) {
                        case "cutout": {
                            blendMode = BlendMode.CUTOUT;
                            break;
                        }
                        case "cutout_mipped": {
                            blendMode = BlendMode.CUTOUT_MIPPED;
                            break;
                        }
                        case "translucent": {
                            blendMode = BlendMode.TRANSLUCENT;
                            break;
                        }
                        default: {
                            blendMode = BlendMode.SOLID;
                            break;
                        }
                    }
                } else {
                    blendMode = BlendMode.SOLID;
                }
                builder.put((Object)graphicsMode, (Object)blendMode, (Object)class_793.method_3430((String)class_3518.method_43680((JsonElement)subModel)));
            }
        }
        return new Unbaked(class_793.method_3430((String)class_3518.method_43680((JsonElement)modelContents)), (ImmutableTable<GraphicsMode, BlendMode, class_1100>)builder.build());
    }

    private static enum GraphicsMode {
        FAST,
        FANCY,
        BOTH;


        public boolean doRender() {
            return this == BOTH || (class_310.method_1517() ? this == FANCY : this == FAST);
        }
    }

    public static class Unbaked
    extends class_793 {
        private final class_1100 owner;
        private final ImmutableTable<GraphicsMode, BlendMode, class_1100> models;

        public Unbaked(class_793 owner, ImmutableTable<GraphicsMode, BlendMode, class_1100> models) {
            super(owner.field_4247, owner.method_3433(), owner.field_4251, Boolean.valueOf(owner.method_3444()), owner.method_24298(), owner.field_4250, owner.method_3434());
            this.owner = owner;
            this.models = models;
        }

        public Collection<class_2960> method_4755() {
            return Collections.emptyList();
        }

        public void method_45785(Function<class_2960, class_1100> modelLoader) {
            this.owner.method_45785(modelLoader);
            for (class_1100 model : this.models.values()) {
                model.method_45785(modelLoader);
            }
        }

        public class_1087 method_4753(class_7775 bakery, Function<class_4730, class_1058> spriteGetter, class_3665 settings, class_2960 modelLocation) {
            return new Baked(this.owner.method_4753(bakery, spriteGetter, settings, modelLocation), Unbaked.buildModels(this.models, bakery, spriteGetter, settings, modelLocation));
        }

        private static ImmutableTable<GraphicsMode, BlendMode, class_1087> buildModels(ImmutableTable<GraphicsMode, BlendMode, class_1100> models, class_7775 bakery, Function<class_4730, class_1058> spriteGetter, class_3665 settings, class_2960 modelLocation) {
            ImmutableTable.Builder builder = ImmutableTable.builder();
            for (GraphicsMode graphicsMode : models.rowKeySet()) {
                for (Map.Entry entry : models.row((Object)graphicsMode).entrySet()) {
                    class_1087 model = ((class_1100)entry.getValue()).method_4753(bakery, spriteGetter, settings, modelLocation);
                    if (model == null) continue;
                    builder.put((Object)graphicsMode, (Object)((BlendMode)entry.getKey()), (Object)model);
                }
            }
            return builder.build();
        }
    }

    public static class Baked
    extends CompositeBakedModel {
        private final class_1087 owner;
        private final ImmutableTable<GraphicsMode, BlendMode, class_1087> models;

        public Baked(class_1087 owner, ImmutableTable<GraphicsMode, BlendMode, class_1087> models) {
            this.owner = owner;
            this.models = models;
        }

        protected List<class_1087> handleBlockState(class_2680 state, class_1921 renderLayer, class_5819 random, Object extraData) {
            if (renderLayer == null) {
                return this.handleItemState(class_1799.field_8037, random);
            }
            ArrayList<class_1087> list = new ArrayList<class_1087>();
            for (GraphicsMode graphicsMode : this.models.rowKeySet()) {
                class_1087 model;
                if (!graphicsMode.doRender() || (model = (class_1087)this.models.row((Object)graphicsMode).getOrDefault((Object)BlendMode.fromRenderLayer((class_1921)renderLayer), null)) == null) continue;
                list.add(model);
            }
            return list;
        }

        public class_806 method_4710() {
            return class_806.field_4292;
        }

        protected class_1087 handleItemState(class_1087 bakedModel, class_1799 itemStack, class_1937 world, class_1309 livingEntity) {
            return null;
        }

        protected List<class_1087> handleItemState(class_1799 itemStack, class_5819 random) {
            ArrayList<class_1087> list = new ArrayList<class_1087>();
            for (GraphicsMode graphicsMode : this.models.rowKeySet()) {
                if (graphicsMode == GraphicsMode.FAST) continue;
                list.addAll((Collection<class_1087>)this.models.row((Object)graphicsMode).values());
            }
            return list;
        }

        public boolean method_4708() {
            return this.owner.method_4708();
        }

        public boolean method_4712() {
            return this.owner.method_4712();
        }

        public boolean method_24304() {
            return this.owner.method_24304();
        }

        public class_1058 method_4711() {
            return this.owner.method_4711();
        }

        public class_809 method_4709() {
            return this.owner.method_4709();
        }
    }
}

