/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2498;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.minecraft.class_8567;
import org.jetbrains.annotations.NotNull;
import shetiphian.core.common.DistExecutor;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.block.BlockBurnium;
import shetiphian.terraqueous.common.misc.ConfiguredItemListUtil;

public class BlockDoodad
extends class_2248
implements class_3737 {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final Map<EnumType, List<DropEntry>> cacheDropList = new HashMap<EnumType, List<DropEntry>>();
    private static final class_265 SHAPE_ENDIMIUM = class_259.method_1081((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)1.0, (double)0.75);
    private static final class_265 SHAPE_BURNIUM = class_259.method_1081((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.75, (double)0.75);
    private static final class_265 SHAPE_FLAT = class_259.method_1081((double)0.05, (double)0.0, (double)0.05, (double)0.95, (double)0.15, (double)0.95);
    private final EnumType type;

    public BlockDoodad(EnumType type) {
        super(type.settings.method_9631(state -> type == EnumType.ENDIMIUM ? 6 : (type == EnumType.BURNIUM ? 10 : 0)));
        this.type = type;
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        if (type.isTranslucent()) {
            DistExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> BlockRenderLayerMap.INSTANCE.putBlock((class_2248)this, class_1921.method_23583()));
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{WATERLOGGED});
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (this.type == EnumType.ENDIMIUM) {
            return SHAPE_ENDIMIUM;
        }
        if (this.type == EnumType.BURNIUM) {
            return SHAPE_BURNIUM;
        }
        return SHAPE_FLAT;
    }

    public class_3609 getFluid() {
        return this.type == EnumType.BURNIUM ? class_3612.field_15908 : class_3612.field_15910;
    }

    public boolean method_10310(class_1922 world, class_2338 pos, class_2680 state, class_3611 fluid) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) == false && fluid == this.getFluid();
    }

    public boolean method_10311(class_1936 world, class_2338 pos, class_2680 state, class_3610 fluidState) {
        if (!((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue() && fluidState.method_15772() == this.getFluid()) {
            if (!world.method_8608()) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                world.method_39281(pos, fluidState.method_15772(), fluidState.method_15772().method_15789((class_4538)world));
            }
            return true;
        }
        return false;
    }

    public class_1799 method_9700(class_1936 world, class_2338 pos, class_2680 state) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            return this.getFluid() == class_3612.field_15908 ? new class_1799((class_1935)class_1802.field_8187) : new class_1799((class_1935)class_1802.field_8705);
        }
        return class_1799.field_8037;
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? this.getFluid().method_15729(false) : super.method_9545(state);
    }

    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(context.method_8045().method_8316(context.method_8037()).method_15772() == this.getFluid()));
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)this.getFluid(), this.getFluid().method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return BlockDoodad.method_16361((class_1922)world, (class_2338)pos.method_10074());
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean isMoving) {
        if (!this.method_9558(state, (class_4538)world, pos)) {
            world.method_8650(pos, true);
        }
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        ArrayList<class_1799> drops = new ArrayList<class_1799>();
        class_1799 tool = (class_1799)builder.method_51876(class_181.field_1229);
        int fortune = tool == null || tool.method_7960() ? 0 : class_1890.method_8225((class_1887)class_1893.field_9130, (class_1799)tool);
        Configuration.CommonFile.Menu_Doodads config = Terraqueous.CONFIG.COMMON.DOODADS;
        switch (this.type) {
            case BRANCH: {
                this.buildDrops(drops, fortune, config.STICK.drop_attempts, config.STICK.drop_chance, config.STICK.drop_count);
                break;
            }
            case STONE: {
                this.buildDrops(drops, fortune, config.STONE.drop_attempts, config.STONE.drop_chance, config.STONE.drop_count);
                break;
            }
            case BONE: {
                this.buildDrops(drops, fortune, config.BONE.drop_attempts, config.BONE.drop_chance, config.BONE.drop_count);
                break;
            }
            case SANDSTONE: {
                this.buildDrops(drops, fortune, config.SANDSTONE.drop_attempts, config.SANDSTONE.drop_chance, config.SANDSTONE.drop_count);
                break;
            }
            case REDSANDSTONE: {
                this.buildDrops(drops, fortune, config.REDSANDSTONE.drop_attempts, config.REDSANDSTONE.drop_chance, config.REDSANDSTONE.drop_count);
                break;
            }
            case ENDIMIUM: {
                this.buildDrops(drops, fortune, config.ENDIMIUM.drop_attempts, config.ENDIMIUM.drop_chance, config.ENDIMIUM.drop_count);
                break;
            }
            case BURNIUM: {
                this.buildDrops(drops, fortune, config.BURNIUM.drop_attempts, config.BURNIUM.drop_chance, config.BURNIUM.drop_count);
                break;
            }
            case GLASSSHARDS: {
                drops.add(new class_1799((class_1935)this));
            }
        }
        return drops;
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        boolean hasBoots;
        boolean bl = hasBoots = entity instanceof class_1309 && !((class_1309)entity).method_6118(class_1304.field_6166).method_7960();
        if (this.type == EnumType.ENDIMIUM || this.type == EnumType.BURNIUM || this.type == EnumType.GLASSSHARDS && !hasBoots) {
            entity.method_5643(entity.method_48923().method_48830(), 1.0f);
        }
    }

    public void method_9554(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        boolean hasBoots;
        boolean bl = hasBoots = entity instanceof class_1309 && !((class_1309)entity).method_6118(class_1304.field_6166).method_7960();
        if (this.type == EnumType.ENDIMIUM || this.type == EnumType.BURNIUM || this.type == EnumType.GLASSSHARDS) {
            entity.method_5643(entity.method_48923().method_48830(), this.type == EnumType.GLASSSHARDS && hasBoots ? 1.0f : 2.5f);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 rand) {
        if (this.type == EnumType.BURNIUM && Terraqueous.CONFIG.COMMON.TWEAKS.burnium_reacts_to_water && rand.method_43048(10) == 0) {
            BlockBurnium.waterInteraction(world, pos, rand);
        }
    }

    private void buildDrops(List<class_1799> drops, int fortune, int dropAttempts, int dropChance, int dropCount) {
        List<DropEntry> dropList;
        if (Values.rebuildDustList) {
            cacheDropList.clear();
            for (EnumType enumType : EnumType.values()) {
                cacheDropList.put(enumType, BlockDoodad.generateDropList(enumType));
            }
            Values.rebuildDustList = false;
        }
        if ((dropList = cacheDropList.get((Object)this.type)) == null) {
            dropList = BlockDoodad.generateDropList(this.type);
            cacheDropList.put(this.type, dropList);
        }
        if (!dropList.isEmpty()) {
            int maxAttempts = this.getNumber(dropAttempts);
            if (dropChance > 1) {
                dropChance = Math.max(2, (int)((double)dropChance * (1.0 - (double)Math.min(fortune, 5) / 10.0)));
            }
            if (dropChance > 1 && fortune > 5) {
                maxAttempts += fortune - 5;
            }
            for (int attempt = 0; attempt < maxAttempts; ++attempt) {
                if (dropChance <= 0 || Function.random.nextInt(dropChance) != 0) continue;
                for (int drop = 0; drop < this.getNumber(dropCount) + Function.random.nextInt(fortune + 1); ++drop) {
                    DropEntry dropEntry = dropList.get(Function.random.nextInt(dropList.size()));
                    drops.add(dropEntry.getStack(fortune));
                }
                return;
            }
        }
    }

    private int getNumber(int value) {
        if (value < 0) {
            return Function.random.nextInt(1 - value) + 1;
        }
        return value;
    }

    private static List<DropEntry> generateDropList(EnumType type) {
        Set<String> whitelist = null;
        Set<String> blacklist = null;
        switch (type) {
            case BRANCH: {
                whitelist = Terraqueous.CONFIG.COMMON.DOODADS.STICK.whitelist;
                blacklist = Terraqueous.CONFIG.COMMON.DOODADS.STICK.blacklist;
                break;
            }
            case STONE: {
                whitelist = Terraqueous.CONFIG.COMMON.DOODADS.STONE.whitelist;
                blacklist = Terraqueous.CONFIG.COMMON.DOODADS.STONE.blacklist;
                break;
            }
            case BONE: {
                whitelist = Terraqueous.CONFIG.COMMON.DOODADS.BONE.whitelist;
                blacklist = Terraqueous.CONFIG.COMMON.DOODADS.BONE.blacklist;
                break;
            }
            case SANDSTONE: {
                whitelist = Terraqueous.CONFIG.COMMON.DOODADS.SANDSTONE.whitelist;
                blacklist = Terraqueous.CONFIG.COMMON.DOODADS.SANDSTONE.blacklist;
                break;
            }
            case REDSANDSTONE: {
                whitelist = Terraqueous.CONFIG.COMMON.DOODADS.REDSANDSTONE.whitelist;
                blacklist = Terraqueous.CONFIG.COMMON.DOODADS.REDSANDSTONE.blacklist;
                break;
            }
            case ENDIMIUM: {
                whitelist = Terraqueous.CONFIG.COMMON.DOODADS.ENDIMIUM.whitelist;
                blacklist = Terraqueous.CONFIG.COMMON.DOODADS.ENDIMIUM.blacklist;
                break;
            }
            case BURNIUM: {
                whitelist = Terraqueous.CONFIG.COMMON.DOODADS.BURNIUM.whitelist;
                blacklist = Terraqueous.CONFIG.COMMON.DOODADS.BURNIUM.blacklist;
            }
        }
        Map<String, String> items = ConfiguredItemListUtil.generateItemList(type + " doodad", whitelist, blacklist);
        ArrayList<DropEntry> entryList = new ArrayList<DropEntry>();
        for (Map.Entry<String, String> entry : items.entrySet()) {
            try {
                class_1799 stack = new class_1799((class_1935)class_7923.field_41178.method_10223(new class_2960(entry.getKey())));
                if (stack.method_7960()) continue;
                entryList.add(DropEntry.create(stack, entry.getValue()));
            }
            catch (Exception error) {
                Terraqueous.LOGGER.debug("Error adding item '" + entry.getKey() + "' to " + type.method_15434() + " droplist; " + error);
            }
        }
        return entryList;
    }

    public static enum EnumType implements class_3542
    {
        BRANCH("branch", class_3620.field_15996, 0.75f, class_2498.field_11547, 0),
        STONE("stone", class_3620.field_16023, 0.75f, class_2498.field_11544, 0),
        BONE("bone", class_3620.field_15986, 0.25f, class_2498.field_11544, 0),
        SANDSTONE("sandstone", class_3620.field_15986, 0.75f, class_2498.field_11544, 0),
        ENDIMIUM("endimium", class_3620.field_15990, 0.75f, class_2498.field_11537, 6),
        BURNIUM("burnium", class_3620.field_15981, 0.75f, class_2498.field_11537, 10),
        GLASSSHARDS("glassshards", class_3620.field_16008, 0.25f, class_2498.field_11537, 0),
        REDSANDSTONE("redsandstone", class_3620.field_15987, 0.75f, class_2498.field_11544, 0);

        private final String name;
        private final class_4970.class_2251 settings;

        private EnumType(String name, class_3620 color, float hardness, class_2498 soundType, int light) {
            this.name = name;
            this.settings = class_4970.class_2251.method_9637().method_31710(color).method_51370().method_22488().method_50012(class_3619.field_15971).method_9629(hardness, 2.0f).method_9626(soundType).method_9631(state -> light);
        }

        public String method_15434() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        private boolean isTranslucent() {
            return this == ENDIMIUM || this == BURNIUM || this == GLASSSHARDS;
        }
    }

    private record DropEntry(class_1799 stack, int min, int max) {
        private DropEntry(class_1799 stack, int min, int max) {
            this.stack = stack;
            this.min = Math.min(min, max);
            this.max = Math.max(max, min);
        }

        public static DropEntry create(@NotNull class_1799 stack, String amount) {
            int min = 1;
            int max = 1;
            try {
                if (amount.contains("-")) {
                    min = Integer.parseInt(amount.split("-")[0]);
                    max = Integer.parseInt(amount.split("-")[1]);
                } else {
                    min = max = Integer.parseInt(amount);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new DropEntry(stack, min, max);
        }

        @NotNull
        public class_1799 getStack(int fortune) {
            class_1799 returnStack = this.stack.method_7972();
            int count = this.max == this.min ? this.max : Function.random.nextInt(this.max - this.min) + this.min;
            int boost = fortune;
            if (fortune > 5) {
                fortune = (fortune - 5) / 2 + 1;
                boost = 5 + fortune + Function.random.nextInt(fortune);
            }
            returnStack.method_7939(class_3532.method_15340((int)(count + boost), (int)1, (int)returnStack.method_7914()));
            return returnStack;
        }
    }
}

