/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1945;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import shetiphian.core.common.Function;
import shetiphian.core.common.TagHelper;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.block.BlockLeavesBase;
import shetiphian.terraqueous.common.item.ItemBlockLeaves;
import shetiphian.terraqueous.common.misc.PlantFunctions;

public class BlockLeavesBanana
extends BlockLeavesBase {
    public static final class_2754<EnumType> VARIANT = class_2754.method_11850((String)"variant", EnumType.class);
    private static final class_265 SHAPE_STALK_BARE = class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final class_265 SHAPE_STALK = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final class_6862<class_2248> TAG_BANANA_LOGS = TagHelper.getBlockTagKey((String)"terraqueous:banana_logs");

    public BlockLeavesBanana(PlantAPI.Tree treeType) {
        super(treeType);
        this.method_9590((class_2680)this.method_9564().method_11657(VARIANT, (Comparable)((Object)EnumType.NORMAL)));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{VARIANT});
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch ((EnumType)((Object)state.method_11654(VARIANT))) {
            case EnumType.NORMAL -> class_259.method_1077();
            case EnumType.STALK_BARE -> SHAPE_STALK_BARE;
            default -> SHAPE_STALK;
        };
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean isMoving) {
        if (!world.method_8608() && state.method_11654(VARIANT) != EnumType.NORMAL && world.method_22347(pos.method_10084())) {
            world.method_8650(pos, true);
        }
        super.method_9612(state, world, pos, block, fromPos, isMoving);
    }

    public boolean canGrow(class_1937 world, class_2338 pos, class_2680 state, boolean isClient) {
        switch ((EnumType)((Object)state.method_11654(VARIANT))) {
            case NORMAL: {
                return this.flowerCheck(world, pos);
            }
            case FLOWER: {
                class_2680 upState;
                if (world.method_22347(pos.method_10074()) && (upState = world.method_8320(pos.method_10084())).method_26204() == this && upState.method_11654(VARIANT) != EnumType.STALK_BARE) {
                    for (class_2350 facing : class_2350.class_2353.field_11062) {
                        class_2338 sPos = pos.method_10079(facing, 2);
                        class_2680 sState = world.method_8320(sPos.method_10074());
                        if (sState.method_26215() || !TagHelper.isBlockInTag((class_2680)sState, TAG_BANANA_LOGS)) continue;
                        return true;
                    }
                }
                return false;
            }
            case STALK_BARE: 
            case STALK_GROW: {
                return world.method_8320(pos.method_10084()).method_26204() == this && (world.method_22347(pos.method_10074()) || world.method_8320(pos.method_10074()).method_26204() == this);
            }
            case FRUIT: {
                return world.method_22347(pos.method_10074()) && world.method_8320(pos.method_10084()).method_26204() == this;
            }
        }
        return false;
    }

    private boolean isBananaLeaf(class_2680 state) {
        return state.method_26204() == this && state.method_11654(VARIANT) == EnumType.NORMAL;
    }

    private boolean flowerCheck(class_1937 world, class_2338 pos) {
        if (world.method_22347(pos.method_10074())) {
            class_2338 sPos;
            class_2680 sState;
            class_2338 woodPos = pos;
            for (class_2350 facing : class_2350.class_2353.field_11062) {
                if (!this.isBananaLeaf(world.method_8320(pos.method_10093(facing))) || (sState = world.method_8320(sPos = pos.method_10079(facing, 2))).method_26215() || !TagHelper.isBlockInTag((class_2680)sState, TAG_BANANA_LOGS)) continue;
                woodPos = sPos;
                break;
            }
            if (woodPos != pos && this.isBananaLeaf(sState = world.method_8320(woodPos.method_10084()))) {
                boolean noFlower = true;
                for (class_2350 facing : class_2350.class_2353.field_11062) {
                    sPos = woodPos.method_10079(facing, 2);
                    sState = world.method_8320(sPos.method_10074());
                    if (sState.method_26204() != this || sState.method_11654(VARIANT) == EnumType.NORMAL) continue;
                    noFlower = false;
                    break;
                }
                return noFlower;
            }
        }
        return false;
    }

    public boolean canUseBonemeal(class_1937 world, class_5819 random, class_2338 pos, class_2680 state) {
        return (state.method_11654(VARIANT) != EnumType.FRUIT || world.method_22347(pos.method_10074())) && random.method_43057() < 0.45f;
    }

    public void grow(class_1937 world, class_5819 rand, class_2338 pos, class_2680 state) {
        EnumType type = (EnumType)((Object)state.method_11654(VARIANT));
        switch (type) {
            case NORMAL: 
            case FRUIT: {
                if (!world.method_22347(pos.method_10074())) break;
                Function.setBlock((class_1945)world, (class_2338)pos.method_10074(), (class_2680)((class_2680)state.method_11657(VARIANT, (Comparable)((Object)EnumType.FLOWER))), (boolean)true);
                break;
            }
            case FLOWER: {
                class_2680 upState;
                if (!world.method_22347(pos.method_10074()) || (upState = world.method_8320(pos.method_10084())).method_26204() != this || upState.method_11654(VARIANT) == EnumType.STALK_BARE) break;
                Function.setBlock((class_1945)world, (class_2338)pos.method_10074(), (class_2680)((class_2680)state.method_11657(VARIANT, (Comparable)((Object)EnumType.FLOWER))), (boolean)true);
                Function.setBlock((class_1945)world, (class_2338)pos, (class_2680)((class_2680)state.method_11657(VARIANT, (Comparable)((Object)EnumType.STALK_BARE))), (boolean)true);
                break;
            }
            case STALK_BARE: 
            case STALK_GROW: {
                if (world.method_22347(pos.method_10074())) {
                    Function.setBlock((class_1945)world, (class_2338)pos.method_10074(), (class_2680)((class_2680)state.method_11657(VARIANT, (Comparable)((Object)EnumType.FLOWER))), (boolean)true);
                    break;
                }
                Function.setBlock((class_1945)world, (class_2338)pos, (class_2680)((class_2680)state.method_11657(VARIANT, (Comparable)((Object)(type == EnumType.STALK_BARE ? EnumType.STALK_GROW : EnumType.FRUIT)))), (boolean)true);
            }
        }
    }

    @Override
    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (state.method_11654(VARIANT) == EnumType.NORMAL) {
            super.method_9514(state, world, pos, random);
        }
        if (!world.method_22347(pos) && this.canGrow((class_1937)world, pos, state, world.method_8608())) {
            switch ((EnumType)((Object)state.method_11654(VARIANT))) {
                case NORMAL: 
                case FLOWER: 
                case FRUIT: {
                    if (!world.method_22347(pos.method_10074())) break;
                    this.grow((class_1937)world, random, pos, state);
                    break;
                }
                case STALK_BARE: {
                    if (!world.method_22347(pos.method_10074()) && !PlantFunctions.growFruitFlower((class_1922)world, pos, PlantAPI.Tree.BANANA)) break;
                    this.grow((class_1937)world, random, pos, state);
                    break;
                }
                case STALK_GROW: {
                    if (!world.method_22347(pos.method_10074()) && !PlantFunctions.growFruit((class_1922)world, pos, PlantAPI.Tree.BANANA)) break;
                    this.grow((class_1937)world, random, pos, state);
                }
            }
        }
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2680 state = super.method_9605(context);
        class_1799 stack = context.method_8041();
        if (state != null && stack.method_7909() instanceof ItemBlockLeaves) {
            state = (class_2680)state.method_11657(VARIANT, (Comparable)((Object)EnumType.byValue(ItemBlockLeaves.getType(stack))));
        }
        return state;
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        return ItemBlockLeaves.create(this.treeType, ((EnumType)((Object)state.method_11654(VARIANT))).ordinal());
    }

    public static class_2680 getFlowerVariant(class_2680 state) {
        if (state.method_26204() instanceof BlockLeavesBanana) {
            state = (class_2680)state.method_11657(VARIANT, (Comparable)((Object)EnumType.FLOWER));
        }
        return state;
    }

    public static enum EnumType implements class_3542
    {
        NORMAL("normal"),
        FLOWER("flower"),
        STALK_BARE("stalk_bare"),
        STALK_GROW("stalk_grow"),
        FRUIT("fruit");

        private final String name;

        private EnumType(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byValue(int index) {
            EnumType[] values = EnumType.values();
            return index < 0 || index >= values.length ? NORMAL : values[index];
        }
    }
}

